/* maketrig.h - trig table functions */

/* DONT FORGET TO DIVIDE THE TABLE VALUES BY SCALE_FACTOR !!!! */

#define SCALE_FACTOR 10000000
#define FAST_OFFSET(angle,size,table) ((table[angle]*size) / SCALE_FACTOR)

/* create a sin table with 'num_divs' angles */
int *create_sin_table(int num_divs);

/* create a cos table with 'num_divs' angles */
int *create_cos_table(int num_divs);

/* free up the memory used by a trig table (sin or cos) */
int *destroy_trig_table(int *table);

