/* fastmem.h - speed oriented memory allocation/deallocation
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** This fast memory object uses its own memory manager to avoid repeated calls
** to malloc(),free() etc.,  which can use up lots of processor time.  The
** main purpose of this object is for time critical applications.
**
** The objects' memory managment consists of looking after a heap which is
** allocated during initialisation. Once allocated, the heap is NOT resized,
** so be careful to choose a high enough value of "max_items" for your
** application.  The heap is divided into blocks of the given size,  and
** so this object is primary intended for fast malloc'ing and free'ing
** of structures OF THE SAME SIZE,  for example list and tree nodes.
**
** Error handling beyond the exit() approach is left to the reader.
**
** History:
** 10th feb 1995 initially coded and tested under DJGPP v1.11
** 19th feb 1995 portability mods after code DIES on Amiga 1000.
**               (source of problem derefrencing void pinter).
**               suggested addition: #ifdef'ed block checking (wiping etc).
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/
#ifndef FAST_MEM_H
#include <stdlib.h>

#define A_32_BIT unsigned int

typedef struct{
	A_32_BIT      *occupancy_flags;
	void          *heap;
	unsigned int  blocks_remaining;
	unsigned int  max_blocks;
	size_t        block_size;
}fast_mem;


       /* functions */

/* set up the fast memory block */
fast_mem *fastmem_init(unsigned int max_items,size_t block_size);

/* destroy the fast memory block */
fast_mem *fastmem_destroy(fast_mem *fmem);

/* clear all allocated fast memory */
void fastmem_clear(fast_mem *fmem);

/* allocate one block from the heap */
void *fastmem_allocate(fast_mem *fmem);

/* deallocate one block to the heap */
void *fastmem_deallocate(fast_mem *fmem,void *ptr);

/* get the number of unallocated blocks remaining */
unsigned int fastmem_blocks_remaining(fast_mem *fmem);



#define FAST_MEM_H  1
#endif  /* file */

