#include <stdio.h>
#include "fast_ll.h"
#include "f:\gcc\proj\fastmem\fastmem.h"

typedef struct{
      char *name;
      int age;
      char *address;
}id_record;

#define NUM_NODES 10

void main()
{
 int i;
 fast_ll *a_list;
 fast_mem *rec_mem;
 id_record *tp;
 id_record **record;

 a_list = fastll_init(NUM_NODES);
 rec_mem = fastmem_init(NUM_NODES,sizeof(id_record));

 record = malloc(NUM_NODES*sizeof(id_record *));

 printf("init done\n");fflush(stdout);

 for(i=0;i<NUM_NODES;i++){
     record[i] = (id_record *)fastmem_allocate(rec_mem);
     record[i]->age = i;
     fastll_add_before_current(a_list,(void *)record[i]);
     printf("%d %d\n",i,record[i]->age);
     printf("used = %d, free =%d\n",fastll_get_used_blocks(a_list),fastll_get_free_blocks(a_list));fflush(stdout);
     getch();
 }

 printf("list created\n");fflush(stdout);


 fastll_set_current_to_start(a_list);

 /* traverse list from start -> end */
 do{
   tp = fastll_get_data_pointer(a_list->current);
   printf("age =  %d\n",tp->age);fflush(stdout);
   fastll_move_current_forward(a_list);
 }while(!fastll_current_at_end(a_list));

 /* print last one */
 tp = fastll_get_data_pointer(a_list->current);
 printf("age =  %d\n",tp->age);fflush(stdout);

 fastll_destroy(a_list);
 printf("list destroyed OK.\n");

 fastmem_destroy(rec_mem);
 printf("data memory destroyed OK.\n");
}
