#ifndef OLEOBJ_H
#define OLEOBJ_H

#include "iclient.h"
#include "textwin.h"

enum OBJECT_TYPE {OBJ_STATIC,OBJ_EMBEDDED,OBJ_LINKED};

class DataTransfer;

class OleClientObj
{
friend DataTransfer;

protected:


ImpIUnknown		ifUnknown;
ImpIOleClientSite       ifClient;
ImpIAdviseSink		ifAdvise;

IStorage		*pIStg;
IStream			*pObjInfo;
IPersistStorage		*pPersist;

int			nRef;
int			nItem;
LRECT			rctlObj;
BOOL			bInit;
BOOL			bShade;
BOOL			valid;
OBJECT_TYPE		objType;
IOleObject		*pObject;
DWORD			dAdvise;
TextWindow		*pTextWindow;

void WriteObjInfo();
void Shade();
void Shade(HDC hDC);

public:

OleClientObj( TextWindow *txtParent,IStorage *pStg,int nItm,CLSID& clsid,long x,long y);
OleClientObj (LPSTORAGE pIMainStg,char *spObject,TextWindow *parent);
OleClientObj(LPSTORAGE pIMainStg,int nId,long x,long y,IDataObject *pIData,TextWindow *parent);

~OleClientObj();
void Draw();
void Draw(HDC hDC);
//void CopyToClipboard();
void Activate(LONG iVerb);
void OnViewChange();
void OnDataChange();
void OnClose();
void OnShow(BOOL bIsShown);
void SetFilename(char *spFilename);
void GetPreferredExtent();
void SetClientRect(LRECT& rctlNewObj);
char * GetStorageName();

HMENU CreateEditMenu(UINT idStart);

STDMETHODIMP_(ULONG) AddRef();
STDMETHODIMP_(ULONG) Release();
STDMETHODIMP QueryInterface(REFIID niid,LPVOID *ppInterface);
STDMETHODIMP SaveObject();

void ReleaseStorage();
void OpenStorage(LPSTORAGE pRootStg);
void OpenStorage();

inline LRECT *GetClientRect() {return &rctlObj;};
inline BOOL IsValid() {return valid;};
inline BOOL ContainsData() {return bInit;};
};

void ConvertFromPixelsToHiMetric(HWND hWnd,RECT& rctPix);
void ConvertFromHiMetricToPixels(RECT& rctObj);

#endif