#include <windows.h>
#include <ole2.h>

#include "oleobj.h"
#include "gdiobj.h"

#include "debug.h"

char OBJ_INFO[] = "\3Info";

struct ObjInfo {
	OBJECT_TYPE	objType;
	int		nItem;
	LRECT		rectlObj;
};

//
// Constructor to create a new object
//

OleClientObj::OleClientObj( TextWindow *txtParent,IStorage *pStg,int nItm,CLSID& clsid,long x,long y)
 : ifUnknown(this), ifClient(this), ifAdvise(this)
{
   HRESULT	hrr;

   nRef = 0;
   nItem = nItm;
   rctlObj.left = x;
   rctlObj.right = x + 20;
   rctlObj.top = y;
   rctlObj.bottom = y + 20;
   bInit = 0;
   bShade = FALSE;
   valid = FALSE;
   objType = OBJ_EMBEDDED;
   pObject = NULL;
   pObjInfo = NULL;
   pPersist = NULL;
   dAdvise = 0;

   pTextWindow = txtParent;

   hrr = pStg -> CreateStorage(GetStorageName(),STGM_READWRITE|STGM_SHARE_EXCLUSIVE,
	0,0,&pIStg);
   if (FAILED(hrr)){
	 return;
   }


   hrr = pIStg -> CreateStream(OBJ_INFO,STGM_DIRECT|STGM_READWRITE|STGM_SHARE_EXCLUSIVE,
	0,0,&pObjInfo);

   if (FAILED(hrr)) {
	return;
   }


   hrr = OleCreate(clsid,IID_IOleObject,OLERENDER_DRAW,NULL,&ifClient,pIStg,(LPVOID *)&pObject);
   if (FAILED(hrr)){
	return;
   }

   OleSetContainedObject(pObject,TRUE);
   pObject->Advise(&ifAdvise,&dAdvise);

   if (pPersist == NULL) {
	hrr = pObject->QueryInterface(IID_IPersistStorage,(LPVOID *)&pPersist);
	if (FAILED(hrr)) return;
   	pPersist->AddRef();
   }

   WriteObjInfo();

   valid = TRUE;
}
//
// Constructor to create an object from storage
//
OleClientObj::OleClientObj (LPSTORAGE pIMainStg,char *spObject,TextWindow *parent)
  : ifUnknown(this), ifClient(this), ifAdvise(this)
{
	HRESULT		hrr;
	ObjInfo		objInfo;
        ULONG		nBytes;

        nRef = 0;
	valid = FALSE;
        bShade = FALSE;
	pTextWindow = parent;

	pObject = NULL;
	pObjInfo = NULL;
   	pPersist = NULL;

	hrr = pIMainStg -> OpenStorage(spObject,NULL,STGM_TRANSACTED|STGM_READWRITE|
		STGM_SHARE_EXCLUSIVE,NULL,0,&pIStg);

	if (FAILED(hrr)) return;

	hrr = pIStg -> OpenStream(OBJ_INFO,NULL,STGM_DIRECT|STGM_READWRITE|
		STGM_SHARE_EXCLUSIVE,0,&pObjInfo);

	if (FAILED(hrr)) return;

	hrr = pObjInfo -> Read(&objInfo,sizeof(ObjInfo),&nBytes);
	if (FAILED(hrr) || (nBytes != sizeof(ObjInfo))) return;

	nItem = objInfo.nItem;
	rctlObj = objInfo.rectlObj;
	objType = objInfo.objType;

	hrr = OleLoad(pIStg,IID_IOleObject,&ifClient,(LPVOID *)&pObject);
	if (FAILED(hrr)) return;

	OleSetContainedObject(pObject,TRUE);
   	pObject->Advise(&ifAdvise,&dAdvise);

        if (pPersist == NULL) {
		hrr = pObject->QueryInterface(IID_IPersistStorage,(LPVOID *)&pPersist);
		if (FAILED(hrr)) return;

		pPersist->AddRef();
        }

	bInit = 1;
	valid = TRUE;
}

//
// Constructor to create and object from data
//

OleClientObj::OleClientObj(LPSTORAGE pIMainStg,int nItm,long x,long y,IDataObject *pIData,TextWindow *parent)
  : ifUnknown(this), ifClient(this), ifAdvise(this)
{
	HRESULT		hrr;
	ObjInfo		objInfo;
        ULONG		nBytes;

   nRef = 0;
   nItem = nItm;
   rctlObj.left = x;
   rctlObj.right = x + 20;
   rctlObj.top = y;
   rctlObj.bottom = y + 20;
   bInit = 0;
   bShade = FALSE;
   valid = FALSE;
   objType = OBJ_EMBEDDED;
   pObject = NULL;
   pObjInfo = NULL;
   pPersist = NULL;
   dAdvise = 0;

   pTextWindow = parent;

   hrr = pIMainStg -> CreateStorage(GetStorageName(),STGM_READWRITE|STGM_SHARE_EXCLUSIVE,
	0,0,&pIStg);
   if (FAILED(hrr)){
	 return;
   }

   hrr = pIStg -> CreateStream(OBJ_INFO,STGM_DIRECT|STGM_READWRITE|STGM_SHARE_EXCLUSIVE,
	0,0,&pObjInfo);

   if (FAILED(hrr)) {
	hrr = pIStg -> OpenStream(OBJ_INFO,NULL,STGM_DIRECT|STGM_READWRITE|
		STGM_SHARE_EXCLUSIVE,0,&pObjInfo);

	if (FAILED(hrr)) return;

   }
   WriteObjInfo();

   hrr = OleCreateFromData(pIData,IID_IOleObject,OLERENDER_DRAW,NULL,&ifClient,
	pIStg,(LPVOID *)&pObject);

   if (FAILED(hrr)) {
	return;
   }
   OleSetContainedObject(pObject,TRUE);
   pObject->Advise(&ifAdvise,&dAdvise);
   if (pPersist == NULL) {
   	hrr = pObject->QueryInterface(IID_IPersistStorage,(LPVOID *)&pPersist);
	if (FAILED(hrr)) return;
	pPersist->AddRef();
   }

   valid = 1;

   GetPreferredExtent();
}

OleClientObj::~OleClientObj()
{
   if (pObject && bShade) pObject->Close(OLECLOSE_NOSAVE);
   if (pObject && dAdvise) pObject->Unadvise(dAdvise);
   if (pPersist) pPersist->Release();
   if (pObjInfo) pObjInfo->Release();
   if (pIStg) pIStg -> Release();
   if (pObject) pObject->Release();
}

void OleClientObj::Activate(LONG iVerb)
{
    RECT	rctObj;
    HRESULT	hrr;

    if (objType == OBJ_STATIC) {
	MessageBeep(0);
	return;
    }
    FPRINTF (debug,"Activate: rctlObj = (%ld,%ld,%ld,%ld)\n",
    	rctlObj.left,rctlObj.top,rctlObj.right,rctlObj.bottom);
    pTextWindow -> ConvertLongRectToPixels(rctlObj,rctObj);
    FPRINTF (debug,"Activate: rctObj(HiMetric) = (%d,%d,%d,%d)\n",
    	rctObj.left,rctObj.top,rctObj.right,rctObj.bottom);


    hrr = pObject->DoVerb(iVerb, NULL, &ifClient, 0, pTextWindow->GetWindow(), &rctObj);
    if (FAILED(hrr)) {
	FPRINTF (debug,"Activate: Failure scode = %d,\n",GetScode(hrr)-OLE_E_FIRST);
        
    }


}

void OleClientObj::WriteObjInfo()
{
   ULARGE_INTEGER 	pos;
   LARGE_INTEGER	zero = {0,0} ;
   HRESULT		hrr;
   char			mess[100];

   ObjInfo		objInfo;

   objInfo.objType = objType;
   objInfo.nItem = nItem;
   objInfo.rectlObj = rctlObj;

   hrr = pObjInfo -> Seek(zero,STREAM_SEEK_SET,&pos);
   if (FAILED(hrr)) {
   	wsprintf (mess,"Seek Failed SCODE %d",GetScode(hrr));
	MessageBox(NULL,mess,"",MB_OK|MB_APPLMODAL|MB_ICONHAND);
   }

   hrr = pObjInfo -> Write(&objInfo,sizeof(ObjInfo),NULL);
   if (FAILED(hrr)) {
   	wsprintf (mess,"Write Failed  1 SCODE %d",GetScode(hrr));
	MessageBox(NULL,mess,"",MB_OK|MB_APPLMODAL|MB_ICONHAND);
   }

}

void OleClientObj::ReleaseStorage()
{
   pObjInfo -> Release();
   pObjInfo = NULL;
   pPersist->HandsOffStorage();
   pIStg -> Commit (STGC_DEFAULT);
   pIStg -> Release();
   pIStg = NULL;
}

void OleClientObj::OpenStorage(LPSTORAGE pRootStg)
{

   pRootStg -> OpenStorage(GetStorageName(),NULL,STGM_TRANSACTED|STGM_READWRITE|
      STGM_SHARE_EXCLUSIVE,NULL,0,&pIStg);

   OpenStorage();
}

void OleClientObj::OpenStorage()
{

   pPersist->SaveCompleted(pIStg);

   pIStg -> OpenStream(OBJ_INFO,NULL,STGM_DIRECT|STGM_READWRITE|STGM_SHARE_EXCLUSIVE,
	NULL, &pObjInfo);
}

char * OleClientObj::GetStorageName()
{
    static char name[80];

    wsprintf(name,"OBJECT%03d", nItem);
    return name;
}

STDMETHODIMP_(ULONG) OleClientObj::AddRef()
{
	nRef++;

	return nRef;
}

STDMETHODIMP_(ULONG) OleClientObj::Release()
{
	if (nRef > 0) nRef--;

	return nRef;
}

STDMETHODIMP OleClientObj::QueryInterface(REFIID niid,LPVOID *ppInterface)
{
	SCODE	sc;

	if (niid == IID_IUnknown) {
		*ppInterface = (LPVOID)&ifUnknown;
		sc = S_OK;
	}
	else if (niid == IID_IOleClientSite) {
		*ppInterface = (LPVOID)&ifClient;
		sc = S_OK;
	}
	else if (niid == IID_IAdviseSink) {
		*ppInterface = (LPVOID)&ifAdvise;
		sc = S_OK;
        }
	else {
		*ppInterface = NULL;
		sc = E_NOINTERFACE;
	}

	return ResultFromScode(sc);
}

STDMETHODIMP OleClientObj::SaveObject()
{
	HRESULT		herr;

	if (pPersist == NULL) {
		herr = pObject->QueryInterface(IID_IPersistStorage,(LPVOID *)&pPersist);
		if (FAILED(herr)) return herr;

		pPersist->AddRef();
        }

	herr = OleSave(pPersist,pIStg,TRUE);
	pIStg -> Commit(STGC_DEFAULT);
	pPersist->SaveCompleted(pIStg);


	return herr;
}

void OleClientObj::Draw()
{
	HDC 	hDC=GetDC(pTextWindow->hWindow);
	Draw(hDC);
	ReleaseDC (pTextWindow->hWindow,hDC);
}

void OleClientObj::Draw(HDC hDC)
{
	RECT	rctObj;

	if (!valid || !bInit) return;

	pTextWindow->ConvertLongRectToPixels(rctlObj,rctObj);
	FPRINTF (debug,"Draw: rctObj = (%d,%d,%d,%d)\n",
        	rctObj.left,rctObj.top,rctObj.right,rctObj.bottom);
	OleDraw (pObject,DVASPECT_CONTENT,hDC,&rctObj);
        if (bShade) Shade(hDC);
}


void OleClientObj::OnViewChange()
{
	LRECT		rctlOld;

        FPRINTF (debug,"OnViewChange: \n");
	rctlOld = rctlObj;
	GetPreferredExtent();
	if (rctlObj.right > rctlOld.right) rctlOld.right = rctlObj.right;
	if (rctlObj.bottom > rctlOld.bottom) rctlOld.bottom = rctlObj.bottom;
	FPRINTF (debug, "OnViewChange: Invalid Rect= (%ld,%ld,%ld,%ld)\n",
		rctlOld.left,rctlOld.top,rctlOld.right,rctlOld.bottom);
	pTextWindow->Redraw(rctlOld);
        pTextWindow->SetDirty();
}

void OleClientObj::OnDataChange()
{
	pTextWindow -> SetDirty();
}

void OleClientObj::OnClose()
{
	if (!valid || !bInit) {
		pTextWindow -> DeleteOleObject(this);
	}
	else {
		pTextWindow->Redraw(rctlObj);
	}
}

void OleClientObj::OnShow(BOOL bIsShown)
{
	bShade = bIsShown;
	if (!bInit) return;
	if (bShade) {
		Shade();
	}
	else {
		pTextWindow->Redraw(rctlObj);
	}
}

void OleClientObj::Shade()
{
	HDC 	hDC=GetDC(pTextWindow->hWindow);
	Shade(hDC);
	ReleaseDC (pTextWindow->hWindow,hDC);
}


void OleClientObj::Shade(HDC hDC)
{
	RECT		rctObj;
	LOGBRUSH	brHatch;
	HBRUSH		hHatch;
	HBRUSH		hOldHatch;

	pTextWindow->ConvertLongRectToPixels(rctlObj,rctObj);

	brHatch.lbStyle = BS_HATCHED;
	brHatch.lbColor = RGB(0,0,0);
	brHatch.lbHatch = HS_FDIAGONAL;

	hHatch = CreateBrushIndirect(&brHatch);
	hOldHatch = (HBRUSH)SelectObject(hDC,hHatch);

	UnrealizeObject(hHatch);
	SetBrushOrg(hDC,rctObj.left,rctObj.top);

	SetBkMode(hDC,TRANSPARENT);

	PatBlt(hDC,rctObj.left,rctObj.top,rctObj.right-rctObj.left,rctObj.bottom-rctObj.top,
		DSTINVERT);

	PatBlt(hDC,rctObj.left,rctObj.top,rctObj.right-rctObj.left,rctObj.bottom-rctObj.top,
		PATINVERT);

	SelectObject(hDC,hOldHatch);
	DeleteObject(hHatch);
}

void OleClientObj::SetFilename(char *spFilename)
{
	if (spFilename)
		pObject->SetHostNames("Collage",spFilename);
	else
		pObject->SetHostNames("Collage","Untitled");
}


void OleClientObj::GetPreferredExtent()
{
	SIZEL	size;
	POINT	pnt;
        HDC	hDC;

        if (!bInit) {
		pObject->GetExtent(DVASPECT_CONTENT,&size);
		pnt.x = (int)size.cx;
		pnt.y = (int)size.cy;
		FPRINTF (debug,"GetPreferredExtent: size = (%d,%d)\n",
                	pnt.x,pnt.y);
		hDC = GetDC(NULL);
                SetMapMode(hDC,MM_HIMETRIC);
		LPtoDP(hDC,&pnt,1);
                SetMapMode (hDC,MM_TEXT);
		ReleaseDC(NULL,hDC);
		if (pnt.x <= 10) pnt.x = 20;
		if (pnt.y >= -10) pnt.y = -20;
		rctlObj.right = rctlObj.left + pnt.x;
		rctlObj.bottom = rctlObj.top - pnt.y;
		WriteObjInfo();
		FPRINTF (debug,"GetPreferredExtent: rctlObj = (%ld,%ld,%ld,%ld)\n",
			rctlObj.left,rctlObj.top,rctlObj.right,rctlObj.bottom);
		bInit = 1;
        }
}

void OleClientObj::SetClientRect(LRECT& rctlNewObj)
{
	RECT	rctObj;
	SIZEL	sizel;

	if (((rctlNewObj.right - rctlNewObj.left) != (rctlObj.right-rctlObj.left)) ||
	    ((rctlNewObj.bottom - rctlNewObj.top) != (rctlObj.bottom-rctlObj.top))) {

	    rctObj.top = 0; rctObj.left = 0;
	    rctObj.bottom = (int)(rctlNewObj.bottom - rctlNewObj.top);
	    rctObj.right = (int)(rctlNewObj.right - rctlNewObj.left);

	    ConvertFromPixelsToHiMetric(NULL, rctObj);
	    sizel.cx = rctObj.right - rctObj.left;
	    sizel.cy = rctObj.top - rctObj.bottom;

	    pObject->SetExtent(DVASPECT_CONTENT,&sizel);
	}
	rctlObj = rctlNewObj;
	WriteObjInfo();
}

HMENU OleClientObj::CreateEditMenu(UINT idStart)
{
	HRESULT		hrr;
	SCODE		sc;
	HMENU		hMenu;
	ULONG		nEl;
	LPENUMOLEVERB 	pEnum;
	OLEVERB		rgelt;
	CLSID		clsid;
        int		nItems = 0;

	hrr = pObject -> EnumVerbs(&pEnum);
	sc = GetScode(hrr);
// if object requests that we use registration database, get enumerator to database verbs
	if (sc == OLE_S_USEREG) {
        	pObject -> GetUserClassID(&clsid);
		hrr = OleRegEnumVerbs(clsid,&pEnum);
		if (FAILED(hrr)) {
			return NULL;
		}
	}
	else if (sc != S_OK) {
		return NULL;
	}

	hMenu = CreatePopupMenu();
	nEl = 1;
	while (nEl) {
		pEnum -> Next(1,&rgelt,&nEl);
		if (nEl) {
			AppendMenu(hMenu,rgelt.fuFlags,idStart+rgelt.lVerb,
				rgelt.lpszVerbName);
                        nItems++;
		}
	}


	pEnum -> Release();

	return hMenu;
}

void ConvertFromPixelsToHiMetric(HWND hWnd,RECT& rctPix)
{
	HDC hDC;

	hDC = GetDC(hWnd);
	SetMapMode(hDC,MM_HIMETRIC);
	DPtoLP (hDC,(POINT *)&rctPix,2);
	SetMapMode(hDC,MM_TEXT);
	ReleaseDC(hWnd,hDC);
}

void ConvertFromHiMetricToPixels(RECT& rctObj)
{
	HDC	hDC;

	hDC = GetDC(NULL);
	SetMapMode(hDC,MM_HIMETRIC);
	LPtoDP (hDC,(POINT *)&rctObj,2);
	ReleaseDC(NULL,hDC);
}