#include <windows.h>
#include <ole2.h>
#include <alloc.h>

#include "oleobj.h"
#include "dataobj.h"
#include "debug.h"

extern UINT	cfEmbedSource;
extern UINT	cfEmbeddedObject;
extern UINT	cfObjectDescriptor;
extern char	OBJ_INFO[];

DataTransfer::DataTransfer(OleClientObj *pObj,const char * spDocTitle)
{
	HRESULT		hErr;
	IDataObject	*pIData;
	FORMATETC	fmtEtc;
	IEnumFORMATETC	*pEnum;
	UINT		cbSize;
	IMalloc		*pIMalloc;
	char		*spObjName;
	static char	szUntitled[] = "Untitled";
	char		*snbObjInfo[] = {OBJ_INFO,NULL};

	nFmt = 0;
	pIStg = NULL;
	fmtList = NULL;
	nRef = 0;
        valid = 0;

// Save a snapshot of the object
	hErr = StgCreateDocfile(NULL,STGM_DELETEONRELEASE| STGM_TRANSACTED | STGM_READWRITE
	    | STGM_CREATE
	    | STGM_SHARE_EXCLUSIVE,0,&pIStg);
	if (FAILED(hErr)) {
        	return;
	}
	pObj->pIStg->CopyTo(0,NULL,snbObjInfo,pIStg);
	pIStg -> Commit(STGC_ONLYIFCURRENT);

//
//  Create an Object Descriptor
//
	if (spDocTitle == NULL) spDocTitle = szUntitled;
	pObj->pObject->GetUserType(USERCLASSTYPE_FULL,&spObjName);

	cbSize = sizeof(OBJECTDESCRIPTOR)+lstrlen(spDocTitle)+lstrlen(spObjName)+2;
	hObjDesc = GlobalAlloc(GPTR|GMEM_SHARE,cbSize);
		
	pObjDesc = (OBJECTDESCRIPTOR *)GlobalLock(hObjDesc);

	pObjDesc->cbSize = cbSize;
	ReadClassStg(pIStg,&(pObjDesc->clsid));
	pObjDesc->dwDrawAspect = DVASPECT_CONTENT;
	pObj->pObject->GetExtent(DVASPECT_CONTENT,&pObjDesc->sizel);
	pObj->pObject->GetMiscStatus(DVASPECT_CONTENT,&pObjDesc->dwStatus);
	pObjDesc->dwFullUserTypeName = sizeof(OBJECTDESCRIPTOR);
	pObjDesc->dwSrcOfCopy = sizeof(OBJECTDESCRIPTOR) + lstrlen(spObjName)+1;

	lstrcpy((char *)pObjDesc + pObjDesc->dwFullUserTypeName,spObjName);
	lstrcpy((char *)pObjDesc + pObjDesc->dwSrcOfCopy,spDocTitle);

	CoGetMalloc(MEMCTX_SHARED,&pIMalloc);
	pIMalloc->Free(spObjName);
        pIMalloc->Release();
        

//
//  Enumerate the FORMATETC
//
	fmtList = (FORMATETC **)malloc(2 * sizeof(FORMATETC *));
	nFmt = 2;
	fmtList[0] = (FORMATETC *)malloc(sizeof(FORMATETC));
	fmtList[0]->cfFormat = cfObjectDescriptor;
	fmtList[0]->ptd = NULL;
	fmtList[0]->dwAspect = DVASPECT_CONTENT;
	fmtList[0]->lindex = -1;
        fmtList[0]->tymed = TYMED_HGLOBAL;

	fmtList[1] = (FORMATETC *)malloc(sizeof(FORMATETC));

	fmtList[1]->cfFormat = cfEmbeddedObject;
	fmtList[1]->ptd = NULL;
	fmtList[1]->dwAspect = DVASPECT_CONTENT;
	fmtList[1]->lindex = -1;
	fmtList[1]->tymed = TYMED_ISTORAGE;

	hErr = pObj->pObject->QueryInterface(IID_IDataObject,(LPVOID *)&pIData);
	if (SUCCEEDED(hErr) && (pIData->EnumFormatEtc(DATADIR_GET,&pEnum)==S_OK)) {
		while (pEnum->Next(1,&fmtEtc,NULL) == S_OK) {
			nFmt ++;
			fmtList = (FORMATETC **)realloc(fmtList,nFmt*sizeof(FORMATETC *));
			fmtList[nFmt-1] = (FORMATETC *)malloc(sizeof(FORMATETC));
			*fmtList[nFmt-1] = fmtEtc;
		}
		pEnum -> Release();
	}
	valid = 1;
	FPRINTF(debug,"data object created\n");
        FLUSH
}

DataTransfer::~DataTransfer()
{
	int	i;

	FPRINTF (debug,"data object destroyed\n");
        FLUSH
	if (pIStg) pIStg->Release();
	GlobalUnlock(hObjDesc);
        GlobalFree(hObjDesc);
	for (i=0; i<nFmt; i++) {
		free (fmtList[i]);
	}
	if (fmtList) free (fmtList);
}

STDMETHODIMP DataTransfer::DAdvise(FORMATETC FAR * pFmt,DWORD advf,LPADVISESINK pAdvise,DWORD FAR * pConn)
{
	return ResultFromScode(OLE_E_ADVISENOTSUPPORTED);
}

STDMETHODIMP DataTransfer::DUnadvise(DWORD dwConnect)
{
	return ResultFromScode(OLE_E_ADVISENOTSUPPORTED);
}

STDMETHODIMP DataTransfer::EnumDAdvise(LPENUMSTATDATA FAR *pEnum)
{
	*pEnum = NULL;
	return ResultFromScode(S_OK);
}
STDMETHODIMP DataTransfer::EnumFormatEtc(DWORD dwDirect,LPENUMFORMATETC FAR *pEnum)
{
	FPRINTF (debug,"EnumFormatEtc\n");
        FLUSH
	if (dwDirect != DATADIR_GET)
		return ResultFromScode(E_NOTIMPL);

	*pEnum = new DtFormatEtcEnum(this);
        (*pEnum)->AddRef();
	return ResultFromScode(S_OK);
}

STDMETHODIMP DataTransfer::GetCanonicalFormatEtc(LPFORMATETC pFmtIn,LPFORMATETC pFmtOut)
{
	pFmtOut->ptd = NULL;
	return ResultFromScode(S_OK);
}

STDMETHODIMP DataTransfer::GetData(LPFORMATETC pFmt,LPSTGMEDIUM pStgMed)
{
	HRESULT	hrr;
	IDataObject	*pObj;

	FPRINTF (debug,"GetData\n");
	FLUSH
	if ((pFmt->cfFormat == cfObjectDescriptor) &&
	    (pFmt->tymed == TYMED_HGLOBAL)) {

	    pStgMed->tymed = TYMED_HGLOBAL;
	    pStgMed->hGlobal = hObjDesc;
	    pStgMed->pUnkForRelease = this;
	    AddRef();

	    return ResultFromScode(S_OK);
	}
	if ((pFmt->cfFormat == cfEmbeddedObject) &&
	    (pFmt->tymed == TYMED_ISTORAGE)) {

	    pStgMed->tymed = TYMED_ISTORAGE;
	    pStgMed->pstg = pIStg;
	    pStgMed->pUnkForRelease = this;
	    AddRef();

	    return ResultFromScode(S_OK);
	}
	hrr = OleLoad(pIStg,IID_IDataObject,NULL,(LPVOID *)&pObj);
	if (FAILED(hrr)) return ResultFromScode(E_UNEXPECTED);

	hrr = pObj->GetData(pFmt,pStgMed);
	pObj->Release();
        return hrr;

}

STDMETHODIMP DataTransfer::GetDataHere(LPFORMATETC pFmt,LPSTGMEDIUM pStgMed)
{
	FPRINTF (debug,"GetDataHere\n");
        FLUSH
	if ((pFmt->cfFormat != cfEmbeddedObject) ||
	    ((pFmt->tymed != TYMED_ISTORAGE)&&(pFmt->tymed != TYMED_NULL)) ||
	    (pStgMed->tymed != TYMED_ISTORAGE))

		return ResultFromScode(E_INVALIDARG);

	pIStg->CopyTo(0,NULL,NULL,pStgMed->pstg);
//	if (pStgMed->pUnkForRelease) ReleaseStgMedium(pStgMed);

	return ResultFromScode(S_OK); 
}

STDMETHODIMP DataTransfer::QueryGetData(LPFORMATETC pFmt)
{
	int	i;
	FPRINTF (debug,"QueryGetData\n");
        FLUSH
	for (i=0; i<nFmt; i++) {
		if ((pFmt->cfFormat == fmtList[i]->cfFormat) &&
		    (pFmt->dwAspect == fmtList[i]->dwAspect) &&
		    (pFmt->lindex == fmtList[i]->lindex) &&
		    ((pFmt->tymed == fmtList[i]->tymed) ||
		     (pFmt->tymed == TYMED_NULL)))
			return ResultFromScode(S_OK);
	}
	return ResultFromScode(DATA_E_FORMATETC);
}

STDMETHODIMP DataTransfer::SetData(LPFORMATETC pFmt,LPSTGMEDIUM pStgMed,BOOL bRelease)
{
	return ResultFromScode(E_INVALIDARG);
}

STDMETHODIMP_(ULONG) DataTransfer::AddRef()
{
	FPRINTF(debug,"Data object AddRef\n");
        FLUSH
	return ++nRef;
}

STDMETHODIMP_(ULONG) DataTransfer::Release()
{
	int nr;

	nr = --nRef;
	FPRINTF (debug,"Data object Release nRef = %d\n",nRef);
	FLUSH
	if (nRef == 0) delete this;
	return nr;
}

STDMETHODIMP DataTransfer::QueryInterface(REFIID niid,LPVOID * ppvObj)
{
	if ((niid == IID_IUnknown) || (niid == IID_IDataObject)) {
		*ppvObj = this;
		AddRef();
		return ResultFromScode(S_OK);
	}
	else {
		*ppvObj = NULL;
		return ResultFromScode (E_NOINTERFACE);
	}
}



DtFormatEtcEnum::DtFormatEtcEnum (DataTransfer *pData)
{
	FPRINTF (debug,"Create Enum\n");
        FLUSH
	pIData = pData;
        pIData->AddRef();
	n = 0;
        nRef = 0;
}

DtFormatEtcEnum::~DtFormatEtcEnum()
{
	FPRINTF (debug,"Delete Enum\n");
	FLUSH
	pIData->Release();
}

STDMETHODIMP DtFormatEtcEnum::Next(ULONG celt,LPFORMATETC pFmt,ULONG  * pCeltFetch)
{
	ULONG nRet = 0;

	while ((n < pIData->nFmt) && (nRet < celt)) 
		pFmt[nRet++] = *pIData->fmtList[n++];

	if (pCeltFetch) *pCeltFetch = nRet;

	if (nRet > 0) return ResultFromScode(S_OK);

	return ResultFromScode(S_FALSE);
}

STDMETHODIMP DtFormatEtcEnum::Skip(ULONG celt)
{
	n += celt;
	if (n >= pIData->nFmt) {
		n = pIData->nFmt -1;
		return ResultFromScode(S_FALSE);
	}
	return ResultFromScode(S_OK);
}

STDMETHODIMP DtFormatEtcEnum::Reset()
{
	n = 0;
        return ResultFromScode(S_OK);
}

STDMETHODIMP DtFormatEtcEnum::Clone(IEnumFORMATETC ** pEnum)
{
	DtFormatEtcEnum		*pEnumDt;

	pEnumDt = new DtFormatEtcEnum(pIData);
	pEnumDt->n = n;

	*pEnum = pEnumDt;

	return ResultFromScode(S_OK);
}

STDMETHODIMP_(ULONG) DtFormatEtcEnum::AddRef()
{
	return ++nRef;
}

STDMETHODIMP_(ULONG) DtFormatEtcEnum::Release()
{
	ULONG	nr;

	nr = --nRef;
	if (nr == 0) delete this;

	return nr;
}

STDMETHODIMP DtFormatEtcEnum::QueryInterface(REFIID niid,LPVOID * ppvObj)
{
	if ((niid == IID_IUnknown) || (niid == IID_IEnumFORMATETC)) {
		*ppvObj = this;
		return ResultFromScode(S_OK);
	}
	else {
		*ppvObj = NULL;
		return ResultFromScode (E_NOINTERFACE);
	}
}

