#include <windows.h>
#include <ole2.h>
#include <initguid.h>
#include <oleguid.h>
#include <coguid.h>
#include "mainwin.h"
#include "wdres.h"
#include "gdiobj.h"
#include "debug.h"



int	bDebug = 0;
FILE	  *debug = NULL;

char	* MainWindowClass = "MainWindow";
char	 * TextWindowClass = "TextWindow";

HCURSOR	hPlain;
HCURSOR	hVertArrow;
HCURSOR	hHorizArrow;
HCURSOR hSwArrow;
HCURSOR	hNwArrow;
HCURSOR	hWaitCursor;

HBITMAP	hMarkFore;
HBITMAP	hMarkBack;

UINT	cfNative;
UINT	cfEmbedSource;
UINT	cfEmbeddedObject;
UINT	cfObjectDescriptor;

int pascal WinMain (HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmndLine,
	int nCmndShow)
{
	int		 	nMsg;
	WNDCLASS		wndClass;
	MainWindow	*Main;
	HACCEL		hAccel;
	MSG			msg;

	nMsg = 96;
	while (!SetMessageQueue (nMsg)&& (nMsg > 8))nMsg -= 8;
        if (bDebug)
		debug = fopen("debug.txt","w+");
        FPRINTF (debug,"Starting Collage\n");
	if (hPrevInstance == NULL) {
		wndClass.style = 0;
		wndClass.lpfnWndProc = BasicWindow::Dispatch;
		wndClass.cbClsExtra = 0;
		wndClass.cbWndExtra = sizeof (long);
		wndClass.hInstance = hInstance;
		wndClass.hIcon = LoadIcon (hInstance,MAKEINTRESOURCE(ICON_1));
		wndClass.hCursor = LoadCursor (NULL,IDC_ARROW);
		wndClass.hbrBackground = (HBRUSH)GetStockObject (WHITE_BRUSH);
		wndClass.lpszMenuName = MAKEINTRESOURCE(MAIN_MENU);
		wndClass.lpszClassName = MainWindowClass;

		RegisterClass (&wndClass);

		wndClass.style = CS_DBLCLKS;
		wndClass.lpfnWndProc = BasicWindow::Dispatch;
		wndClass.cbClsExtra = 0;
		wndClass.cbWndExtra = sizeof(long);
		wndClass.hInstance = hInstance;
		wndClass.hIcon = NULL;
		wndClass.hCursor = (HCURSOR) LoadCursor (NULL, IDC_CROSS);
		wndClass.hbrBackground = (HBRUSH) GetStockObject (WHITE_BRUSH);
		wndClass.lpszMenuName = NULL;
		wndClass.lpszClassName = TextWindowClass;

		RegisterClass (&wndClass);
	 }

	 if (FAILED(OleInitialize(NULL))) {
		MessageBox (NULL,"Error...","Cannot initialize OLE 2 LIbrary",
			MB_OK|MB_APPLMODAL|MB_ICONSTOP);
		return (0);
	 }

	 hAccel = LoadAccelerators (hInstance,MAKEINTRESOURCE(ACC_MAIN));

	hPlain = LoadCursor(NULL, IDC_CROSS);
	hVertArrow = LoadCursor(NULL, IDC_SIZENS);
	hHorizArrow = LoadCursor(NULL, IDC_SIZEWE);
	hNwArrow = LoadCursor(NULL, IDC_SIZENWSE);
	hSwArrow = LoadCursor(NULL, IDC_SIZENESW);
	hWaitCursor = LoadCursor(NULL, IDC_WAIT);

	hMarkFore = LoadBitmap(hInstance,MAKEINTRESOURCE(IBM_MARKFORE));
	hMarkBack = LoadBitmap(hInstance,MAKEINTRESOURCE(IBM_MARKBACK));

        cfNative = RegisterClipboardFormat("Native");
	cfEmbedSource = RegisterClipboardFormat("EmbedSource");
	cfObjectDescriptor = RegisterClipboardFormat("Object Descriptor");
	cfEmbeddedObject = RegisterClipboardFormat("Embedded Object");

	 Main = new MainWindow (hInstance,"Collage",nCmndShow);
	 Main -> Create();

	 while (GetMessage (&msg, NULL, 0, 0)) {
		if (!TranslateAccelerator(Main->GetWindow(),hAccel,&msg)) {
			TranslateMessage (&msg);
			DispatchMessage (&msg);
		}
	 }

	 OleUninitialize();

	DeleteObject(hMarkFore);
	DeleteObject(hMarkBack);

	DestroyCursor(hPlain);
	DestroyCursor(hVertArrow);
	DestroyCursor(hHorizArrow);
	DestroyCursor(hNwArrow);
	DestroyCursor(hSwArrow);
	DestroyCursor(hWaitCursor);

	 FPRINTF(debug,"Ending Collage\n");
	 if (bDebug) fclose(debug);
	 return 0;
}