/* bob.c - the main routine */
/*
        Copyright (c) 1991, by David Michael Betz
        All rights reserved
*/

#include <setjmp.h>
#include <malloc.h>
#include "bob.h"

/*** Revision history

        1.0     08/15/91        Initial version for DDJ article.
        1.1     08/20/91        Fixed do_for to allow null statements.
        1.2     08/28/91        Fixed problem with newobject().
        1.3     09/27/91        Fixed a bug in compact_vector().
        1.4     10/09/91        Reworked for Windows 3 - part 1.
        1.5     10/12/91        Various bug fixes.  Added gc().
        1.6     08/05/94        Fixed operator precedence bug in assignment.
        
*/


/* global variables */
jmp_buf error_trap;
char **bobargv;
int bobargc;

/* external variables */
extern int decode,trace;
extern VALUE symbols;
extern VALUE stdin_iostream;
extern VALUE stdout_iostream;
extern VALUE stderr_iostream;

/* forward declarations */
static void compile_file(char *);
static void add_file(char *,FILE *,VALUE *);

/* main - the main routine */
main(argc,argv)
  int argc; char *argv[];
{
    char fullname[20];
    int i;

    /* display the banner */
    osputs(BOBVERS);
    osputs("\n");

    /* initialize */
    initialize(SMAX);
    init_compiler();
    bobargc = argc - 1;
    bobargv = argv + 1;

    /* setup the standard i/o streams */
    add_file("stdin",stdin,&stdin_iostream);
    add_file("stdout",stdout,&stdout_iostream);
    add_file("stderr",stderr,&stderr_iostream);

    /* load and execute some code */
    for (i = 1; i < argc; ++i)
        if (strcmp(argv[i],"-d") == 0)
            decode = 1;
        else if (strcmp(argv[i],"-t") == 0)
            trace = 1;
        else {
            strcpy(fullname,argv[i]);
            strcat(fullname,".bob");
            compile_file(fullname);
        }
    if ( ! execute ("main", 0, NULL ) ) {
        printf("Error: executing 'main'\n");
    }
}

/* compile_file - compile definitions in a file */
static void compile_file(name)
  char *name;
{
    FILE *ifp;
    if ((ifp = fopen(name,"r")) != NULL) {
        compile_definitions(fgetc,ifp);
        fclose(ifp);
    }
}

/* info - display progress information */
void info(char *fmt,...)
{
    char buf[256];
    va_list ap;
    va_start(ap,fmt);
    vsprintf(buf,fmt,ap);
    va_end(ap);
    fprintf(stderr,"%s\n",buf);
}

/* error - print an error message and exit */
void error(char *fmt,...)
{
    char buf[256];
    va_list ap;
    va_start(ap,fmt);
    vsprintf(buf,fmt,ap);
    va_end(ap);
    fprintf(stderr,"Error: %s\n",buf);
    longjmp(error_trap,1);
}

void osputs(str)
  char *str;
{
    fputs(str,stderr);
}

/* add_file - add a built-in file */
static void add_file(name,fp,pval)
  char *name; FILE *fp; VALUE *pval;
{
    extern IODISPATCH fileio;
    DICT_ENTRY *sym;
    sym = addentry(&symbols,name,ST_SDATA);
    set_iostream(&sym->de_value,newiostream(&fileio,fp));
    *pval = sym->de_value;
}
