// build map file -- MS-specific

#include "mapman.h"
#include "mmnehead.h"

// Assumes the following mapfile format (generated by MS linkers)
//   i) Module name
//  ii) Segment Table, with format segno:start size name type
// iii) Auto DS (with format segno:0 DGROUP)
//  iv) Exports
//   v) Publics by Name
//  vi) Publics by Value
// vii) Entry Point

int BuildMapFile()
{
  DWORD EntryPoint ;

  myprintfStr( "\n " ) ;
  myprintfStr( GetModuleName() ) ;

  myprintfStr( "\n\n Start     Length     Name                   Class\n " ) ;
  DumpSegmentList() ;

  myprintfStr( "\n Origin   Group\n " ) ;
  myprintfFormatInt( "%04X:", pNE->nAutoDS ) ;
  myprintfFormatInt( "%X   DGROUP", 0 ) ;

  myprintfStr( "\n\n Address   Export                  Alias\n\n " ) ;
  DumpEntryPointList() ;

  myprintfStr( "\n  Address         Publics by Name\n\n " ) ;
  DumpPublicsByName() ;

// MapSym looks for the string 'Publics by Value' (note case) to find public symbols
  myprintfStr( "\n  Address         Publics by Value\n\n " ) ;
  DumpPublicsByValue() ;

// No space characters can exist before the phrase 'Program entry...'
  myprintfStr( "\nProgram entry point at " ) ;
  EntryPoint = pNE->EntryPoint ;
  myprintfBuildFarPtr( HIWORD( EntryPoint ), LOWORD( EntryPoint ) ) ;
  myprintfStr( "\n" ) ;

  return( RC_OK ) ;
}

// skips HowMuch space characters (less the number of
//   characters in PrevString, which must be null-terminated)
//   Returns the number of spaces we skipped
int myTabAsSpaces( char* PrevString, int HowMuch )
{
   int ThisMuch ;

   while( *(PrevString)++ )
     HowMuch-- ;

   ThisMuch = HowMuch ;       // ThisMuch = number of space characters printed

   while ( HowMuch-- > 0 )
     myprintfFormatStr( " ", NULL ) ;

   return( ThisMuch ) ;
}

