#include "mapman.h"
#include "mmmzhead.h"
#include "mmnehead.h"

int main( int argc, char *argv[] )
{
  int rc = RC_OK ;

  ProcessArgs( argc, argv ) ;      // process user args

  if (NULL == pExeName)            // help was given in ProcessArgs(), so exit
  {
     rc = RC_NOARG ;
  }
  else
  {
     AllocBuffer() ;               // get a buffer to load our executable into
     rc = LoadExe( pExeName ) ;    // generate MAP file to stdout!
     FreeBuffer() ;
  }

  return rc ;
}

// load and (if NE header) process our executable
BOOL LoadExe( char *pExeName )
{
  int hExe ;
  BOOL rc ;

  hExe = myFileOpen( pExeName ) ;
  if ( FALSE == hExe )
  {
     // file not found
     myprintfFormatStr( "Mapman:  File '%s' not found!\n", pExeName ) ;
     return( RC_CANTFINDEXE ) ;
  }

  myFileSeek( hExe, 0, SEEK_BEGIN);       // offset of old exe hdr in file...
                                          //   myFileOpen will actually put
                                          //   us at the start of the MZ header
                                          //   (offset 0, if one exists) but
                                          //   this is here for completeness

  myFileRead( hExe, pBuffer, BUFFERSIZE );

  // at this point, pBuffer points to the start of the MZ header, if
  //    it exists
  rc = SetMZ ( pBuffer )  ;
  if ( FALSE == rc )
  {
     // bad exe -- could be .COM file or non-executable
     myprintfStr( "Mapman:  No old-style (MZ) header found!" ) ;
     return( RC_NOOLDEXE ) ;
  }

  // stop processing if it is just a plain vanilla EXE
  if ( pMZ->RelocationTableAddress < 0x40 )
  {
     myprintfStr( "Mapman:  Only DOS (MZ) header found!" ) ;
     return( RC_NONEWEXE ) ;
  }

  rc = SetNE ( ) ;
  if ( FALSE == rc )
  {
     // not NE -- could be LE or LX, for example...
     switch ( pNE->MagicNumber )
     {
        case LE_SIGVALUE:     // Win VxDs
          myprintfStr( "Mapman:  LE header found -- VxD!" ) ;
          break ;
        case LX_SIGVALUE:     // os/2 32-bit
          myprintfStr( "Mapman:  LX header found -- OS/2 app!" ) ;
          break ;
        case PE_SIGVALUE:     // win32
          myprintfStr( "Mapman:  PE header found -- win32 app!" ) ;
          break ;
        case WIN386_SIGVALUE: // Win386.exe
          myprintfStr( "Mapman:  W3 header found -- win386.exe!" ) ;
          break ;
        default:
          myprintfStr( "Mapman:  Unknown header found!" ) ;
     }

     return(FALSE) ;
  }
  // if we got to here, then we have a valid NE header.  We could be looking
  //   at a 16-bit Windows app, a 16-bit os/2 PM app or a 16-bit OS/2 bound
  //   executable.
  // now extract map file
  //   each of the following calls builds elements of our entrypoint list
  BuildResidentNamesTable() ;
  BuildNonResidentNamesTable() ;

  // ... then the entry table routine will associate each entrypoint elt with
  //   a CS:IP
  BuildEntryTable() ;

  // the map file will also need a segment table so build it now...
  BuildSegmentTable() ;

  // now we have all the information that we need to generate a .MAP file...
  BuildMapFile() ;

  FreeLists() ;

  return(TRUE) ;
}

