// mapdutil.c (dos utils) -- these are routines specific to the DOS version
//     of this executable.  Every other module should be straight C with no
//     platform dependencies.  Each platform will have its mapXutil.c file...
//   Note that it is OK for this module to be platform dependent and
//     library calls are permitted here

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mapman.h"

BOOL ProcessArgs( int cbArg, char *pArgs[] )
{
  int thisarg = 1 ;

  fputs( "\tMapMan:  the map file manager for 16-bit Windows apps,\n",
          stderr ) ;
  fputs( "\t\t   by Joseph Hlavaty, JHlavaty@aol.com\n\n", stderr ) ;
  fputs( "\t\t   ALPHA RELEASE\n\n", stderr ) ;

  if ( 1 == cbArg )    // only MAPMAN <Enter> was typed, the user wants help...
  {
    printf("\tusage:  MAPMAN <executable file>\n") ;
    printf("\t\t  '-v' will give verbose output\n") ;

    printf("\n\tOutput can be redirected to a file to create a .MAP file,\n") ;
    printf("\t\t  e.g. MAPMAN PROGMAN.EXE >PROGMAN.MAP\n") ;
    printf("\t\t  Then create a .SYM file with MAPSYM PROGMAN\n") ;

    return FALSE ;
  }

  // process commands until done (thisarg == cbArg)
  while ( thisarg != cbArg )
  {
    // is this a parameter or a file name?
    if ( ( '-' == pArgs[thisarg][0] ) ||
         ( '/' == pArgs[thisarg][0] ) )
    { // ... a parameter
       switch(tolower(pArgs[thisarg][1]))
       {
         case 'v':
           bVerbose = TRUE ;
           break;
         default:
           printf("MAPMAN:  unsupported option '%s'\n", pArgs[thisarg]) ;
       }
    }
    else
    { // ... otherwise it is a file name...
       pExeName = pArgs[thisarg] ;
    }

    thisarg++ ;
  }                         // increment count of arguments processed


  return(TRUE) ;
}

BOOL AllocBuffer()
{
  if (NULL == ( pBuffer = malloc ( BUFFERSIZE * sizeof( char ) ) ) )
  {
     return(FALSE) ;
  }

  return(TRUE) ;
}

BOOL FreeBuffer()
{
  if ( pBuffer )
  {
     free( pBuffer ) ;
     pBuffer = NULL ;
  }

  return(TRUE) ;
}

int myFileOpen( char *pExeName )
{
  char szBuffer[64] ;
  FILE *flExe ;

  strcpy( szBuffer, pExeName ) ;
  if ( !strchr( szBuffer, '.' ) )
  {
     strcat( szBuffer,".exe" ) ;
  }

// open file as binary to avoid translation...
//   otherwise the pointers in the NE may not be valid!
  if ( NULL == ( flExe = fopen( szBuffer,"rb" ) ) )
  {
     return(FALSE) ;
  }

  return( (int) flExe ) ;
}

int myFileSeek( int hExe, int offset, int direction )
{
  fseek( (FILE *) hExe, offset, direction ) ;
  return(RC_OK) ;
}

int myFileRead( int hExe, char *pBuffer, int cbBuffer )
{
  fread ( pBuffer, sizeof(char), cbBuffer, (FILE *) hExe ) ;
  return(RC_OK) ;
}

int DebugString( char *pstr )
{
#ifdef DEBUGMESSAGES
  printf( "%s\n", pstr ) ;
#endif // DEBUGMESSAGES
  return(RC_OK) ;
}

int DebugInt( int myint )
{
#ifdef DEBUGMESSAGES
  printf( "%X\n", myint ) ;
#endif // DEBUGMESSAGES
  return(RC_OK) ;
}

// prints an ASCIIZ  (null-terminated) string to STDOUT
int myprintfStr( char *pstr )
{
  printf( "%s", pstr ) ;
  return(RC_OK) ;
}

// prints an int (using hexidecimal representation) to STDOUT
int myprintfInt( int myint )
{
  printf( "%X", myint ) ;
  return(RC_OK) ;
}

// prints a far pointer ( FFFF:0000 ), given a segment and an offset
int myprintfBuildFarPtr( int seg, int offset )
{
  printf( "%04X:%04X", seg, offset ) ;
  return(RC_OK) ;
}

// prints an int (using user formatting) to STDOUT
int myprintfFormatInt( char* format, int value )
{
  printf( format, value ) ;
  return(RC_OK) ;
}

// prints a string (using user formatting) to STDOUT
int myprintfFormatStr( char* format, char *str )
{
  printf( format, str ) ;
  return(RC_OK) ;
}

// allocate a block of memory
void *mymalloc( int iSizeToAlloc )
{
   return( malloc ( iSizeToAlloc ) ) ;
}

// free a block of memory allocated by mymalloc()
void myfree( void *pMem )
{
   free( pMem ) ;
}

// return to our OS with return code 'rc'
void myexit( int rc )
{
   _exit( rc ) ;
}

