# include "stdio.h"
# include "math.h"
# include "mcodef.h"


int accept(int dim, float par_vec[], int adapt, int *finish_ptr,
           float constraint[], int *nocont)
/**C*F****************************************************************
**                                                                  **
** SRC-FUNCTION   :accept()                                         **
** LONG_NAME      :accept                                           **
**                                                                  **
** AUTHOR         :Dr. Rainer Storn                                 **
**                                                                  **
** DESCRIPTION    :accept() tests whether a parameter vector        **
**                 par_vec[] falls into the region of acceptability **
**                 (ROA). If it does hit=1 is returned, otherwise   **
**                 hit=0.                                           **
**                                                                  **
** FUNCTIONS      :none                                             **
**                                                                  **
** GLOBALS        :none                                             **
**                                                                  **
** PARAMETERS     :dim          number of vector elements.          **
**                 par_vec[]    contains the vector with dim        **
**                              gaussian distributed variables.     **
**                 adapt        control variable.                   **
**                              0 : no adaptation of ROA            **
**                              1 : adaptation of ROA permitted     **
**                                  (shrinkage)                     **
**                              2 : adaptation of ROA permitted     **
**                                  (relaxation, expansion)         **
**                 finish_ptr   indicates meeting of requirements.  **
**                              0 : goals not yet reached.          **
**                              1 : goals has been reached.         **
**                 constraint[] contains current constraints of ROA.**
**                 *nocont      contains number of constraints.     **
**                                                                  **
** PRECONDITIONS  :par_vec[] must contain valid parameter vector.   **
**                                                                  **
** POSTCONDITIONS :Elements of constraint[] will probably be altered.*
**                 nocont returns number of constraints to assist   **
**                 printing routine of main().                      **
**                                                                  **
***C*F*E*************************************************************/
{
  int   hit, i, n;
  float goal[NARY], z0, x, y;

/*------Set up constraints----------------------------------------------*/

  goal[0] = 1.e-7;    /* may-constraint  */
  *nocont = 1;        /* one constraints */

/*------Calculate function values and initializations-------------------*/

  z0 = 0.0;               /* mean squared error */

  for (i=0; i<100; i++)
  {
    y = 0.0;
    x = (float)i*pi*0.005;

    for (n=dim-1; n>0; n=n-1)
      {
        y = (y + par_vec[n])*x;
      }
    y = y + par_vec[0];

    z0 = z0 + (sin(x) - y)*(sin(x) - y);
  }

  z0 = z0*0.01;

  hit  = 1;


/*------Relax constraints if adapt equals 2.---------------------------------*/


  if (adapt == 2)
  {
    for (i=0; i<=0; i++)  /* Initialize constraints to goal values */
    {
      constraint[i] = goal[i];
    }

/*--Relax may-constraints as required----------------------------------------*/

    if (z0 > constraint[0]) constraint[0] = z0;

  }
  else if (adapt == 1)
  {
    if (z0 <= constraint[0])
    {
      if (z0 > goal[0]) constraint[0] = z0;   /* adapt may-constraint only if  */
      else constraint[0] = goal[0];           /* goal is not reached yet.      */
    }
    else
    {
      hit = 0;
    }
  }
  else
  {
    if (z0 > constraint[0]) hit = 0;
  }


  *finish_ptr = 0;
  if (constraint[0] <= goal[0]) *finish_ptr = 1;

  return(hit);

}
