Unit FSwap; { FIDO unit for handling swap out and execute }
 (***************************************************************************

            RELEASE 1.01 - as contained in the file PRUS101.LZH
                by Peter Holschbach, 2:2450/660.3, GERMANY

               --------------------------------------------
                organized for Fido's PASCAL related echoes
               --------------------------------------------

     08/28/1994 to --/--/---- by Peter Holschbach, 2:2450/660.3,  GERMANY


           As far as third party copyrights are not violated this
           source code is hereby placed to the public domain. Use
           it whatever way you want, but use AT YOUR OWN RISK.

           In case you should modify the source rather send your
           modifications to the unit's current organizer (see above for
           NM address) than to spread it on your own. This will help to
           keep the unit updated and grant a certain standard to all
           other users as well.

           The unit is currently still under work. So it might greatly
           benefit of your participation.

           Those who contributed to the following piece of source,
           listed in alphabethical order:
        ================================================================
           Peter Holschbach ...
        ================================================================
           YOUR NAME WILL APPEAR HERE IF YOU CONTRIBUTE USEFUL SOURCE.

           Credits in your own programs are as welcome as unnecessary.

 ***************************************************************************)

{$I FDEFINE.DEF}


Interface

Type    TSwapMem = (XMS,EMS,DISK,None);
        TSwapMemSelect = Array [1..3] of TSwapMem;

Const  CSwapToAll  :  TSwapMemSelect = (EMS,XMS,DISK);
       CSwapToEMS  :  TSwapMemSelect = (EMS,None,None);
       CSwapToDISK :  TSwapMemSelect = (DISK,None,None);
       CSwapToXMS  :  TSwapMemSelect = (XMS,None,None);



Var
        DosRetValue  : Word;
        SwapError    : Word;
        SwapFilePath : String;




Function ExecSwap (LastAdr : Pointer; WhereToSwap : TSwapMemSelect;ProgName,Parameters : String): Boolean;

Implementation

{----------------------------------------------------------------------------}

{$L fswap.obj}

Function SwapExec (FileName,Parameters : String; LastAdr : Pointer; Methode : TSwapMem): Word; far; external;

Function ExecSwap (LastAdr : Pointer; WhereToSwap : TSwapMemSelect;ProgName,Parameters : String): Boolean;

Var L       : Byte;

Begin
  L := 0;
  If (Length (ProgName) > 79) then Progname [0] := Chr (79);
  If (Length (Parameters) > 126) then Parameters [0] := Chr (126);
  DosRetValue := $FFFF;
  Repeat
    INC (L);
    Case WhereToSwap [L] of
      EMS  : Begin
               SwapError := SwapExec (ProgName,Parameters,LastAdr,EMS);
             End;
      XMS  : Begin
               SwapError := SwapExec (ProgName,Parameters,LastAdr,XMS);
             End;
      DISK : Begin
               SwapError := SwapExec (ProgName,Parameters,LastAdr,DISK);
             End;
    End;
  Until (SwapError = 0) or (L = 3);
  ExecSwap := (SwapError = 0);
End;


Begin
  SwapFilePath := '';
End.