unit fansi;

 { FIDO unit to allow access to the Ansi-Routines
 (*************************************************************************)

	 RELEASE 1.00 - as first contained in the file PRUS101.LZH
		by Matthias Tichy, 2:2440/210.14, GERMANY

	       --------------------------------------------
		organized for Fido's PASCAL related echoes
	       --------------------------------------------

     09/11/1994 to --/--/---- by Matthias Tichy, 2:2440/210.14, GERMANY


	   As far as third party copyrights are not violated this
	   source code is hereby placed to the public domain. Use
	   it whatever way you want, but use AT YOUR OWN RISK.

	   In case you should modify the source rather send your
	   modifications to the unit's current organizer (see above for
	   NM address) than to spread it on your own. This will help to
	   keep the unit updated and grant a certain standard to all
	   other users as well.

	   The unit is currently still under work. So it might greatly
	   benefit of your participation.

	   Those who contributed to the following piece of source,
	   listed in alphabethical order:
	================================================================
        Matthias Tichy ...
	================================================================
	   YOUR NAME WILL APPEAR HERE IF YOU CONTRIBUTE USEFUL SOURCE.

	   Credits in your own programs are as welcome as unnecessary.

(***************************************************************************}

{$I FDEFINE.DEF} { Use the general include file for conditional defines and
		   common compiler directives ... }

		 { ... and set the unit's specific defines aftwerwards. }

interface

const
  Ansi_ClrScr = #27+'[2J';
  Ansi_NoAtr = #27+'[0m';
  Ansi_High = #27+'[1m';

  Ansi_fore_Black = #27+'[30m';
  Ansi_fore_Red = #27+'[31m';
  Ansi_fore_Green = #27+'[32m';
  Ansi_fore_Yellow = #27+'[33m';
  Ansi_fore_Blue = #27+'[34m';
  Ansi_fore_Magenta = #27+'[35m';
  Ansi_fore_Cyan = #27+'[36m';
  Ansi_fore_White = #27+'[37m';

  Ansi_Back_black = #27+'[40m';
  Ansi_Back_Red = #27+'[41m';
  Ansi_Back_Green = #27+'[42m';
  Ansi_Back_Yellow = #27+'[44m';
  Ansi_Back_Blue = #27+'[44m';
  Ansi_Back_Magenta = #27+'[45m';
  Ansi_Back_Cyan = #27+'[46m';
  Ansi_Back_White = #27+'[47m';

function isAnsi : Boolean;

implementation

{$IFDEF VER70}

function isAnsi : Boolean; assembler;

asm
  mov ax, 1A00h
  int 2Fh
  mov ah, $1
  cmp al, $ff
  JE @@1
  mov ah, $0
@@1:
end;

{$ELSE}

uses dos;

var
  R : Registers;

function isAnsi : boolean;

begin
  isAnsi := false;
  R.AX := $1A00;
  Intr($2F, R);
  if R.AL <> $FF then isAnsi := true;
end;

{$ENDIF}

end.
