{$X+,B-,V-} {essential compiler directives}

program volstat;

{ Example for the nwFile unit / NwTP 0.6 API. (c) 1993,1995, R.Spronk }

{ Purpose: Lists all volume information for each volume on all
           servers logged in to. If used with the parameter 'c',
           the volume information will be displayed in a condensed
           form and will be updated every 5 seconds.

Tests the following functions in the nwDir Unit:

 GetVolumeUsage
 GetVolumeName
 GetVolumeNumber


(3410)  Thu 10 Feb 94 11:24
By: Frank Van.Wensveen
To: All
Re: MULTISERVER VOLINFO
St:
------------------------------------------------------------
Ik zoek z.s.m. een utility waarmee ik de volspace van meerdere
servers tegelijk in de gaten kan houden. Een soort multi-server
VolInfo dus. Er zijn pakketten om dat heel mooi te doen (ik heb
er zelfs een ter evaluatie liggen momenteel) maar ik zoek nu
even snel (want de nood is hoog) iets eenvoudigs.

FVW

---
 * Origin: * NGN Point-Service -31-4752-6190 * (2:512/250) }

Uses Crt,nwMisc,nwBindry,nwConn,nwFile;

CONST testing=TRUE;

Var volNbr:Byte;
    volumeName:String;
    volInfo:TvolUsage;
    cont:Boolean;
    ConnId,OldConnId:Byte;
    ServerName:string;
    version:word;

Begin
If NOT (IsShellLoaded and IsUserLoggedOn)
 then begin
      writeln('VolStat requires:');
      writeln('  -The shell to be loaded;');
      writeln('  -You to be logged in.');
      halt(1);
      end;

GetNWversion(version);
if version<300
 then begin
      writeln('Netware 3.x only.');
      halt(1);
      end;

cont:=(ParamCount>0) and ((pos('c',paramstr(1))>0) or (pos('C',paramStr(1))>0));

GetPreferredConnectionId(OldConnId);
REPEAT
 clrscr;
 For ConnId:=1 to MaxServers
  do begin
     IF GetFileServerName(connId,ServerName)
      then begin
           SetPreferredConnectionId(connId);
           volNbr:=0;
           While volNbr<32
           do begin

              If GetVolumeUsage(volNbr,volInfo)
               then with volInfo
                     do begin
                        if cont { condensed output }
                         then begin
                              writeln('\\'+Servername+'\'+VolumeName);
                              writeln('  VS: ',totalblocks*(sectorsPerBlock div 2),' ',freeblocks*(sectorsperBlock div 2),' '+
                                      'DE: ',totalDirentries,' ',AvailDirEntries);
                              end
                         else begin { normal output }
                              writeln;
                              writeln('Servername  : ',ServerName);
                              writeln('Volumenumber: ',volNbr);
                              writeln('Volume name : ',volumeName);
                              writeln('Blocksize   : ',SectorsPerBlock * 512,' bytes.');
                              writeln('Total blocks: ',totalblocks,' (=',(totalblocks *  (sectorsPerBlock div 2)),' Kb.)');
                              writeln('Free blocks : ',freeblocks,' (=',(freeblocks * (sectorsPerBlock div 2)),' Kb.)');
                              writeln('Purgable blocks : ',purgableblocks,' (=',
                                       purgableblocks * (sectorsPerBlock div 2),' Kb.)');
                              writeln('TotalDirEntries : ',totalDirEntries);
                              writeln('Available DE    : ',availDirEntries);
                              end;
                        end;

              inc(volNbr);
              end;
           end;
     end;
if cont
 then delay(5000); { 5 second interval }
UNTIL KeyPressed or (not cont);

SetPreferredConnectionId(OldConnId);
end.