{$X+,B-,V-} {essential compiler directives}

program tstvol;

{ Example for the nwFile unit / NwTP 0.6 API. (c) 1993,1995, R.Spronk }

{ Tests the following volume related functions in nwFile and nwServ:

  ClearObjectVolRestriction
  GetDiskUtilization (nwServ)
  GetObjectVolRestriction
  GetVolumeName
  GetVolumeNumber
  GetVolumeUsage
  IsVolumeRemovable
  SetObjectVolRestriction

}

uses nwMisc,nwServ,nwFile;


Var volNbr :byte;
    volName:string;

    volUsage   :TvolUsage;
    isremovable:boolean;

    MaxAllowedBlocks,
    BlocksInUse:Longint;

    VolumeNbr   :byte;
    sequenceNbr :LongInt;
    NbrOfObjects:byte;
    ResultBuffer:TobjVolRestr;

    usedDirs,usedFiles,usedBlocks:word;

    t:byte;
begin
writeln('Testing GetVolumeNumber');
IF GetVolumeNumber('XXXX',volNbr)
 then writeln('--Err. GetVolumeNuber returned a volumenumber when it should have failed.');
IF GetVolumeNumber('VOL',volNbr)
 then writeln('  VolNbr of ''VOL:'' equals ',volNbr)
 else writeln('  Volume VOL appears not to exist.');
IF GetVolumeNumber('SYS',volNbr)
 then writeln('  VolNbr of SYS: equals ',volNbr)
 else begin
      writeln('Error Using GetVolumeNumber, err#',nwFile.result);
      writeln('Critical error. Test aborted.');
      halt(1);
      end;

writeln;
writeln('Testing GetVolumeName');
for volNbr:=0 to 31
 do begin
    IF GetVolumeName(volNbr,volName)
     then writeln('  VolNbr ',volNbr,' is ''',volName,'''')
     else if result<>$98 { no such volume }
          then writeln('--Error testing GetVolumeName, err#',result);
    end;

writeln;
writeln('Testing GetVolumeUsage.');
IF GetVolumeNumber('SYS:',volNbr) and GetVolumeUsage(volNbr,VolUsage)
 then with VolUsage
       do begin
          writeln('  Volume Usage Information:');
          writeln('  Total Blocks: ',totalBlocks,' Free: ',freeBlocks);
          writeln('  Total Dir entries: ',totalDirEntries,' Free: ',availDirEntries);
          writeln('  Volumename: ''',volumename,'''');
          writeln('  Blocksize: ',SectorsPerBlock*512,' bytes.');
          end;


writeln;
writeln('Testing IsVolumeRemovable');
IF IsVolumeRemovable(0,isremovable)
 then writeln('  Removable: ',isremovable)
 else writeln('--IsVolumeRemovable failed.');


{==================Testing the volume restriction calls====================}

GetVolumeNumber('SYS',volNbr);

writeln('Getting the volume restrictions for user supervisor on SYS volume..');
IF GetObjectVolRestriction(volNbr,1 {objectId of Supervisor},
                           MaxAllowedBlocks,BlocksInUse)
 then begin
      writeln('  GetObjectVolRestriction:');
      writeln('  Supervisor on volume SYS');
      write('  Restricted to:');
      if MaxAllowedBlocks=$40000000
       then write('(unlimited)')
       else write(MaxAllowedBlocks);
      writeln(' Blocks ,BlocksInUse: ',BlocksInUse);
      end
 else writeln('--Error returned by GetObjectVolRestriction, err#',nwFile.result);

writeln;
writeln('Testing GetDiskUtilization (nwServ) for user supervisor');
IF NOT nwServ.GetDiskUtilization(volNbr,1 {supervisor ObjId},usedDirs,usedFiles,usedBlocks)
 then begin
      writeln('--Error returned by nwServ.GetDiskUtilization, err#',nwServ.result);
      if nwServ.result>=$89
       then writeln('--( Object Search/Read rights are necessary.)');
      end
 else begin
      writeln('  dirs in use  :',usedDirs);
      writeln('  files in use :',usedFiles);
      writeln('  blocks in use:',usedBlocks);
      { note that blocksinuse is a word (Max ownership= 262 Mb.)
        GetObjectVolRestriction returns the BlocksInUse value as a LongInt }
      writeln('  (created/owned dirs/files/blocks)');
      end;

writeln('Test of SetObjectVolRestriction:');
IF NOT SetObjectVolRestriction(volNbr,$1,BlocksInUse+100)
 then begin
      writeln('--Error returned by setObjectVolRestriction, err#',nwFile.result);
      if nwFile.result=140
       then writeln('--( Supervisor equivalent rights are necessary.)');
      end
 else writeln('--OK, volume restriction set.');

IF GetObjectVolRestriction(volNbr,$1 {objectId of Supervisor},
                           MaxAllowedBlocks,BlocksInUse)
 then begin
      if MaxAllowedBlocks=$40000000 { no restriction }
       then writeln('--SetObjectVolRestriction failed.');
      end;

writeln;
writeln('Testing ScanVolForRestrictions:');
sequenceNbr:=0;
While ScanVolForRestrictions(volNbr,sequenceNbr,NbrOfObjects,ResultBuffer)
 do begin
    for t:=1 to NbrOfObjects
     do begin
        write('  ObjectId:',HexStr(resultbuffer[t].objId,8));
        writeln(' /Restriction: ',resultBuffer[t].MaxallowedBlocks,' Blocks');
        end;
    end;
IF nwFile.result=$FF { NO MORE DATA, normal iteration end }
 then writeln('--No (more) volume restrictions.')
 else writeln('--Error returned by ScanVolForRestrictions, err#',nwFile.result);


writeln;
writeln('Clearing SUPERVISOR restrictions using ClearObjectVolRestriction.');
IF NOT ClearObjectVolRestriction(VolNbr,$1)
 then begin
      writeln('--Error calling ClearObjectVolRestriction, err#',nwFile.result);
      if nwFile.result=140
       then writeln('--( Supervisor equivalent rights are necessary.)');
      end;


IF GetObjectVolRestriction(volNbr,1 {objectId of Supervisor},
                           MaxAllowedBlocks,BlocksInUse)
 then begin
      if MaxAllowedBlocks=$40000000
       then writeln('--OK, user now has no restriction.')
       else writeln('--Error: ClearObjectVolRestriction Failed.');
      end;

end.