Program TstLRL;

{ Example for the nwLock unit / NwTP 0.6 API. (c) 1993,1995, R.Spronk }

{ Tests the following nwLock calls: (Logical Record Locking)

 LogLocalRecord
 LockLogicalrecordSet
 ReleaseLogicalRecord
 ClearLogicalRecordSet

}

Uses nwLock; { using this unit will automatically set the locmode to 1 }

Var RecordName:string;
    TimeOutTicks:word;

begin
TimeOutTicks:=360; {wait 20 seconds before locking process times out}

writeln('TSTLRL: Test of logical record locking.');
writeln('       -Start the exe on 2 or more workstations & enjoy the effect.');
writeln;
writeln('Suppose we want to perform a transaction on a file, where:');
writeln('-we want to update (read&write) Records # 123, 678 and 056.');
writeln;
writeln('To do this, this program uses logical record locking in the following manner:');
writeln('-It locks records #123,678 and 056 in Exclusive mode.');
writeln(' (denying all attempts at locking by other stations.');

{ Put the names of records-to-be-EXCLUSIVELY-locked in the 'logged record set' }
RecordName:='#123';
IF NOT LogLogicalRecord(RecordName,LD_LOG,0)
 then writeln('LogRecord failed. Error# ',nwLock.result);
{ Note: The recordnames used have no linkage whatsover with physical
        records. They form a logical representation of a physical record.
        All processes involved in locking processes on the same data must
        use the same naming convention }
RecordName:='#678';
IF NOT LogLogicalRecord(RecordName,LD_LOG,0)
 then writeln('LogRecord failed. Error# ',nwLock.result);
RecordName:='#056';
IF NOT LogLogicalRecord(RecordName,LD_LOG,0)
 then writeln('LogRecord failed. Error# ',nwLock.result);

{ Lock all records that are currently stored in the 'logged record set' }
writeln('Attempting to place locks on records.. ');


IF NOT LockLogicalRecordSet(LD_LOCK,TimeoutTicks)
 then writeln('LockLogicalRecordSet (after TimeOut=20 sec) failed. Error# ',nwLock.result);

if nwlock.result=0 { locking of records was successful }
 then begin
      { ---Update records, change records, etc.--- }

      { Readln to simulate update }
      writeln('Now ''processing'' locked records. Press RETURN to release locks.');
      readln;

      { Suppose we're done with record #123, but still need the other record
        -unlock 1 record; keep record in log }
      IF NOT ReleaseLogicalRecord('#123')
       then writeln('ReleaseLogicalRecord Failed. Error# ',nwLock.result);

      writeln('Now ''processing'' still locked records');
      end;

{ unlock all records; clear 'logged record set' }
IF NOT ClearLogicalRecordSet
 then writeln('ClearLogicalRecordSet Failed. Error# ',nwLock.result);

end.
