{$X+,B-,V-} {essential compiler directives}

Program TrCopy;

{ Example for the nwConn unit/ NwTP 0.6 API. (c) 1993,1995, R. Spronk }

{ Copies the time restrictions of a supplied user to amother user,
  or another user group. The destination may conatain wildcards. }

{ Note that it is possible to change the time restrictions of a number of
  users by tagging them with F5 (in SYSCON) and then changing the time
  restrictions. }

{(4395)  Tue 8 Feb 94  8:43
By: Jos Cobbenhagen
To: Allen
Re: MUTATIE TIME-RESTR.
St:
------------------------------------------------------------
Aan     :Allen Van     :Jos Cobbenhagen Betreft :Mutaties Time-restrictions

Ik moet incidenteel voor een aantal wisselende afdelingen/gebruikers de
time-restrictions aanpassen. Dit komt voor bij crises en apparte gebeurtenissen
waarbij users ijdelijk 's avonds en in weekenden moeten werken. Enige
mogelijkheid die ik hiervoor ken is voor de betreffende users appart deze
restricties aanpassen, en voor 50+ gebruikers is dat vrij omslachtig. Vraag is
of er een bindery utility is die dit in een keer voor een bepaalde groep
gebruikers kan regelen?
}

uses nwMisc,nwBindry;

Var source   :string;
    TimeRestr:array[1..42] of byte;

Function ChangeTRforUser(dest:string):boolean;
Var res:boolean;

    ObjName      :string;
    ObjType      :word;
    ObjId        :LongInt;
    Iter         :LongInt;
    Flag,Sec     :byte;
    HasProperties:boolean;

    propValue:Tproperty;
    moreSegs :boolean;
    propFlags:byte;
begin
res :=false;
iter:=-1;
WHILE ScanBinderyObject(dest,OT_USER,iter,
                        ObjName,ObjType,ObjId, Flag,Sec,HasProperties)
 do begin
    res:=true;
    IF (source<>ObjName)
       and ReadPropertyValue(ObjName,OT_USER,'LOGIN_CONTROL',1,
                             propValue,moreSegs,propFlags)
     then begin
          Move(TimeRestr[1],propValue[15],42);
          IF WritePropertyvalue(ObjName,ObjType,'LOGIN_CONTROL',1,
                                propValue,FALSE)
            then writeln('Time restrictions of user ',ObjName,' changed.');
          end;
    end;
ChangeTRForUser:=res;
end;


Function ChangeTRforGroup(GroupDest:string):boolean;
Var res:boolean;

    ObjName      :string;
    ObjType      :word;
    ObjId        :LongInt;
    Iter         :LongInt;
    Flag,Sec     :byte;
    HasProperties:boolean;

    propValue:Tproperty;
    moreSegs :boolean;
    propFlags:byte;
    seg,i    :byte;

    UserObjId  :LongInt;
    UserObjName:string;
begin
res :=false;
iter:=-1;
WHILE ScanBinderyObject(GroupDest,OT_USER_GROUP,iter,
                        ObjName,ObjType,ObjId, Flag,Sec,HasProperties)
 do begin
    res:=true;
    seg:=1;

    WHILE ReadPropertyValue(ObjName,OT_USER_GROUP,'GROUP_MEMBERS',seg,
                            propValue,moreSegs,propFlags)
      do begin
         i:=1;
         Repeat
           UserObjId:=MakeLong((propValue[i]   *256 + PropValue[i+1] ),
                               (propValue[i+2] *256 + PropValue[i+3] ) );
           if UserObjId<>0
            then begin
                 IF GetBinderyObjectName(UserObjId,UserObjName,ObjType)
                    and (UserObjName<>Source)
                  then ChangeTRForUser(UserObjName);
                 end;
           inc(i,4);
         Until (i>128) or (objId=0);

         inc(seg);
         end;
    end;
ChangeTRForGroup:=res;
end;

Procedure GetSourceTR(source:string);
Var propValue:Tproperty;
    MoreSegs :boolean;
    PropFlags:byte;
begin
IF NOT ReadPropertyValue(source,OT_USER,'LOGIN_CONTROL',1,
                         propValue,moreSegs,propFlags)
    then begin
         writeln;
         Case nwBindry.result OF
           $F0    :writeln('Wildcards in source not allowed.');
           $FC,$FB:writeln('No such userobject');
           $F9,$F1:writeln('Not enough privileges..');
         else writeln('General error reading the bindery.');
         end;{case}
         Halt(1);
         end;
Move(propValue[15],TimeRestr[1],42);
end;


{--------------------------------- main -------------------------------------}
Var dest    :string;
    MyObjId :Longint;
    secLevel:byte;
    version :word;

begin
If ParamCount<>2
 then begin
      writeln('----- TRCOPY: Copy Login Time Restrictions from one user to another. -----');
      writeln;
      writeln('Usage: TRCOPY <source> <dest>');
      writeln;
      writeln('Where <source> is the name of a USER,');
      writeln('and <dest> the name of a user or group the time restrictions');
      writeln('are to be copied to. <dest> may contain wildcards.');
      writeln;
      writeln('----- Use with NetWare 3.x only ---------- Written with the NwTP API -----');
      halt(0);
      end;
writeln('TRCOPY: Copy Time Restrictions.');
source:=ParamStr(1);
dest  :=ParamStr(2);
UpString(Source);
UpString(dest);

IF (NOT GetBinderyAccessLevel(secLevel,MyObjId))
   or (secLevel<>$33)
 then begin
      writeln;
      writeln('You need to be logged in as a Supervisor equivalent user');
      writeln('to use this utility.');
      halt(1);
      end;

GetNWversion(version);
if (version DIV 100)<>3
 then begin
      writeln;
      writeln('TRCOPY runs with NetWare 3.X only.');
      halt(1);
      end;

GetSourceTR(source);

IF NOT ChangeTRforUser(dest)
 then IF NOT ChangeTRforGroup(dest)
       then writeln('Error: destination user or group doesn''t exist.');

end.