{$X+,V-,B-}
Program SemaTest;

{                                                                       */
/* SemaTest - Tests semaphores by showing application metering example  */
/*                                                                      */
/* by Charles Rose                                                      */
/*                                                                      */}

{ Testprogram for the nwSema unit, this version (c) 1994,1995 R.Spronk }

USES Crt,nwMisc,nwSema;

CONST
 INITIAL_SEMAPHORE_VALUE=2;
 WAIT_SECONDS=2;

{ Global data }
VAR openCount :Word;
    semValue  :Integer;
    semHandle :LongInt;
    done      :boolean;
    t         :Byte;

BEGIN {main}

done := False;

{ Open Semaphore }
semValue := INITIAL_SEMAPHORE_VALUE;  { Need in case we're creating the semaphore }
IF NOT OpenSemaphore( 'TestSemaphore', semValue, semHandle, openCount )
 then begin
      writeln('Error opening semaphore. error #',nwSema.Result);
      Halt(1);
      end;

{ Wait on the Semaphore (get permission to use the resource) }
IF NOT WaitOnSemaphore( semHandle, 3*18 )  { 0 = Don't wait }
 then begin
      if ( nwSema.Result = $FE )
       then begin
	    writeln( 'Sorry, all of the slots for this resource are currently in use' );
	    halt(1);
	    end
       else begin
            writeln('WaitOnSemaphore returned eror# ',nwSema.result);
            halt(1);
            end;
      end;


clrscr;
gotoxy(1,4);
Writeln('Testing semaphore functions.');
writeln('Workstation ',INITIAL_SEMAPHORE_VALUE+1,' that starts this testprogram');
writeln('(concurrently) will be refused access to the (imaginary) resource.');
gotoxy( 24,24 );
write( 'Press any key to exit' );

IF NOT ExamineSemaphore( semHandle, semValue, openCount )
 then begin
      writeln('Error while examining semaphore value. Error #',nwSema.Result);
      Halt(1);
      end;

{ Wait loop }
while ( NOT done )
do begin
   gotoxy( 1,23 );
   write( 'Semaphore Test --> Open at [',openCount,
	  '] stations *** Value is [',semValue,']              ');
   t:=0;
   While (t<100) and (not done)
   do begin
      delay(WAIT_SECONDS*10); { wait a while };
      done:=KeyPressed;
      inc(t);
      end;

   gotoxy( 60,23 );
   write( 'Checking...' ); Delay(500); { wait half a sec }

   IF NOT ExamineSemaphore( semHandle, semValue, openCount )
    then writeln('ExamnineSemaphore2 error#',nwsema.result);
   end;

{ Signal Semaphore (that we're through with the resource) }
SignalSemaphore( semHandle );
{ Close Semaphore }
CloseSemaphore( semHandle );
end.
