//****************************************************************************
// File: umailsrv.pro                    Version 3.0               16-Apr-1995
//                                       Niel Kempson <kempson@snowyowl.co.uk>
//****************************************************************************
//
// NOTE
//
//  This file contains explicit reference to path specifications in several
//  of its sections:
//
//      :MAIL
//          the 'directory' entry specifies where incoming mail is placed
//          before final delivery to users
//
//      :ACCESS
//          the 'root' entry specifies where mail should be stored for
//          the user ID declared by the :ACCESS section
//
//  Note that the :PROFILE section also contains path information but it
//  should be commented out in this example.
//
//  See also the enclosed Ultimail FAQ for a commented example of a
//  UMAILSRV.PRO file.
//
//****************************************************************************
//
// Change Log
//
//    2.0 [05-Feb-1995] Niel Kempson <snowyowl.co.uk>
//        Initial version.
//
//    3.0 [16-Apr-1995] Niel Kempson <snowyowl.co.uk>
//        Added explicit warnings about path specifications and a pointer
//        to the Ultimail FAQ.
//
//****************************************************************************
//----------------------------------------------------------------------------
// Ultimedia Mail/2 Configuration File
// ===================================
//
// Many features of UltiMail are user configurable. All features which are
// specific for a given UltiMail client are collected in this profile. This
// file can be edited with any regular editor. Most conveniently it is hoever
// accessed through the settings notebooks in UltiMail itself.
//
// Comments (like this one) are according to C++ conventions preceeded by a
// double forward slash '//'. The double forward slash and anything after it
// on the given line is then ignored by UltiMail.
//
// Note: comments are not preserved when the configuration file is changed
//       through the settings notebooks from within UltiMail.
//
// Note: changes made directly in this file do not take effect until UltiMail
//       is logged off and on again with this profile. Most changes made
//       through the settings notebooks however take effect immediately.
//----------------------------------------------------------------------------
:MAIL          directory        = 'C:\tcpip\UMAIL\Server'
               splitsize        = '131072'
               .

//
//  Keep this :PROFILE section commented out to prevent UltiMail/2 Lite
//  from consulting TCPOS2.INI.
//
//:PROFILE       provider         = 'ADVANTIS'
//               file             = 'C:\tcpip\ETC\TCPOS2.INI'
//               .

:SERVER        dll              = 'CSESLOCL'
               name             = 'Local Mail'
               pipeclass        = 'PIPELOCL'
               maxinst          = '20'
               load             = 'automatic'
               retrycount       = '1'
               retryinterval    = '5000'
               .
:ACCESS        name             = 'Post Master'
               user             = 'PostMaster'
               password         = '*'
               root             = 'C:\tcpip\UMAIL\MailStor\Postmstr'
               access           = 'readwrite'
               .
:ACCESS        name             = 'Your Name'
               user             = 'yourid'
               password         = '*'
               root             = 'C:\TCPIP\UMAIL\MailStor\yourid'
               access           = 'readwrite'
               .
//---end of file -------------------------------------------------------------
