/* Put a ruler to the screen for SemWare's TSE editor V2.0. To make
   this SAL macro operational, invoke the main menu (F10), choose
   "Macro", choose "Compile" and press Enter at "Execute Macro".

..................................................................
Prof. Timo Salmi      Co-moderator of comp.archives.msdos.announce
Moderating at garbo.uwasa.fi anonymous FTP archives  193.166.120.5
Department of Accounting and Business Finance; University of Vaasa
Internet: ts@uwasa.fi   BBS +(358)-61-3170972; FIN-65101,  Finland
*/

// The contents of a simple help, tied later to the CtrlAlt-H key
helpdef tHelpData
  title = "RULER.S HELP"           // The help's caption
  x = 10                           // Location
  y = 3
  // The actual help text
  " Prof. Timo Salmi's ruler"
  ""
  " Displays a relative, absolute or a centered "
  " ruler on the screen. "
  ""
  " You can use <F11> to invoke the command "
  " menu after first exiting this help. "
  ""
  " Last updated Sun 12-February-1995 09:19:36 "
end  /* tHelpData */

proc tRulerAbs()
  string s[255]
  Set(Attr, Color(BRIGHT Red ON Black))
  s = '102030405060708090100'
    + '110120130140150160170180190200'
    + '210220230240250'
  GotoXY(1,CurrRow()+1)
  Writeline(SubStr(s,CurrXoffset()+1,255))
end  tRulerAbs

proc tRulerRel()
  string s[255]
  Set(Attr, Color(BRIGHT Magenta ON Black))
  s = '102030405060708090100'
    + '110120130140150160170180190200'
    + '210220230240250'
  GotoXY(1,CurrRow()+1)
  Writeline(s)
end  tRulerRel

proc tRulerCent()
  string s[255]
  Set(Attr, Color(BRIGHT yellow ON Black))
  s = '9080706050403020100'
    + '102030405060708090100'
  GotoXY(1,CurrRow()+1)
  Writeline(SubStr(s,101-CurrCol()+CurrXoffset(),255))
end  tRulerCent

// New keys and menus **************************************************
forward Menu tRulerMenu()
forward proc tDisableNewKeys()

// Add the new key definitions
keydef new_keys
  <CtrlAlt 4>      tRulerAbs()
  <CtrlAlt 5>      tRulerRel()
  <CtrlAlt 6>      tRulerCent()
  <CtrlAlt 0>      tDisableNewKeys()
  <CtrlAlt H>      QuickHelp(tHelpData)
  <F11>            tRulerMenu()
end

// Disabling the new extra keys ***************************************
proc tDisableNewKeys()
  if YesNo("Disable the extra keys:") == 1 Disable(new_keys) endif
end

// The ruler menu *****************************************************
Menu tRulerMenu()
  Title = "Timo's ruler menu"
  Width = 19
  x = 40
  y = 3
  history
  "&Absolute ruler    <CtrlAlt 4>"   , tRulerAbs()
  "&Relative ruler    <CtrlAlt 5>"   , tRulerRel()
  "&Centered ruler    <CtrlAlt 6>"   , tRulerCent()
  "",,Divide
  "Disable &new keys  <CtrlAlt 0>"   , tDisableNewKeys()
  "&Help              <CtrlAlt H>"   , QuickHelp(tHelpData)
  "This Menu         <F11>"
end tRulerMenu

proc Main()
  Enable (new_keys)
  tRulerMenu()
end
