/* Corrected InterFile() for SemWare's TSE editor V2.0. To make this
   SAL macro operational, invoke the main menu (F10), choose
   "Macro", choose "Compile" and press Enter at "Execute Macro".

..................................................................
Prof. Timo Salmi      Co-moderator of comp.archives.msdos.announce
Moderating at garbo.uwasa.fi anonymous FTP archives  193.166.120.5
Faculty of Accounting & Industrial Management; University of Vaasa
Internet: ts@uwasa.fi   BBS +(358)-61-3170972; FIN-65101,  Finland
*/

// The contents of a simple help, tied later to the CtrlAlt-H key
helpdef tHelpData
  title = "INSERTF.S HELP"           // The help's caption
  x = 10                             // Location
  y = 3
  // The actual help text
  " Prof. Timo Salmi's improved InsertFile() procedure "
  ""
  " The SemWare Editor version 2.0 InsertFile() procedure "
  " has a small flaw in it. It treats a mask like C: as "
  " C:\ while EditFile() does not have this flaw. This "
  " macro corrects the problem. "
  ""
  " You can use <F11> to invoke the command menu after "
  " first exiting this help. "
  ""
  " Last updated Sat 26-November-1994 20:07:48 "
end  /* tHelpData */

// InsertFile() replacement
proc timoInsertFile()
  string fname[80]
  integer ok = TRUE
  // Choose the insert-file
  if EditFile()
    fname = CurrFilename()
    if FileExists(fname)
      // Arrange a blank line to the original, target file
      PrevFile()
      InsertLine()
      // Mark the entire insert-file to be inserted
      NextFile()
      BegFile()
      UnmarkBlock()
      MarkChar()
      EndFile()
      MarkChar()
      PrevFile()
      // Copy the entire insert-file to the target file
      CopyBlock()
      // Go back to the insert-file
      NextFile()
      // Remove the insert-file from the ring
      QuitFile()
    else
      ok = FALSE
      // Remove the insert-file from the ring
      QuitFile()
    endif
  endif
  //
  if not ok
    Message("File " + fname + " not found Press <Escape>")
  endif
end  /* timoInsertFile */

// New keys and menus **************************************************
forward Menu timoInsertFileMenu()
forward proc tDisableNewKeys()

// Add the new key definitions
keydef new_keys
  <CtrlAlt 5>      timoInsertFile()
  <CtrlAlt 0>      tDisableNewKeys()
  <CtrlAlt H>      QuickHelp(tHelpData)
  <F11>            timoInsertFileMenu()
end

// Disabling the new extra keys ***************************************
proc tDisableNewKeys()
  if YesNo("Disable the extra keys:") == 1 Disable(new_keys) endif
end

// The timoInsertFileMenu *********************************************
Menu timoInsertFileMenu()
  Title = "Timo's InsertFile menu"
  Width = 19
  x = 40
  y = 3
  history
  "&InsertFile        <CtrlAlt 5>"   , timoInsertFile()
  "",,Divide
  "Disable &new keys  <CtrlAlt 0>"   , tDisableNewKeys()
  "&Help              <CtrlAlt H>"   , QuickHelp(tHelpData)
  "This Menu         <F11>"
end  /* timoInsertFileMenu */

proc Main()
  Enable (new_keys)
  timoInsertFileMenu()
end
