LogiMouse                           Manual                            LogiMouse

   NAME

      LogiMouse - Mouse Driver for LogiTech serial mice
                   (eg TrackMan trackball)

   SYNOPSIS
      
      LogiMouse      [-d <serial.device>]
                     [-u <unit>]
                     [-m <qualifier>|<Button>]
                     [-r <qualifier>|<Button>]
                     [-l <qualifier>|<Button>]
                     [-3]
                     [-q]
                     [-b <Baud rate>]
                     [-s <Stop bits>]
                     [-w <Read/Write len>]
  
   DESCRIPTION

      A few months ago i bought a LogiTech Trackman TrackBall (which if you
      haven't seen one is the most wonderfully shaped trackball known to man
      (well to me..) your hand just flops over the thing... soo cumfy!), as
      i have a serial card, spare serial ports where not a problem.
      
      I chearfully grabbed sermouse from Aminet, only to find out that my
      TrackMan doesn't actually use either of the protocols sermouse does..

      So i wrote my own driver.

      Also i wanted to swap the middle button and the right button so that
      got incorperated.

      To install the thing just put a line in your user-startup like
      
      sys:bin/boot/LogiMouse -u2 -mRSH

      You can alter the settings whist the driver is running, just run the 
      driver again with the new settings and it'll send the info to the first
      instance of the driver and exit (only one instance of the driver can be
      running)   

   OPTIONS

      -d <serial.device>         (defaults to serial.device)
      -u <unit>                  (defaults to 0)
      -q 								quit
      -m <qualifier>|<Button> 	middle mouse buttion = qual. (ie shift, alt etc)/button
      -r	<qualifier>|<Button> 	right mouse buttion = qual. (ie shift, alt etc)/button
      -l <qualifier>|<Button> 	lift mouse buttion = qual. (ie shift, alt etc)/button
      -3									Reset mouse to std 3 buttons
      -b <Baud rate>             (defaults to 1200 (correct setting))
      -s <StopBits>              (defaults to 1 (correct setting))
      -w <Read/Write len>        (defaults to 7 (correct setting))

   QUALIFIERS

      R                          Right Button
      M                          Middle Button
      L                          Left Button
      
      RSHIFT   (RS)              Right Shift key
      LSHIFT   (LS)              Left Shift key
      RCOMMAND (RC)              Right Amiga Key
      LCOMMAND (LC)              Left Amiga Key
      RALT     (RA)              Right Amiga Key
      LALT     (LA)              Left Amiga Key
      CONTROL  (CT)              Control Ket      

   EXAMPLE

      sys:bin/boot/LogiMouse >NIL: -u2 -mRSH
       
       - uses unit 2 of the serial.device, middle button is mapped 
         to right shift (only have to specify enough of the qualifier to
         differentiate between it and other qualifiers)

      LogiMouse >NIL: -lR -rL -mRC

       - use serial.device, unit 0, swap left and right mouse buttons, map
         middle mouse button to right control key

      LogiMouse -q

       - Quit driver  

   ERRORS

      If there are not enough resources for LogiMouse to run it will exit
      (this is not very likely - it doesn't exactly use much mem.)

   WARNING
   
      Remember: If the mouse driver is not running you cannot use your 
      LogiTech mouse, for example the early startup screen, or canceling
      GURUs that have reset your Ami.

   BUGS/PROBLEMS

      DragIT Commodity refuses to work at all with my driver.

      (in 4 months of constant use this is the only problem i have found 
      with the 'normal' functions of the mouse (ie 3 buttons))

      The Qualifiers (discluding swapping buttons and having shift as a
      button) should be considered as a bonus.. ie wether they'll work with
      a program depends on how the program reads the information from the
      system.

      (personally i'm just using my mouse as a standard 3 button mouse at the 
      moment, using yak by Gal Marziou and Philippe Bastiani to use the 
      middle button as shift and also as window to front/back)

      Feel free to email me with bug-reports/suggestions etc (i may even
      act upon them)

      
      Doesn't work with your LogiTech serial mouse?

   	NB LogiMouse requires a serial port/device that can be set to 7N1 
   	(7 read/write bits, no parity, 1 stopbit). (this is not as simple as it
  		sounds.. 7N1 is completely alien to the Amiga.. The internal serial port
  		(on my 4000 anyway) does not support it. Note again that some serial 
   	drivers will say they've set it when they actually haven't.. <ARGG>). 
   	
   	If LogiMouse just exits then there are 3 possibilities - it cannot 
   	allocate necessary resources, the serial port is in use, or the serial
   	port does not support the settings LogiMouse wants.
   	
   	NB some serial.drivers (eg the one from C=) lie - they say they've set
   	the serial.port ok when in fact they haven't (this will cause the mouse
   	to go absolutly mental and jump all over the screen doing all sorts
   	of things on the way..). 
   	
   	If anyone knows a way to get round this (somehow converting 8N1 data
   	to 7N1???) please get in touch with me.  


   SPECIAL REQUIREMENTS

   Needs OS 2.04 or higher.
   Spare serial port that supports 7N1 (such as the C= A2232 serial card). 
   (NB the internal port doesn't support 7N1 (well mine doesn't)).
   
   LogiTech Mouse that uses the 'MouseMan' protocol, eg the TrackMan trackball

   (if you have a LogiTech Mouse that won't work with sermouse/optmouse or any
   of the other serial drivers around, then it prob. uses this protocol 
   (maybe.. ;-) ))     
             
   AUTHOR

      Simon Richardson
      simon@albert.demon.co.uk

   COPYRIGHT

      Simon Richardson 1994 - 1995.

   PRICE

      LogiMouse is emailware (if you like it let me know)

   DISTRIBUTABILITY

      Freely Distributable, (c) 1994-95 Simon Richardon

   DISCLAMER

      If LogiMouse steals your dog, has an affair with your wife, 
      implodes your hard disk etc etc then its a real shame.. but then
      its free init??                                   
      
      LogiMouse has been running on my Amiga for over 4 months with no 
     	problems (so i think its fairly stable.. ;-) )

      LogiMouse definitly works with my mouse.. (LogiTech TrackMan 
      (Series 9 if mem. serves)) No guarantees it'll work with yours 
      (but if it doesn't and your mouse is a LogiTech mouse - tell me 
      (and if you send me some output from SerDiag i might even get it 
      to work for you)).  
      
      Also if it don't work read the 'Doesn't work with your LogiTech 
      serial mouse?' bit in BUGS/PROBLEMS above.
      
      If you like it, use it.. If you hate it delete it.
        
   HISTORY

      1.03  08/02/95    First Aminet release.

      1.04  29/03/95    Got some email from a chap with a MouseMan mouse..
                        which doesn't work with this driver. 
                        (Humm didn't i say LogiMouse uses the 'MouseMan'
                        protocol? (it does honest..))

                        Added -b <baud>, -s <StopBits>, -w <Read/Write len>
                        to (hopefully) help LogiMouse work with the MouseMan

      1.05              Bugfix: Now skips mouse handshake MSG.
      
      1.051	05/04/95		LogiMouse now exits if the serial.device used tells
      						it that it cannot set the hardware to 7N1 (some
      					 	serial.devices lie of course.. )
                        

   THANKS

      A.J.terSteege, Emilio Desalvo, Erik Hill for telling me that LogiMouse
      doesn't work with their mice (and either sending me output
      or trying to from SerDiag).. Enabling me to work out (with the help
      of several serial.devices, ports and Amigas) that setting 7N1 on an
      Amiga is a bitch.
      
      Sorry i cannot solve this (but if anyone can.. mail me!).   