' Example: Simple BASIC program which generates two sine waves (8Hz and 5Hz)
'          Demonstrates use of OPERATION, INTERVAL and PLOT_TYPE keywords.
'
CONST nsamp = 128      ' number of samples
CONST fs = 40          ' sample frequency Hz
CONST w = 6.283185307# ' w=2*pi

DIM n AS INTEGER       ' sample #
DIM t AS SINGLE        ' time of sample

OPEN "C:\WINPLOT\DATA_FFT.CSV" FOR OUTPUT AS #1  ' Open your output file

PRINT #1, "OPERATION=SPECTRUM"               ' Plot spectrum
PRINT #1, "INTERVAL="; 1 / fs                ' Note: This is a automatic X axis file
PRINT #1, "PLOT_TYPE=HISTO"
PRINT #1, "DATA"
FOR n = 1 TO nsamp
  LOCATE 1, 1: PRINT n;                      ' display progress
  t = t + 1 / fs                             ' t=1/f
  PRINT #1, SIN(5 * w * t) + SIN(8 * w * t)  ' output mixed sine wave - Y data
NEXT n

CLOSE #1
BEEP
END

