/* mlink.c -- main mlink select loop and startup code
 *
 * Copyright (c) 1994 by Ezra Story.  All rights reserved.  Explicit
 * permission is given to use this source for any purpose as long as
 * the author (Ezra Story) is notified and this copyright notice is
 * included.
 */
static char rcsid[] = "$VER: $ $Id: mlink.c 1.52 1995/04/23 04:59:58 Ezra_Story Exp $";


#define INC_SYS
#define INC_IOCTL
#define INC_ERRNO
#define INC_SIGNAL
#define INC_STRING

#include "defs.h"


export VOID     done P((VOID));
export VOID     cwait P((VOID));

export char             *mlinkPath;
export struct selmask   sm[2];

local VOID      MlinkSelLoop P((VOID));

int
main(ac,av)
int  ac;
char **av;
{
    int x;


    TtyRaw(5, 2);

    /* signal startup and get initial config */
    write(1, "STRT", 4);
    LoadConfig();

    /* local setup */
    if (!InitMux()) done();
    if (!InitSockets()) done();

    /* set signals */
    signal(SIGHUP,  done);       /* quit on hangup */
    signal(SIGINT,  SIG_IGN);    /* ignore interrupt */
    signal(SIGQUIT, SIG_IGN);   /* ignore quits */
    signal(SIGTERM, done);      /* quit on terminate */
    signal(SIGTSTP, SIG_IGN);   /* ignore stop */
    signal(SIGCHLD, cwait);     /* cleanup children */
#ifdef SIGURG
    signal(SIGURG,  SIG_IGN);    /* no oob notification */
#endif
    signal(SIGPIPE, SIG_IGN);   /* no bad send terination */
    signal(SIGALRM, SIG_IGN);
#ifdef SIGIO
    signal(SIGIO,   SIG_IGN);
#endif

    /* main select loop */
    MlinkSelLoop();

    /* cleanup */
    done();

    /* notreached */
    return(0);
}


VOID
MlinkSelLoop(VOID)
{
    struct timeval tv, ntv, otv;
    ubyte          *serbuf, *serbuf2, *tmpbuf, *sb;
    int            num, sel, bytesout, x;
    fd_set         nullmask;
    int            readload;

    /* serial protocols */
    PacketECInit();
    InitEscapeIO();

    /* timing */
    bytesout   = 0;
    readload   = 0;
    Gettimeofday(&otv);

    /* buffers */
    if ((sb = (ubyte *)malloc(SERBUFSIZE*2)) == 0) return;
    serbuf = sb;
    serbuf2 = sb + SERBUFSIZE;

    /* setup initial select masks */
    FD_ZERO(&sm[0].rd);
    FD_ZERO(&sm[0].wr);
    FD_ZERO(&sm[0].ex);
    FD_ZERO(&nullmask);
    FD_SET(0,&sm[0].rd);
    FD_SET(0,&nullmask);
    num = 0;

    /* startup client */
    write(1, "TRIG", 4);

    while (1)
        {
        /* set timeout, save masks */
        tv.tv_sec  = 0;
        tv.tv_usec = 500000;
        sm[1] = sm[0];

        /* If there's data to write, we don't need
         * to read from the sockets.  We only
         * output the data if the line speed lets
         * us.  Even if we have no data, it's
         * best for us to wait for the line to
         * catch up before getting more from sockets.
         */
        FD_CLR(1,&sm[1].wr);
        if (AmountInFifo(writeFifo, FIFO_ALL) || (bytesout <= 0) ||
            (PacketECTimeout() <= 0))
            {
            sm[1].rd = nullmask;
            if (bytesout > 0)
                FD_SET(1,&sm[1].wr);
            else
                {                        /* reduce cpu usgae during long sends */
                tv.tv_sec = 0;
                tv.tv_usec = MAX(10,MIN(-bytesout * mpcrate, 999999));
                select(0,0,0,0,&tv);
                tv.tv_sec = 0;
                tv.tv_usec = 500000;
                }
            }

        /* read load calculation.  We attempt to find out
         * whether we're spinning our wheels by
         * counting the number of sequential times we've
         * been selected.  If we go over a threshold
         * amount, we start delaying based on the amount
         * waiting for us on the queue.
         */
        if (readload > 10)
            {
            num = 0;
            ioctl(0, FIONREAD, &num);
            if (num > 0)
                {
                num *= 2;
                tv.tv_sec = (num > cpsrate) ? (num / cpsrate) : 0;
                tv.tv_usec = (num % cpsrate) * mpcrate;
                select(0,0,0,0,&tv);
                tv.tv_sec = 0;
                tv.tv_usec = 500000;
                }
            }

        /* do select */
        sel = select(FD_SETSIZE, &sm[1].rd, &sm[1].wr, &sm[1].ex, &tv);

        /* whoops! error or signal */
        if (sel < 0)
            {
            if (errno == EINTR) continue;
            break;
            }

        /* check time and update byte count */
        Gettimeofday(&ntv);
        bytesout += (ntv.tv_sec - otv.tv_sec) * cpsrate;
        bytesout += (ntv.tv_usec - otv.tv_usec) / mpcrate;
        if (bytesout > cpsrate) bytesout = cpsrate;

        /* start the interval again */
        otv = ntv;

        /* serial read */
        /* Grab data from serial, unescape it, send it
         * through error correction routines.
         */
        if (FD_ISSET(0,&sm[1].rd))
            {
            readload++;
            if ((num = read(0, serbuf, SERBUFSIZE-1)) > 0)
                {
                if (escapeio)
                    {
                    num = Unescape(serbuf, num);
                    }
                num = PacketECIn(serbuf, num, serbuf2);
                SWAPSERBUFS();
                if (num) DeMux(serbuf, num);
                }
            continue;
            }
        else
            readload = 0;

        /* serial write */
        if (FD_ISSET(1,&sm[1].wr))
            {
            /* only the write buffer & timeout can keep us on */
            FD_CLR(1, &sm[0].wr);

            num = PacketECOut(writeFifo, serbuf);
            if (escapeio)
                {
                num = Escape(serbuf, num, serbuf2);
                SWAPSERBUFS();
                }
            if (num)
                {
                tmpbuf = serbuf;
                bytesout -= num;
                while (num)
                    {
                    x = write(1, tmpbuf, num);
                    tmpbuf += ((x <= 0) ? 0 : x);
                    num = ((x <= 0) ? num : num-x);
                    if (num)
                        sleep(2);
                    }
                }
            continue;
            }

        /* socket read.*/
        /* Check all the sockets we have for incoming data.
         */
        if (!AmountInFifo(writeFifo,FIFO_ALL) && (bytesout > 0))
            CheckSocketRd();

        /* socket write */
        /* Data gathered for sockets in the DeMux() routine is
         * written to them here when the sockets indicate that
         * they are ready to receive.
         */
        CheckSocketWr();

        /* socket except */
        /* Checks for exceptions on sockets.
         */
        CheckSocketEx();

        }


    free(sb);
}

VOID
done(VOID)
{
    /* Just reset tty state to normal.  Unix should
     * dump all our descriptors and mallocs for us.
     */
    TtyRestore();
    exit(0);
}

VOID
cwait(VOID)
{
        int pid;
#ifdef CF_STRUCTWAIT
        union wait status;
#else
        int status;
#endif
#ifndef CF_WAITPID
        /*
         * Collect dead children.  Restart any children that have stopped.
         */
        while ((pid=wait3(&status, WNOHANG|WUNTRACED, 0)) > 0)
                if (WIFSTOPPED(status))
                        (void)kill(pid, SIGCONT);
#else
        while ((pid=waitpid(-1,&status, WNOHANG|WUNTRACED)) > 0)
                if (WIFSTOPPED(status))
                        (void)kill(pid, SIGCONT);
#endif
}

