/* mlinkconfig.c -- configuration file / input reader
 *
 * Copyright (c) 1994 by Ezra Story.  All rights reserved.  Explicit
 * permission is given to use this source for any purpose as long as
 * the author (Ezra Story) is notified and this copyright notice is
 * included.
 */
static char rcsid[] = "$Id: mlconfig.c 1.26 1995/03/01 16:24:46 Ezra_Story Exp $";

#define INC_SYS
#define INC_STRING
#define INC_SOCKET
#define INC_PWD

#include "defs.h"

export VOID GetHostInfo P((ubyte, ubyte));
export VOID ReConfig P((ubyte, int, ubyte *));
export VOID LoadConfig P((VOID));

export int  escapeio;
export int  bpsrate;
export int  cpsrate;
export int  mpcrate;

VOID
LoadConfig(VOID)
{
    ubyte *buf;
    int x, buflen, st ,sb, f;
    char *str = "@@";

    bpsrate = 19200;
    cpsrate = 1920;
    mpcrate = 1000000 / cpsrate;

    buf = (ubyte *)malloc(4000);

    /* get escape params */
    buflen = x = 0;
    while (str[x])
        {
        read(0, &buf[buflen], 1);
        x = (buf[buflen] == str[x]) ? x+1 : 0;
        buflen++;
        }

    escapeio = 0;

    for (x=0; x<256; x++)
        esctable[x] = 0;

    st = 0;
    for (x=0; x<buflen; x++)
        {
        switch (st)
            {
            case 0:
                switch (buf[x])
                    {
                    case '-':
                        f = sb;
                        st++;
                        break;
                    case ':':
                        f = -1;
                        st++;
                        break;
                    case '0':
                        escapeio = 0;
                        x = buflen;
                        break;
                    case '*':
                        escapeio = ESC_44;
                        x = buflen;
                        break;
                    default:
                        break;
                    }
                break;
            case 1:
                if ((buf[x] - '0') > 9)
                    sb = (buf[x] - 'A') + 10;
                else
                    sb = buf[x] - '0';
                sb <<= 4;
                st++;
                break;
            case 2:
                if ((buf[x] - '0') > 9)
                    sb += (buf[x] - 'A') + 10;
                else
                    sb += buf[x] - '0';
                if (f < 0)
                    esctable[sb] = 1;
                else
                    {
                    for(; f<=sb; f++)
                        esctable[f] = 1;
                    }
                escapeio = ESC_BYTE;
                st = 0;
                break;
            default:
                st = 0;
                break;
            }
        }

    if (escapeio == ESC_BYTE)
        esctable['^'] = 1;

    if (buf) free(buf);

}


/*
 * CMD_GETHOSTINFO: get host info :-)
 */
VOID
GetHostInfo(desc, type)
ubyte desc, type;
{
    struct passwd *pw;
    struct hostent *he;
    ulong iaddr;
    ubyte out[200];

    switch (type)
        {
        case GETHI_USERNAME:
            pw = getpwuid(getuid());
            ReturnSuccess(CMD_GETHOSTINFO, desc, strlen(pw->pw_name)+1, pw->pw_name);
            break;

        case GETHI_HOSTADDR:
            he = 0;
            if (!gethostname(out, 190)) he = gethostbyname(out);
            if (!he)
                ReturnError(CMD_GETHOSTINFO, desc, 1);
            else
                {
                iaddr = ntohl( *((ulong *)he->h_addr) );
                out[0] = (iaddr >> 24) & 0xff;
                out[1] = (iaddr >> 16) & 0xff;
                out[2] = (iaddr >>  8) & 0xff;
                out[3] = iaddr & 0xff;
                strncpy(out+4, he->h_name,150);
                ReturnSuccess(CMD_GETHOSTINFO, desc, strlen(out+4)+5, out);
                }
            break;

        default:
            break;

        }


}

VOID
ReConfig(desc, len, buf)
ubyte desc;
int len;
ubyte *buf;
{
    switch (buf[0])
        {
        case CNF_CPS:
            cpsrate = DATAWORD(buf+1);
            bpsrate = cpsrate * 10;
            mpcrate = 1000000 / cpsrate;
            break;
        case CNF_TIMEOUT:
            packetTO = DATAWORD(buf+1);
            break;
        case CNF_PACKETSIZE:
            maxPacketSize = DATAWORD(buf+1);
            break;
        default:
            break;
        }

    ReturnSuccess(CMD_CONFIG, desc, 0, (ubyte *)0);
}
