/* fifo.h -- structs for buffering scheme
 * $Id: fifo.h 1.6 1995/04/22 19:39:19 Ezra_Story Exp $
 */

typedef struct
{
    node        n;          /* node entry */
    word        oob;        /* oob data or not? */
    int         size;       /* size of buffer */
    int         left;       /* amount of free space left */
    ubyte       *buf;       /* buffer tagged on the end */
} fnode;

typedef struct
{
    list        blst;                   /* buffer list */
    int         size;                   /* amount of data in buffer */
    int         oobsize;                /* amnt of oob data */
    int         minsize;                /* min bufnode size */
} fifo;
typedef fifo *Fifo;

extern  Fifo    CreateFifo P((int));
extern  VOID    DeleteFifo P((Fifo));
extern  int     WriteFifo P((Fifo, ubyte *, int, char));
extern  int     ReadFifo P((Fifo, ubyte *, int, char));
extern  int     AmountInFifo P((Fifo, char));
extern  int     FifoAtMark P((Fifo));
extern  int     WriteFifoChar P((Fifo, ubyte));
extern  int     ReadFifoChar P((Fifo, ubyte *));
extern  int     FifoNextBlock P((Fifo, ubyte **, char));

#define FIFO_STRM       0
#define FIFO_BLCK       1
#define FIFO_OOB        1
#define FIFO_ALL        2

#define FIRD_READ       0
#define FIRD_PEEK       0x10
#define FIRD_FLSH       0x20

