/* escape.c -- send 8bit streams over goofy lines */
/* Copyright (c) 1994 by Ezra Story.  All rights reserved.  Explicit
 * permission is given to use this source for any purpose as long as
 * the author (Ezra Story) is notified and this copyright notice is
 * included.
 *
 */
static char rcsid[] = "$Id: escape.c 1.4 1994/07/22 18:57:42 Ezra_Story Exp $";

#define INC_SYS

#include "defs.h"

export VOID     InitEscapeIO P((VOID));
export int      Unescape P((ubyte *, int));
export int      Escape P((ubyte *, int, ubyte *));

export char esctable[256];

local int       Escape_44 P((ubyte *, int, ubyte *));
local int       Unescape_44 P((ubyte *, int));
local int       Escape_Byte P((ubyte *, int, ubyte *));
local int       Unescape_Byte P((ubyte *, int));
local ubyte     last44;
local int       addesc;

#define BYTEESC '^'
#define BYTESHFT 129

VOID
InitEscapeIO(VOID)
{
    addesc = 0;
}

int
Unescape(buf, len)
ubyte *buf;
int len;
{
    if (escapeio == ESC_BYTE)
        return(Unescape_Byte(buf, len));
    else if (escapeio == ESC_44)
        return(Unescape_44(buf, len));
}

int
Escape(buf, len, outbuf)
ubyte *buf, *outbuf;
int len;
{
    if (escapeio == ESC_BYTE)
        return(Escape_Byte(buf, len, outbuf));
    else if (escapeio == ESC_44)
        return(Escape_44(buf, len, outbuf));
}


/*
 * 4-4 escaping:  If your line only seems to allow printable characters
 *
 * 01xx xxxx == 01xxxxxx  (64-127)
 * 1xxx xxxx == 00101xxx 0011xxxx (128-255)
 * 00xx xxxx == 001000xx 0011xxxx (0-63)
 * (32-127) must be able to be used (printable range)
 */
int
Escape_44(buf,len, outbuf)
ubyte *buf, *outbuf;
int len;
{
    ubyte *out = outbuf;
    ubyte *top = buf + len;

    for (;buf<top;buf++)
        {
        if ((*buf & 0xc0) == 0x40)
            {
            *out++ = *buf;
            }
        else
            {
            *out++ = ((*buf & 0xf0) >> 4) | 0x20;
            *out++ = (*buf &0x0f) | 0x30;
            }
        }

    return(out-outbuf);
}

int
Unescape_44(buf,len)
ubyte *buf;
int len;
{
    ubyte *bot = buf;
    ubyte *out = buf;
    ubyte *top = buf+len;

    for (;buf<top;buf++)
        {
        if (*buf < 32) continue;
        else if (*buf < 48) last44 = (*buf & 0x0f) << 4;
        else if (*buf < 64) *out++ = (last44 | (*buf & 0x0f));
        else if (*buf > 127) continue;
        else *out++ = *buf;
        }

    return(out-bot);
}

/* THis routine could overflow in a big way, but
 * I think its reasonable to assume a user would
 * use 44 if he's gonna kill a majority of the
 * byte range.
 */
int
Escape_Byte(buf, len, outbuf)
ubyte *buf, *outbuf;
int len;
{
    ubyte *out = outbuf;
    ubyte *top = buf + len;

    for(;buf<top;buf++)
        {
        /* find free escape range */
        while (esctable[*buf])
            {
            *out++ = BYTEESC;
            *buf += BYTESHFT;
            }
        *out++ = *buf;
        }

    return(out-outbuf);
}

int
Unescape_Byte(buf, len)
ubyte *buf;
int len;
{
    ubyte *bot = buf;
    ubyte *out = buf;
    ubyte *top = buf+len;

    for (;buf<top;buf++)
        {
        if (*buf == BYTEESC)
            {
            addesc += BYTESHFT;
            }
        else
            {
            *out++ = (*buf - addesc) & 0xff;
            addesc = 0;
            }
        }

    return(out-bot);
}
