{$M 4096,0,0}{$I-}
Program Convert_SLMR_SAV_files_to_QWK;
Uses CRT, DOS;
Const MaxBytes = 61440;
Type  SLMRarray = Array[1..MaxBytes] of char;

Const cursorState : byte = 1;  {0..3}
      cursorData : array [0..3] of char = (#179, #47, #196, #92);
      lineNumb : longint = 0;
{===========================================================================}

procedure cursorOff; forward;
procedure cursorOn; forward;
function IntToStr(const vint: longint): string; forward;

procedure showhelp(const problem :byte);
{----
 If any *foreseen* errors arise, we are sent
  here to give a little help and exit (relatively) peacefully
----}
const
  progdesc = 'SLMRQ - Free DOS utility: Convert SLMR .SAV text files to pseud-QWK files.';
  author   = 'v1.00: February 24, 1995. (c) 1995 by David Daniel Anderson - Reign Ware.';
  usage    = 'Usage: SLMRQ <SLMR .SAV file(s)>  (DOS wildcards are permitted.)';
  example  = 'Example:  SLMRQ startrek.sav         (creates "STARTREK.MRQ")';
var
  message : string[79];
begin
  writeln;
  writeln(progdesc);
  writeln(author);    writeln;
  writeln(usage);     writeln;
  writeln(example);   writeln;
  if problem > 0 then begin
    case problem of
      1 : message := 'Command line error: no files matching specification found to process.';
      2 : message := 'A MESSAGES.DAT file already exists.  Move, REName, or DELete it.';
      3 : message := 'A .MRQ with the same name as the "save file" exists. Move, REName or DELete it.';
      4 : message := 'Invalid header portion encountered just above line number: '+IntToStr(lineNumb)+' - fix file!';
      5 : message := 'Error archiving MESSAGES.DAT - try archiving it manually.';
      6 : message := 'You cannot just specify a path, add "*.*" or "\*.*" for all files.';
      7 : message := 'Unexpected error reading or writing file(s), unable to continue.';
    else  message := 'Unknown error.';
    end;
    writeln (#7, 'Error encountered, number ',problem,':'); writeln (message);
  end;
  cursorOn;
  halt(problem)
end;

procedure cursorOff;assembler;asm
  mov ah,3; mov bh,0; int $10; or ch,$20; mov ah,1; int $10;
end;

procedure cursorOn;assembler;asm
  mov ah,3; mov bh,0; int $10; and ch,not $20; mov ah,1; int $10;
end;

function IntToStr(const vint: longint): string;
var s: string;
begin
  Str(vint, s);
  IntToStr := s;
end;

Function LeadingZero(w : Word) : String;
Var
  s : String[2];
Begin
  Str(w:0,s);
  if Length(s) = 1 then
    s := '0' + s;
  LeadingZero := s;
End;

procedure iocheck(const iores :byte);
begin
  if iores <> 0 then showhelp(7);
end;

function fileexists(const filename:pathstr):boolean;
var
  attr : word;
  f    : file;
begin
  assign (f, filename);
  getfattr (f, attr);
  if (DOSerror <> 0) OR ((attr and directory) = directory) then
    fileexists := FALSE
  else
    fileexists := TRUE;
end;

procedure updateCursor;  {code written by Sean Palmer, found in SWAG}
begin
  cursorState := succ(cursorState) and 3;
  write(cursorData[cursorState], ^H);
end;

Function RPad(bstr: string; Const len: byte): string;
Begin
  while (length(bstr) < len) do
    bstr := bstr + #32;
  RPad := bstr;
End;

FUNCTION RTrim(InStr: STRING): STRING;
BEGIN
  WHILE (LENGTH(InStr) > 0) AND (InStr[LENGTH(InStr)] in [#0,#9,#32]) DO
    DEC(InStr[0]);
  RTrim := InStr;
END;

Function GetParenNum(tStr: string): string;
Const LParen = '(';
      RParen = ')';
begin
 if (Pos(LParen, tstr) > 0) then
   Delete(tstr,1,Pos(LParen, tstr));
 if (Pos(RParen, tstr) > 0) then
   tstr := Copy(tstr, 1, Pos(RParen, tstr)-1);
 GetParenNum := tStr;
end;

Function StrToDoubleChar(SLMRconf: string): string;
Var
  i, VErr : integer;
Begin
  while SLMRconf[1] = #32 do
    SLMRconf := Copy(SLMRconf,2,length(SLMRconf)-1);
  Val(SLMRconf,i,VErr);
  if (VErr <> 0) then i := 0;
  SLMRconf := Chr(i mod 256) + Chr(i div 256);
  StrToDoubleChar := SLMRconf;
End;

Procedure PrepareFiles(var SLMRname: pathstr; var SLMRfile: text;
                       var DATname: string; var DATfile: file);
Const
  QmailLine : Array[1..128] of char =
          'Produced by Qmail...Copyright (c) 1995 by ReignWare.  All Rights'+
          ' Reserved       Above for Compatibility with Qmail              ';

Var SLMRnameQ: pathstr;

Begin
  DATname := 'MESSAGES.DAT';
  if fileexists(DATname) then showhelp(2);

  if NOT fileexists(SLMRname) then showhelp(1);
  Assign(SLMRfile,SLMRname);
  Reset(SLMRfile); iocheck(ioresult);

  SLMRnameQ := SLMRname;
  if (pos('.', SLMRnameQ) > 0) then
    SLMRnameQ := Copy(SLMRnameQ, 1, pos('.', SLMRnameQ) - 1);
  if fileexists(SLMRnameQ+'.mrq') then showhelp(3);

  cursorOff;
  Write('Converting ', SLMRname, ' to MESSAGES.DAT, please wait ... ');
  SLMRname := SLMRnameQ;

  Assign(DATfile,DATname);
  Rewrite(DATfile,1); iocheck(ioresult);
  BlockWrite(DATfile, QmailLine, 128); iocheck(ioresult);
End;

Function GetSLMRstat(Const Status: string): char;
(* Note: the meaning of the status flag in the header of the QWK format
         specification is interpreted differently by different products.

   According to Patrick Y. Lee's "QWK Mail Packet File Layout" v1.0
   and Robomail v1.30, an asterisk ('*') means private and received,
                 and the plus sign ('+') means private and NOT received.

   SLMR 2.1a, SPEED and OLX v1.53 seem to agree that the meaning of the
   two symbols is reversed.

   Since this is a SLMR utility, I've used the latter.  Thus, the private
   and received flags will be translated into the following symbols:

              public, unread   =  ' '  (#32)
              public, read     =  '-'  (#45)
              private, unread  =  '*'  (#42)
              private, read    =  '+'  (#43)
*)
Const Priv = '(PVT)';
      YES = 'YES';
      NO = 'NO';
var SLMRstat: char;
Begin
  if (Pos(Priv, Status) > 0) then
    if (Pos(YES, Status) > 0) then
      SLMRstat := #43   { private, read }
    else
      SLMRstat := #42   { private, unread }
  else
    if (Pos(YES, Status) > 0) then
      SLMRstat := #45   { public, read }
    else
      SLMRstat := #32;  { public, unread }

  GetSLMRstat := SLMRstat;
End;

Procedure Verify(Const control, variable: string; const offset: byte);
Begin
  if (Copy(control,offset,length(variable)) <> variable) then
    showhelp(4);
End;

Function ReadSLMRheader(var SLMRfile: text): string;
Const hyphens='-------------------------------------'+
              '--------------------------------------';
  SLMRpass = #32#32#32#32#32#32#32#32#32#32#32#32; { 12 spaces }
  SLMRchnk = #32#32#32#32#32#32;  { 6 spaces }
Var
  SLMRline: string;
  SLMRfrom, SLMRto, SLMRsubj: string[25];
  SLMRdate: string[8];  SLMRtime: string[5];
  SLMRnumb: string[7];  SLMRrfer: string[8];
  SLMRconf: string[5];  SLMRstat: char;
Begin
  readln(SLMRfile,SLMRline); iocheck(ioresult); inc(lineNumb);
    Verify(SLMRline,'BBS:',2);
  readln(SLMRfile,SLMRline); iocheck(ioresult); inc(lineNumb);
    Verify(SLMRline,'Date:',   1); SLMRdate := Copy(SLMRline,7,8);
    Verify(SLMRline,'(',      16); SLMRtime := Copy(SLMRline,17,5);
    Verify(SLMRline,'Number:',36); SLMRnumb := RPad(Copy(SLMRline,44,length(SLMRline)-43),7);
  readln(SLMRfile,SLMRline); iocheck(ioresult); inc(lineNumb);
    Verify(SLMRline,'From:',   1); SLMRfrom := Copy(SLMRline,7,25);
    Verify(SLMRline,'Refer#:',36); SLMRrfer := RPad(Copy(SLMRline,44,length(SLMRline)-43),8);
  readln(SLMRfile,SLMRline); iocheck(ioresult); inc(lineNumb);
    Verify(SLMRline,'To:',     3); SLMRto := Copy(SLMRline,7,25);
    Verify(SLMRline,'Recvd:', 37); SLMRstat := GetSLMRstat(Copy(SLMRline,44,length(SLMRline)-43));
  readln(SLMRfile,SLMRline); iocheck(ioresult); inc(lineNumb);
    Verify(SLMRline,'Subj:',   1); SLMRsubj := Copy(SLMRline,7,25);
    Verify(SLMRline,'Conf:',  38); SLMRconf := StrToDoubleChar(GetParenNum(Copy(SLMRline,44,5)));
  readln(SLMRfile,SLMRline); iocheck(ioresult); inc(lineNumb);  {discard hyphen line}
    Verify(SLMRline, hyphens, 1);

  ReadSLMRheader := (SLMRstat+SLMRnumb+SLMRdate+SLMRtime+  { 21 chars }
                     SLMRto+SLMRfrom+SLMRsubj+             { 75 chars }
                     SLMRpass+SLMRrfer+SLMRchnk+#225+      { 27 chars }
                     SLMRconf+#0#0#42);                    {  5 chars }
End;

Function AddToArray(var SLMRmsg: SLMRarray;
                    Const offset: word; line: string): word;
Var
  index: word;
Begin
  if (offset > 128) then   { remove trailing whitespace }
    line := RTrim(line);
  if (length(line) > 0) then begin
    for index := (offset+1) to (offset+length(line)) do begin
      if (index <= MaxBytes) then
        SLMRmsg[index] := line[index-offset];
    end
  end
  else index := offset;
  if (offset >= 128) and (index < MaxBytes) then begin
    Inc(index);
    SLMRmsg[index] := #227;
  end;
  AddToArray := index;
End;

function FigureMSGsize(const bytes: word; var chunks: word): string;
var
  SLMRchnk : string[6];
Begin
  chunks := (bytes div 128);
  if ((bytes mod 128) <> 0) then inc(chunks);
  Str(chunks, SLMRchnk);
  SLMRchnk := RPad(SLMRchnk,6);
  FigureMSGsize := SLMRchnk;
End;

procedure InitCompressor(var Compressor: pathstr);
var
  epath, cpath  : pathstr;
    {epath & cpath are fully qualified pathnames of .exe & .cfg files}
  edir: dirstr; ename: namestr; eext: extstr;
  config        : text;
  configline    : string[80];
begin
  epath := (paramstr (0));
  fsplit(fexpand(epath),edir,ename,eext); { break up path into components }
  cpath := edir+ename+'.cfg';

  Compressor := 'pkzip -# -m';
  if fileexists(cpath) then
  begin
    assign (config, cpath);
    reset (config); iocheck(ioresult);
    repeat  { find vars }
      readln(config,configline);
      if (length(configline) > 11) and
        (copy(configline,1,11) = 'compressor=') then
        Compressor := Copy(configline,12,length(configline)-11);
    until eof(config); { loop back to read another line }
    close (config);
  end;
end;

function CompressDAT(const QWKfile, DATfile: string;
                     Const Compressor: pathstr): boolean;
var
  x,y : byte;
begin
  x:=WhereX;
  y:=WhereY;
  write('> ',Compressor);
  swapvectors;
     exec (getenv ('COMSPEC'),' /c '+compressor+' '+QWKfile+' '+DATfile);
     if doserror <> 0 then showhelp(5);
  swapvectors;
  GotoXY(x,y);
  ClrEOL;
  cursorOff;
  CompressDAT := fileexists(QWKfile)
end;
{===========================================================================}

Const SepLine='====================================='+
              '======================================';

Var
  SLMRname: pathstr;  DATname: string;
  SLMRfile: text;     DATfile: file;
  SLMRline: string;   SLMRmsg  : SLMRarray;
  index, bytes, chunks: word;
  Compressor : pathstr;

  dirinfo   : searchrec;  { contains filespec info.    }
  spath     : pathstr;    { source file path,          }
  sdir      : dirstr;     {             directory,     }
  sname     : namestr;    {             name,          }
  sext      : extstr;     {             extension.     }
  filesdone : word;

begin
  if paramcount <> 1 then
    showhelp(0)
  else
    spath := ParamStr(1);

  if spath[1] in ['/','-'] then showhelp(0);
  fsplit(fexpand(spath),sdir,sname,sext); if (sname = '')  then showhelp(6);
  findfirst(spath, archive, dirinfo);

  filesdone := 0;
  while (DOSerror = 0) do begin
     inc(filesdone);
     SLMRname := sdir+dirinfo.name;
     PrepareFiles(SLMRname, SLMRfile, DATname, DATfile);

     readln(SLMRfile,SLMRline); iocheck(ioresult); inc(lineNumb);
     repeat
       if (SLMRline = SepLine) and (NOT EOF(SLMRfile)) then begin
         bytes := 0;  updateCursor;
         SLMRline := ReadSLMRheader(SLMRfile);

         repeat
           if (bytes < MaxBytes) then
             bytes := AddToArray(SLMRmsg, bytes, SLMRline);
           readln(SLMRfile,SLMRline); iocheck(ioresult); inc(lineNumb);
         until (SLMRline = SepLine) or Eof(SLMRfile);
         if Eof(SLMRfile) and (bytes < MaxBytes) then
           bytes := AddToArray(SLMRmsg, bytes, SLMRline);

         if (bytes > MaxBytes) then bytes := MaxBytes;
         while (SLMRmsg[bytes]=#227) and (SLMRmsg[bytes-1]=#227) do
           dec(bytes);

         index := AddToArray(SLMRmsg, 116, FigureMSGsize(bytes, chunks));
         if (chunks > 1) then begin
           for index := (bytes+1) to (chunks*128) do
             SLMRmsg[index] := #32;
         end;

         BlockWrite(DATfile, SLMRmsg, chunks*128); iocheck(ioresult);
       end
       else begin
         readln(SLMRfile); iocheck(ioresult); inc(lineNumb); {discard invalid lines}
       end;
     until EOF(SLMRfile);

     Close(SLMRfile); iocheck(ioresult);
     Close(DATfile); iocheck(ioresult);
     writeln('done!');

     InitCompressor(Compressor);
     write('Compressing MESSAGES.DAT into ',SLMRname,'.mrq ... ');
     if CompressDat(SLMRname+'.mrq', DATname, Compressor) then
       writeln('done!')
     else
       showhelp(5);

     findnext(dirinfo);
  end;
  if (filesdone=0) then
    showhelp(1)
  else
    writeln('Processed ', filesdone, ' file(s).');

  cursorOn
end.
