#include system.hdr
#include string.hdr
#include screen.hdr
#include error.hdr
#include io.hdr
#include pick.hdr
#include math.hdr
#include date.hdr
#include xsvforce.hdr

#PRAGMA W_FUNC_PROC-
#PRAGMA W_PRECISION-
#PRAGMA W_GET_LOCAL-
#PRAGMA W_INDIRECT-
#PRAGMA W_EXTERN-

#define  TRUE            .T.
#define  FALSE           .F.
#define  NULL            ""

#DEFINE  BLACK_LIGHT_GREY     007
#DEFINE  BLACK_LIGHT_BLUE     009
#DEFINE  BLACK_LIGHT_GREEN    010
#DEFINE  BLACK_LIGHT_CYAN     011
#DEFINE  BLACK_LIGHT_RED      012
#DEFINE  BLACK_YELLOW         014
#DEFINE  BLACK_WHITE          015
#DEFINE  CYAN_BLACK           048
#DEFINE  CYAN_YELLOW          062

#DEFINE  K_TAB               9
#DEFINE  K_ENTER            13
#DEFINE  K_ESC              27
#DEFINE  K_F7            32833
#DEFINE  K_LEFT          32843
#DEFINE  K_RIGHT         32845

VARDEF EXTERN
   BYTE                  __color_std, __color_enhcd
   UINT                  __errcode, __max_row, __max_col
ENDDEF

VARDEF
   CHAR                  Work, ADrvs
   CHAR(80)              SCDR, C_Dir
   CHAR(44)              FStr
   CHAR(40)              A_Path
   CHAR(18)              KStr
   CHAR(12)              A_Srch
   CHAR(1)               A_Drive, C_Drv
   INT                   SCD, smod, cmod, ok
   INT                   Next_Row, Start_Col, Start_Row, DC
   INT                   Str_Pos, End_Pos, Hld_Pos, RC
   INT                   F_Len, DNbr, DVal, PUR, PUC, PDR, PLR, PLC
   INT                   FNbr, FVal, UR, UC, LR, LC
   UINT                  Counter, gkey, pick_key, C_Drive
   LONG                  FLst, DLst
ENDDEF

FUNCTION INT _getmode PROTOTYPE

FUNCTION INT _videomode PROTOTYPE
  PARAMETERS VALUE INT Mode

FUNCTION CHAR _drivestr PROTOTYPE
  PARAMETERS CONST CHAR ADrv

PROCEDURE Force_Error
  ?? 'RTE-'+I_STR(__errcode)+":"
  ?? e_message()
  SELECT_DRIVE(SCD)
  CHDIR(SCDR)
  QUIT __errcode
ENDPRO

FUNCTION UINT get_prc
  VARDEF
    UINT                  k
  ENDDEF
  k = LASTKEY()
  DO CASE
    CASE k = &K_LEFT
      pick_key = &K_LEFT
      RETURN &K_ESC
    CASE k = &K_RIGHT
      pick_key = &K_RIGHT
      RETURN &K_ESC
    CASE k = &K_ENTER
      pick_key = &K_ENTER
      RETURN &K_ENTER
    CASE k = &K_ESC
      pick_key = &K_ESC
      RETURN &K_ESC
  ENDCASE
  RETURN k
ENDPRO


PROCEDURE Pick_Files
  VARDEF
     CHAR                  SDir
     CHAR(80)              CDD
     CHAR(12)              S_FFil
     CHAR(10)              S_Siz
     CHAR(8)               S_Dat, S_Fil, S_Tim
     CHAR(3)               S_Ext
     CHAR(1)               S_Drv
     INT                   S_Len, S_Col, S_End, NF
     LOGICAL               D_Flag, F_Flag, G_Flag, N_Flag, S_Flag
  ENDDEF

  D_Flag = &TRUE
  PDR    = I_TRUNC((__max_row-1)/2)
  PLR    = PDR-1

  DO WHILE D_Flag
    FLst    = PICK_INIT()
    DLst    = PICK_INIT()
    RC      = 0
    NF      = 0
    DC      = 0
    Hld_Pos = 0
    Str_Pos = 0
    End_Pos = 0
    S_FFil  = &NULL
    S_Fil   = &NULL
    S_Ext   = &NULL
    S_Siz   = &NULL
    S_Dat   = &NULL
    S_Tim   = &NULL
    S_Drv   = &NULL
    FStr    = &NULL
    KStr    = &NULL

    CDD     = &NULL
    S_Flag  = &FALSE
    N_Flag  = &FALSE
    C_Drive = CURDRIVE()
    C_Dir   = RTRIM(CURDIR(0))
    CDD     = CHR(C_Drive + 65)+":"+C_Dir
    SDir    = CDD
    SET DEFAULT TO CDD

    IF FIND_FIRST('*.*',&FIND_SUBDIR)
      REPEAT
        IF FIND_FATTR() = 0x10
          DC = DC + 1
          S_FFil  = RTRIM(FIND_FSTR())
          S_Ext   = RTRIM(FIND_FEXT())
          Hld_Pos = AT(".",S_FFil)
          IF Hld_Pos > 1
            S_Fil = LEFT(S_FFil,Hld_Pos-1)
            S_Ext = S_Ext + SPACE(3 - LEN(S_Ext))
          ELSE
            S_Fil = LEFT(S_FFil,8)
            S_Ext = "   "
          ENDIF
          S_Fil = S_Fil + SPACE(8 - LEN(S_Fil))
          S_Fil = RTRIM(S_Fil)
          IF RIGHT(S_Fil,1) = "\"
            S_Fil = LEFT(S_Fil, LEN(S_Fil)-1)
          ENDIF
          S_Fil = S_Fil + SPACE(8 - LEN(S_Fil))
          S_Siz = '<DIR>'
          KStr  = S_Fil+" "+S_Ext+" "+S_Siz
          PICK_ADD(DLst, KStr)
        ENDIF
      UNTIL .NOT. FIND_NEXT()
    ENDIF

    IF FIND_FIRST(A_Srch,&FIND_ANYFILE)
      REPEAT
        IF ((FIND_FATTR() = 0x20) .OR. (FIND_FATTR() = 0x00))
          RC = RC + 1
          S_FFil  = RTRIM(FIND_FSTR())
          S_Ext   = RTRIM(FIND_FEXT())
          Hld_Pos = AT(".",S_FFil)
          IF Hld_Pos > 1
            S_Fil = LEFT(S_FFil,Hld_Pos-1)
            S_Ext = S_Ext + SPACE(3 - LEN(S_Ext))
          ELSE
            S_Fil = LEFT(S_FFil,8)
            S_Ext = "   "
          ENDIF
          S_Fil = S_Fil + SPACE(8 - LEN(S_Fil))
          S_Siz = SPACE(10 - LEN(I_STR(FIND_FSIZE()))) + I_STR(FIND_FSIZE())
          S_Dat = DTOC(FIND_FDATE())
          S_Tim = FIND_FTIME()
          FStr = "  "+S_Fil+" "+S_Ext+" "+S_Siz+" "+S_Dat+" "+S_Tim+" "
          PICK_ADD(FLst, FStr)
        ENDIF
      UNTIL .NOT. FIND_NEXT()
    ENDIF
    IF RC = 0
      RC = RC + 1
      NF = 1
      FStr  = "  No files found..."
      PICK_ADD(FLst, FStr)
    ENDIF

    IF RC > 0
      @ 01,01 TO __max_row-1,78 CLEAR
      IF DC > 0
        PUR = 03
        PUC = 52
        PLC = 69
        __color_std = &CYAN_BLACK
        @ 01,51 ?? " Directories"
        __color_std = &CYAN_YELLOW
        ?? "(" + I_STR(DC) + ') '
        __color_std = &CYAN_BLACK
        FILL(02,51,PDR,70,&SINGLE_BOX," ",&BLACK_LIGHT_BLUE,&CYAN_BLACK,0)
        __color_std = &BLACK_LIGHT_GREEN
        @ PDR,54 ?? " ENTER "
        __color_std = &BLACK_YELLOW
        @ PDR,61 ?? "or "
        __color_std = &BLACK_LIGHT_CYAN
        @ PDR,64 ?? "Tab "
        DVal = 1
        PICK_LIST(DLst, PUR, PUC, PLR, PLC, DVal, &TRUE, &FALSE)
      ENDIF
      __color_std = &CYAN_BLACK
      @ 01,02 ?? " Files"
      __color_std = &CYAN_YELLOW
      IF NF = 0
        ?? "(" + I_STR(RC) + ') '
      ELSE
        ?? '(0) '
      ENDIF
      __color_std = &CYAN_BLACK
      FILL(02,01,__max_row-1,46,&SINGLE_BOX," ",&BLACK_LIGHT_BLUE,&CYAN_BLACK,0)
      __color_std = &BLACK_YELLOW
      @ 02,02 ?? "  FileName Ext -- Size -- - Date - - Time -"
      __color_std = &BLACK_LIGHT_GREEN
      @ __max_row-1,07 ?? " ENTER "
      __color_std = &BLACK_YELLOW
      @ __max_row-1,14 ?? "or "
      __color_std = &BLACK_LIGHT_CYAN
      @ __max_row-1,17 ?? "Tab  "
      __color_std = &BLACK_WHITE
      @ __max_row-1,22 ?? "F7=Drive  "
      __color_std = &BLACK_LIGHT_RED
      @ __max_row-1,32 ?? "Esc=Quit "
      CURSOR_OFF()
      UR   = 03
      UC   = 02
      LR   = __max_row-2
      LC   = 45
      FVal = 1
      DO WHILE .NOT. S_Flag
        PICK_LIST(FLst, UR, UC, LR, LC, FVal, &FALSE, &TRUE)
        IF LASTKEY() == &K_TAB
          PICK_LIST(DLst, PUR, PUC, PLR, PLC, DVal, &FALSE, &TRUE)
          IF LASTKEY() <> &K_ESC
            KStr = PICK_STR(DLst,DVal)
            IF SUBSTR(KStr,10,3) <> "   "
              CHDIR(RTRIM(SUBSTR(KStr,1,8))+"."+SUBSTR(KStr,10,3))
            ELSE
              CHDIR(RTRIM(SUBSTR(KStr,1,8)))
            ENDIF
            A_Path = RTRIM(CURDIR(0))
            __color_std = &BLACK_LIGHT_CYAN
            @ 02,17 ?? SPACE(40)
            @ 02,17 ?? A_Path
          ELSE
            D_Flag = &FALSE
          ENDIF
          S_Flag = &TRUE
        ELSE
          IF LASTKEY() = &K_F7
            CURSOR_ON()
            S_Col = 08
            S_End = 08+LEN(ADrvs)-1
            SAVE_AREA(01,01,01,S_End+1)
            __color_std = &CYAN_BLACK
            @ 01,01 ?? 'Drive?'
            __color_std = &BLACK_WHITE
            @ 01,08 TO 01,S_End+1 CLEAR
            __color_std   = &BLACK_LIGHT_CYAN
            __color_enhcd = &CYAN_BLACK
            G_Flag = &FALSE
            DO WHILE .NOT. G_Flag
              @ 01,08 ?? ADrvs
              S_Drv = SUBSTR(ADrvs,S_Col-7,1)
              @ 1,S_Col GET S_Drv PICTURE "@!" FILTER get_prc()
              READ
              DO CASE
                CASE pick_key = &K_RIGHT
                  S_Col = S_Col + 1
                  IF S_Col > S_End
                    S_Col = 08
                  ENDIF
                  pick_key = 0
                CASE pick_key = &K_LEFT
                  S_Col = S_Col - 1
                  IF S_Col < 08
                    S_Col = S_End
                  ENDIF
                  pick_key = 0
                CASE pick_key = &K_ENTER
                  C_Drv  = S_Drv
                  N_Flag = &TRUE
                  G_Flag = &TRUE
                  __color_std = &BLACK_LIGHT_CYAN
                  A_Drive = C_Drv
                  @ 02,08 ?? A_Drive
                CASE pick_key = &K_ESC
                  S_Drv = &NULL
                  G_Flag = &TRUE
                  D_Flag = &FALSE
              ENDCASE
            ENDDO
            CURSOR_OFF()
            RESTORE_AREA()
            __color_std = &CYAN_BLACK
          ELSE
            D_Flag = &FALSE
          ENDIF
          S_Flag = &TRUE
        ENDIF
      ENDDO
      IF N_Flag
        SELECT_DRIVE(ASC(C_Drv) - 65)
        A_Path = RTRIM(CURDIR(0))
        __color_std = &BLACK_LIGHT_CYAN
        @ 02,17 ?? SPACE(40)
        @ 02,17 ?? A_Path
      ENDIF
      CURSOR_ON()
      __color_std = &BLACK_LIGHT_GREY
    ENDIF
  ENDDO
  PICK_CLEAR(FLst)
  PICK_CLEAR(DLst)
  @ 01,01 TO __max_row-1,78 CLEAR
  SELECT_DRIVE(SCD)
  CHDIR(SCDR)
  A_Path = RTRIM(CURDIR(0))
  __color_std = &BLACK_LIGHT_GREY
ENDPRO

PROCEDURE force_main

  ON ERROR DO FORCE_Error

  INITXS()

  ADrvs = _drivestr(Work)

  A_Path = RTRIM(CURDIR(0))
  A_Srch = '*.*'
  SCD  = CURDRIVE()
  SCDR = CHR(SCD + 65)+":"+RTRIM(CURDIR(0))

  smod = _getmode()
  SAVE_SCREEN()
  Start_Row = ROW()
  Start_Col = COL()

  CLEAR
  @ 10,01 ?? 'Setting modes...please press any key.'
  REPEAT
    gkey = GET_KEY()
  UNTIL (gkey == &K_ENTER)
  cmod = 28
  ok   = _videomode(cmod)
  if ok <> 0
    @ 10,01 ?? 'UH-OH.  28 line mode not set.'
  else
    @ 10,01 ?? 'OK.  28 line mode set...please press any key.'
    REPEAT
      gkey = GET_KEY()
    UNTIL (gkey == &K_ENTER)
    __max_row = 28
    CLEAR
    Pick_Files()
  endif

  CLEAR
  cmod = 43
  ok   = _videomode(cmod)
  if ok <> 0
    @ 10,01 ?? 'UH-OH.  43 line mode not set.'
  else
    @ 10,01 ?? 'OK.  43 line mode set...please press any key.'
    REPEAT
      gkey = GET_KEY()
    UNTIL (gkey == &K_ENTER)
    __max_row = 43
    CLEAR
    Pick_Files()
  endif

  CLEAR
  cmod = 50
  ok   = _videomode(cmod)
  if ok <> 0
    @ 10,01 ?? 'UH-OH.  50 line mode not set.'
  else
    @ 10,010 ?? 'OK.  50 line mode set...please press any key.'
    REPEAT
      gkey = GET_KEY()
    UNTIL (gkey == &K_ENTER)
    __max_row = 50
    CLEAR
    Pick_Files()
  endif

  CLEAR
  ok = _videomode(smod)
  @ 10,01 ?? 'Original mode reset...please press any key.'
  REPEAT
    gkey = GET_KEY()
  UNTIL (gkey == &K_ENTER)

  SELECT_DRIVE(SCD)
  CHDIR(SCDR)
  RESTORE_AREA()
  @ Start_Row, Start_Col

ENDPRO
