* dotext.prg to try to set up funckyII ET text editing sys

#define NUM 3
#include io.hdr
#include system.hdr
#include iif.hdr
#include data.hdr

VarDef
    long        TEXTEDIT[3]
    CHAR(30)    sometext := "This is an entry            "
    char(30)    moretext := "This is More Text!          "
    char(12)    anumber  := "0.00"
EndDef

FUNCTION LONG _etCreate PROTOTYPE
   PARAMETERS Value Int aRow, Value Int aCol, const char abuffer,;
                Value Int attrib, value int asize,const char apicture

PROCEDURE _etDisplay PROTOTYPE
    PARAMETERS value long textedit[&NUM]

PROCEDURE DOEDIT PROTOTYPE    // Actual keyboard handler you write
    parameters  value int numvars
       //  value long textedit[2],

FUNCTION INT _etScrRow PROTOTYPE
    PARAMETERS value long textedit[&NUM]

FUNCTION INT _etScrCol PROTOTYPE
    PARAMETERS value long textedit[&NUM]

PROCEDURE _csrput PROTOTYPE
    PARAMETERS value int arow, value int acol

PROCEDURE _etInsert PROTOTYPE
    PARAMETERS value long textedit[&NUM],value int nKey

PROCEDURE _etOverWrite PROTOTYPE
    PARAMETERS value long textedit[&NUM],value int nKey

PROCEDURE _etBackSpace PROTOTYPE
    PARAMETERS value long textedit[&NUM]

PROCEDURE _etCsrLeft PROTOTYPE
    PARAMETERS value long textedit[&NUM],value int acount

PROCEDURE _etCsrRight PROTOTYPE
    PARAMETERS value long textedit[&NUM],value int acount

PROCEDURE _etDelete PROTOTYPE
    PARAMETERS value long textedit[&NUM]

PROCEDURE _etCsrEnd PROTOTYPE
    PARAMETERS value long textedit[&NUM]

PROCEDURE _etCsrHome PROTOTYPE
    PARAMETERS value long textedit[&NUM]

PROCEDURE _etfree PROTOTYPE
    PARAMETERS value long textedit[&NUM]

PROCEDURE _etRetrieve PROTOTYPE
    PARAMETERS value long textedit[&NUM],value int amode,const char abuffer

PROCEDURE _etSetFocus PROTOTYPE
    PARAMETERS value long textedit[&NUM],value int aflag

PROCEDURE _csrtype PROTOTYPE
    PARAMETERS value int csrsize
    // 0 = bottom 2 scan lines, 1 - half-cursor
    
PROCEDURE _etActiveColor PROTOTYPE
    PARAMETERS Value long textedit[&NUM], value int colorattr
    
PROCEDURE _etClear PROTOTYPE
    PARAMETERS value long textedit[&NUM]

procedure force_main
    
    __color_std := 31
    clear

    TEXTEDIT[0] := _etCreate(10, 27, sometext,113, 28, "@!")

    TEXTEDIT[1] := _etCreate(11, 27, moretext,113, 28, "@!")

    TEXTEDIT[2] := _etCreate(12, 34, anumber, 113, 12, "@$@F11.2@,,")
    
    @ 10,0 ?? "Hey How About This Stuff: "
    @ 11,0 ?? "How about Them # Twos   : "
    @ 12,0 ?? "Let's enter Adding Machine Style: "
    
    _etActiveColor(TEXTEDIT[0],94)
    _etActiveColor(TEXTEDIT[1],79) 
    _etActiveColor(TEXTEDIT[2],116)
    
    DOEDIT(3)
    
    _etRetrieve(TEXTEDIT[0],0,sometext)
    _etRetrieve(TEXTEDIT[1],0,moretext)
    _etRetrieve(TEXTEDIT[2],0,anumber)
    
    @ 14,0 ?? sometext
    @ 15,0 ?? moretext
    @ 16,0 ?? anumber
    
    _etfree(TEXTEDIT[])
    
    @ 18,0 ?? "That's All Folks!"
endpro

PROCEDURE DOEDIT
    parameters value int numvars
       //    value long textedit[2], (since public can reference directly)
VarDef
    int     nkey
    logical insertmode
	int		aindex
    int     acount
	int		x
    logical firstchar
EndDef

insertmode := insert_key()
if insertmode
    _csrtype(1)
else
    _csrtype(0)
endif

firstchar := .t.
nkey := 0
aindex := 0
acount := numvars - 1
x := 0
do while x <= acount
    _etDisplay(TEXTEDIT[x])
x++
enddo

_etSetFocus(TEXTEDIT[aindex], 1)

do while .t.
    _etDisplay(TEXTEDIT[aindex])
    _csrput(_etscrrow(TEXTEDIT[aindex]),_etscrcol(TEXTEDIT[aindex]))
    nKey := get_key()

    do case
        case nKey >= 32 .and. nKey <= 255
            if firstchar = .t.
                _etclear(TEXTEDIT[aindex])
                firstchar := .f.
            endif
            if insert_key()
                _etInsert(TEXTEDIT[aindex],nKey)
            ELSE
                _etOverWrite(TEXTEDIT[aindex], nKey)
            endif
        case nKey = 27
            exit
        case nKey = 32850 // Insert Key
            insertmode := insert_key()
            if insertmode
                _csrtype(1)
            else
                _csrtype(0)
            endif
        case nKey = 8      //  BS
            IF firstchar = .t.
                firstchar := .f.
            endif
           _etBackSpace(TEXTEDIT[aindex])
        case nKey = 32845     // right
            if firstchar = .t.
                firstchar := .f.
            endif
           _etCsrRight(TEXTEDIT[aindex],1)
        case nKey = 32843  // left
            if firstchar = .t.
                firstchar := .f.
            endif
           _etCsrLeft(TEXTEDIT[aindex],1)
        case nKey = 9 // tab
            _etCsrRight(TEXTEDIT[aindex],5)
        case nKey = 32783    // Shift-Tab
            _etCsrLeft(TEXTEDIT[aindex],5) 
        case nKey = 32851      // delete
            _etDelete(TEXTEDIT[aindex])
        case nKey = 32839     // home
            if firstchar = .t.
                firstchar := .f.
            endif
            _etCsrHome(TEXTEDIT[aindex])
        case nKey = 32847	 // end
            _etCsrEnd(TEXTEDIT[aindex])
        case nKey = 32887    // ctrl-home
             _etSetFocus(TEXTEDIT[aindex],0)
			 _etDisplay(TEXTEDIT[aindex])
             aindex := 0
             _etSetFocus(TEXTEDIT[aindex],1)
        case nKey = 32885    // ctrl-end
             _etSetFocus(TEXTEDIT[aindex],0)
			 _etDisplay(TEXTEDIT[aindex])
             aindex := acount
             _etSetFocus(TEXTEDIT[aindex],1)
        case nKey = 32840 // UP
			_etSetFocus(TEXTEDIT[aindex],0)
			_etDisplay(TEXTEDIT[aindex])
            IF aindex = 0
                exit
            endif
            aindex := aindex - iifN(aindex = 0,0,1)
            firstchar := .t.
            _etSetFocus(TEXTEDIT[aindex],1)
        case nKey = 32848 .OR. nKey = 13         //down or ENTER
            _etSetFocus(TEXTEDIT[aindex], 0)
            _etDisplay(TEXTEDIT[aindex])
            if aindex = acount
                exit
            endif
            aindex = aindex + iifN( aindex = acount, 0, 1 )
            firstchar := .t.
            _etSetFocus(TEXTEDIT[aindex], 1)
        case nKey = 10 .or. nKey = 23   // ctrl-enter or ctrl-W
            exit
    endcase

enddo

endpro
