/*
        testdoor.c - A sample door to demonstrate TDoor/Pro
	Copyright (c) 1992-1995 By TriSoft

	Compile as follows:

        Borland C++ 3.1: bcc -ml testdoor.c bc31tdp.lib ripbc31.lib graphics.lib
        Borland C++ 4.5: bcc -ml -1- testdor.c bc45td.lib ripbc45.lib graphics.lib
        Turbo C++      : tcc -ml testdoor.c tc30tdp.lib riptc30.lib graphics.lib
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <graphics.h>
#include "tdoor.h"

#define TRUE 1
#define FALSE 0

void displaywelcome(void);
void playgame(void);

char ripborder[] = "!|1K|*|w06082D0W11|s3B3B3B073B3B3B3407|B01000T9P|BGY00HS9P|B0U7KGY9P|B0U00GY1K\r\n"
	"!|Y04000300|1B00000200MG060D000F080700000F07000000\r\n"
	"!|1U5A07BV1E0000<>Testdoor 1.0<>|1B00000202ZU030E000F080700000F07000000\r\n"
	"!|Y00000100|1U7184A68Z2900<>Quit<>0^MN|#|#|#\r\n";

void main(int argc, char *argv[])
{
	TDInitialize(argc, argv);
	strcpy(TDDoorName, "TestDoor 1.01");
	randomize();
	if (TDEmulatorType)
		TDDisplayRIPString(ripborder);
	displaywelcome();
	while (TRUE)
		playgame();
}

void displaywelcome(void)
{
	TDSetColor(WHITE, BLACK);
	TDClrScr();
	TDPrintf("TestDoor 1.01\n");
	TDSetColor(YELLOW, BLACK);
	TDPrintf("Copyright (c) 1992-1995 By Mark Goodwin\n\n");
}

void playgame(void)
{
	int computernum, usernum, win, numguesses, input;
	char line[81];

	TDSetColor(LIGHTCYAN, BLACK);
	computernum = random(1000 + 1);
	win = FALSE;
	numguesses = 0;
	TDSetColor(LIGHTMAGENTA, BLACK);
	TDPrintf("The computer is thinking of a number from 1-1000!\n");
	do {
		numguesses++;
		TDSetColor(LIGHTGREEN, BLACK);
		TDPrintf("Enter a number from 1-1000 (0 to quit): ");
		TDSetColor(LIGHTRED, BLACK);
		TDGets(line, 81);
		usernum = atoi(line);
		if (usernum < 0 || usernum > 1000) {
			TDSetColor(YELLOW, BLACK);
			TDPrintf("Number must be between 1 and 1000!!\n");
		}
		if (usernum) {
			if (computernum == usernum)
				win = TRUE;
			else {
				TDSetColor(YELLOW, BLACK);
				if (usernum > computernum)
					TDPrintf("   Too high!\n");
				else
					TDPrintf("   Too low!\n");
			}
		}
	} while (!win && usernum);
	TDSetColor(YELLOW, BLACK);
	if (win)
		TDPrintf("You got it in %d guesses\n", numguesses);
	TDPrintf("Play again (y/n)? ");
	do {
		input = TDGetch();
		input = toupper(input);
	} while (input != 'Y' && input != 'N');
	TDSetColor(LIGHTCYAN, BLACK);
	if (input =='N') {
		TDPrintf("No\n\n");
		exit(0);
	}
	TDPrintf("Yes\n\n\n");
}
