/* ---------------------------------------------------- */
/* (c) 1995 Niksoft International                       */
/* SPRITE CUTTER UTILITY v2.0                           */
/* ---------------------------------------------------- */
/* INTERFAC.H                                           */
/* interface items module                               */
/* - Menu                                               */
/* - Input box                                          */
/* - Message box                                        */
/* ---------------------------------------------------- */

#ifndef __MENUH

#define __MENUH

typedef struct {
                char     label[10];
                unsigned command;
               } MENU_ITEM;

typedef struct {
                char      title[10];
                unsigned  no_voices;
                MENU_ITEM *voices;
               } MENU;
#endif

#define NO_PROMPT       0
#define PROMPT          1

extern int Do_menu(MENU *, unsigned , unsigned);
/* perform the menu'                                 */
/* Parameters:                                       */
/*  MENU *    pointer to the menu structure          */
/*  unsigned  X coordinate of menu window            */
/*  unsigned  Y coordinate of menu window            */
/* Returns:                                          */
/*  The command selected                             */
/*  -1 if an error occurs                            */

extern int Input_box(const char *, char *, unsigned, unsigned, unsigned);
/* Keyboard input                                     */
/* Parameters:                                        */
/*  char *    prompt                                  */
/*  char *    buffer where the char read are placed   */
/*  unsigned  buffer size                             */
/*  unsigned  X coordinate of input window            */
/*  unsigned  Y coordinate of input window            */
/* Returns:                                           */
/*  The length of the string read                     */
/*  -1 if an error occurs                             */

extern int Message_box(char *, unsigned, unsigned, unsigned);
/* Show a message in a window waiting for a yes/no    */
/* answer if requested                                */
/* Parameters:                                        */
/*  char *    the message                             */
/*  unsigned  X coordinate ...                        */
/*  unsigned  Y coordinate ...                        */
/*  unsigned  if non zero waits for yes/no answer     */
/* Returns:                                           */
/*  0  if all is OK or the answer (if requested) is   */
/*  no.                                               */
/*  1 if the answer (if requested) is yes.            */
/*  -1 if an error occurs                             */
