#if !defined(__SPOBJS_H)
#define __SPOBJS_H

#if !defined(__STDIO_H)
#include <stdio.h>
#endif
#if !defined(__STRING_H)
#include <string.h>
#endif
#if !defined(_XMSARRAY_H) && !defined (__WINDOWS_H)
#include "xmm.h"
#include "xms.h"
#endif
#if !defined (_EMSARRAY_H) && !defined (__WINDOWS_H)
#include "ems.h"
#endif

int max (int value1, int value2);

const int TYPOS_MATCH = 0x100,
	  PHONETIC_MATCH =0x200,
	  COMPLEX_MATCH = 0x400;

const int AUTO_MEMORY = -1,
          XMS_MEMORY  =  0,
          DISK_MEMORY =  1;

#define USER_DIC 1
#define TEMP_DIC 2

#define LAST_LETTER  'z' - 'a'  // don't change it

extern const char *hiValue;
#define  NSFX 31
//extern char *sfx[NSFX];
//extern const int ItemsInPage ;

#if !defined(__WINDOWS_H)
enum Bool {FALSE=0,TRUE=1};
#endif

typedef unsigned char Uchar;
struct Symbol {
         Uchar degree;
         char name[1];
	 };


class MatchTable {
	public:
		int size;
		int count;
		int error;
		MatchTable(int sz,int dups=FALSE);
		~MatchTable();
		int AddMatch(char*,int);
		FindMatch(Symbol*);
		int seekMatch(Symbol *);
		void delMatch(int);
                Symbol * get(int i) {return table[i];}
                virtual void    PrintMatch();
                void clear();
		int resize(int newSize);
	 protected:
	Symbol** table;
	int Compare(Symbol*,Symbol*);
	int lower;
	int duplicate;
};
struct element {
   element* prev;
   element* next;
   element *lru_prev;
   element *lru_next;
   char name[16];
};

class Table {
  protected:
    element** table;
	  int size;
    int *collis;
	  int Hash(char*);
    int probes;
    element *head;
    int maxsize;
    int items;
	public:
	int modified;
    Table(int sz=197,int msize=197);
		 ~Table();
    element* insert(char*);
    int      lookup(char*);
		load (char*);
		save (char*);
		void    PrintTable();
};



class SortedArray {
	public:
	int count;
	int maxWordLen;
	int modified;
        int error;
		SortedArray(int sz=16,int dt = 10);
		~SortedArray();
		char* insert(char*);
		lookup(char*);
		char *get(int Index);
		virtual load (char*);
		virtual save (char*);
		void clear();
		void    Print();
	protected:
	char** table;
	  int size;
	int delta;
	int lower;
};

class FastDictionary : public SortedArray
{

public:

    FastDictionary( short aLimit, short aDelta ) :
       SortedArray( aLimit, aDelta) {}
	virtual save(char *name) {return SortedArray::save(name);}
	virtual save(){if(Dname)
			return	SortedArray::save(Dname);
			else
			return 0;}
        setName(char *name);
        protected:
	char *Dname;
};
inline FastDictionary::setName(char *name)
{
if(name)
        { Dname=new char[strlen(name)];
          if (!Dname)
                return 0;
          strcpy(Dname,name);
          return 1;
        }
return 0;
}


////////////////////////////////////////////
//
// class Xms dictionary
//
////////////////////////////////////////////
struct tagHeader {
char sig[2];  // not used yet
short int maxSize;  // max length of words
long firstLetter[LAST_LETTER+1]; // index of A-Z in array
long indexSize;

};


struct tagAddHeader {
long fileSize;//
long index_offset;
long ext_header_offset;
short int data_offset;//
} ;

struct tagCheader {
long firstLetter[LAST_LETTER+2]; // index of A-Z in array
short int index_count;
};


struct IndexNode
{
  long ptr;
  long count;
  char *name;
} ;

#endif // __SPOBJS_H
