/*
**  by David Goodenough & Bob Stout
*/

#ifdef __TURBOC__
 #define FAR far
#else
 #define FAR _far
#endif

/*
**  Use old-style lvalue MK_FP() macro
*/

#undef MK_FP
#define MK_FP(seg,offset) \
        ((void FAR *)(((unsigned long)(seg)<<16) | (unsigned)(offset)))
 
#define biosseg 0x40

int fast_kbhit(void)
{
      return *((unsigned FAR *)MK_FP(biosseg, 0x1a)) -
            *((unsigned FAR *)MK_FP(biosseg, 0x1c));
}

void fast_kbflush(void)
{
      *((unsigned FAR *)MK_FP(biosseg, 0x1a)) =
            *((unsigned FAR *)MK_FP(biosseg, 0x1c));
}

#ifdef TEST

#include <stdio.h>
#include <conio.h>
#include <time.h>

main()
{
      clock_t Wait;

      puts("Hit some keys while I kill some time...");
      Wait = clock();
      while (2 > ((clock() - Wait) / CLK_TCK))
            ;

      puts("OK, stop hitting keys while I flush the keyboard...");
      Wait = clock();
      while (2 > ((clock() - Wait) / CLK_TCK))
            ;

      fast_kbflush();
      puts("OK, now hit some key you didn't hit before...");

      while (!fast_kbhit())
            ;
      printf("You hit %c\n", getch());
      return 0;
}

#endif
