// test program for VIDEO.ASM
// build with the command "cl /AL testpl.c video.obj"

#include <stdio.h>
#include <string.h>
#include <conio.h>

#include "video.h"

// dummy placeholders so that we can link in VIDEO.OBJ

int palette = 256;
unsigned char gcmap[3][256]  
	= { 0, 0, 0, 0, 0, 255, 0, 255, 0, 0, 255, 255, 255,
		0, 0, 255, 0, 255, 255, 255, 0, 255, 255, 255 };
unsigned char line[2048 * 3];

// ...so that we can display what chipset is detected
extern short chipset;
extern short memsize;

static char *boards[] = {
	"no graphic", "CGA or 64k EGA", "EGA", "VGA", "SVGA", "SVGA"
};
static char *chips[] = {
	"Cirrus", "Video 7", "Tseng", "Paradise", "C&T", "Trident",
	"ATI", "Everex", "Ahead A", "Ahead B", "VESA"
};

int i, j, k, xdots, ydots, mode;
char display[10]; modetype[40];

main()
{

i = vtype();
strcpy(display,"Unknown");
if (i == 4) strcpy(display, "SVGA2");
else if (i == 3) strcpy(display, "SVGA1");
else if (i == 2) strcpy(display, "VGA1");
else if (i == 1) strcpy(display, "EGA");
else if (i == 0) strcpy(display, "CGA");
if (i < 2)
    printf("Detected %s adapter\r\n", boards[i+1]);
else
    printf("Detected %dk %s adapter\r\n", memsize, boards[i+1]);
printf("%s chipset\r\n\r\n", chips[chipset-1]);

xdots = 640; ydots = 480; mode = 2; strcpy(modetype,"256 color");
svgacolor();

xdots = 1280; ydots = 1024; mode = 5; strcpy(modetype,"256 color");
svgacolor();

xdots = 600; ydots = 480; mode = 21; strcpy(modetype,"16-bit color");
truecolor();

xdots = 600; ydots = 480; mode = 31; strcpy(modetype,"24-bit color");
truecolor();

xdots = 800; ydots = 600; mode = 22; strcpy(modetype,"16-bit color");
truecolor();

xdots = 800; ydots = 600; mode = 32; strcpy(modetype,"24-bit color");
truecolor();

xdots = 1024; ydots = 768; mode = 23; strcpy(modetype,"16-bit color");
truecolor();

xdots = 1024; ydots = 768; mode = 33; strcpy(modetype,"24-bit color");
truecolor();

xdots = 1280; ydots = 1024; mode = 24; strcpy(modetype,"16-bit color");
truecolor();

}

svgacolor()
{
printf("Press a key to enter %dx%d %s mode and get a test pattern\n",
    xdots, ydots, modetype);
printf("and a second key to get back into text mode\n");
getch();
if (i = set_mode(0, mode, xdots) < 0) {
    printf("oops - set_mode returned %d\n",i);
    }
else {
    for (k = 999, j = 0; j < xdots; j++) {
            if (++k >= 256) k = 0;
            line[j] = k;
            }
    for (i = 0; i < ydots; i++) {
        svgaline(i, line);
        }
    getch();
    set_mode(0x03, 0, 0);
    }
}

truecolor()
{
int lim;

printf("Press a key to enter %dx%d %s mode and get a test pattern\n",
    xdots, ydots, modetype);
printf("and a second key to get back into text mode\n");
getch();
if (i = set_mode(0, mode, xdots) < 0) {
    printf("oops - set_mode returned %d\n",i);
    }
else {
    for (k = 999, j = 0; j < xdots; j++) {
            if (++k >= 256) k = 0;
            line[j] = k;
            line[j+xdots] = k;
            line[j+xdots+xdots] = k;
        if (j >= xdots/2)
                line[j+xdots] = line[j+xdots+xdots] = 0;
        }
    for (lim = ydots/3, i = 0; i < lim; i++) {
        truecolorline(i, line);
        }
    for (k = (xdots/2)%256 - 1, j = xdots/2; j < xdots; j++) {
        if (++k >= 256) k = 0;
        line[j] = 0;
        line[j+xdots] = k;
        line[j+xdots+xdots] = 0;
        }
    for (lim = ydots*2/3; i < lim; i++) {
        truecolorline(i, line);
        }
    for (k = (xdots/2)%256 - 1, j = xdots/2; j < xdots; j++) {
        if (++k >= 256) k = 0;
        line[j] = 0;
        line[j+xdots] = 0;
        line[j+xdots+xdots] = k;
            }
    for (; i < ydots; i++) {
        truecolorline(i, line);
        }
    getch();
    set_mode(0x03, 0, 0);
    }
}
