/* PLSHOW.C : Screen display routines for PICLAB.  Command handler for
** SHOW is here.  Requires external routines from VIDEO.ASM.
*/

#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <conio.h>

#include "piclab.h"
#include "sierra"
#include "yiq"

/* VGA DAC register values for 256-level pseudo-grayscale.	All values
** are 0..63 in red, green, blue order.
**
** Values in gamma2[] are used for displaying images encoded at a
** gamma near 2.0, and gamma1[] is used for displaying images encoded
** at near 1.0.
**
** Tables created by Lee Daniel Crocker on 6/2/89 based on an idea by
** Mark Peterson and Mike Vigneau.	This is public domain.
*/

GLOBAL U8 graymap[256][3];

static U8 epal[] = { 000, 044, 022, 066, 011, 055, 033, 077 };

static union REGS regs;
//static char unimp[] = "This display mode is not supported in version %s.\n";
static int xmax, ymax;

#pragma loop_opt(off)

int showpic(int ac, argument *av)
{
	U32 mem, mem2;

	struct _plane *ip[3];
	int k, d, i, l, r, p, np, mode, ctype, sline;
	int xoff, yoff, xsize, ysize, ylimit, lines;
	U8 *dp, *cp[3], *sp, *tp, *olddac, *newdac;
	r = 0;
	mem = mark();
	regs.x.ax = 0x0F00; 		/* Get current video mode for	*/
	int86(0x10, &regs, &regs);	/* later restoration.			*/
	mode = regs.h.al;

	switch (ac) {
		case 1: xoff = xorigin; 		yoff = yorigin; 		break;
		case 2: xoff = (int)av[1].fval; yoff = yorigin; 		break;
		default: pl_warn(1);
		case 3: xoff = (int)av[1].fval; yoff = (int)av[2].fval; break;
	}
	d = -1;
	l = strlen(display);
	for (i=0; displays[i].name != NULL; ++i) {
		if (strncmp(display, displays[i].name, l) == 0) {
			d = i; break;
		}
	}

	if (d == -1) return 9;
	else {
      /* changed 'set_mode()' to accept a linelength - BDT */
      if ((r = set_mode(displays[d].pax, displays[d].pbx,
           displays[d].width)) != 0) {
              /* new error message and better exit - BDT */
		if ((ctype = displays[d].ctype) == 3) {
			regs.x.ax = 0x10F1;
			regs.h.bl = 0xFF;
			int86(0x10, &regs, &regs);
			if (regs.x.ax != 0x10 || regs.h.bl == 0x00 || regs.h.bl == 0xFF) {
				r = 2; goto abort;
			}
			setmode(displays[d-2].pax, displays[d-2].pbx);
		}
         r = 11; goto abort_nomode;
		}
		xmax = displays[d].width;
		ymax = displays[d].height;
	}
   if ((ctype = displays[d].ctype) == 1 || ctype == 3) sp = (U8 *)talloc(3 * xmax);
	else sp = (U8 *)talloc(xmax);
	if (sp == NULL) return 2;
	if ((tp = (U8 *)talloc(xmax)) == NULL) return 2;


	if (ctype == 1) {
		for (i=0; i<8; ++i) {
			regs.x.ax = 0x1000;
			regs.h.bl = (U8)(i + 8);
			regs.h.bh = epal[i];
			int86(0x10, &regs, &regs);
		}
		outpw(0x3CE, 0xFF08);
		outpw(0x3CE, 0x05);
		outpw(0x3CE, 0x03);
		outpw(0x3CE, 0x01);
	} else if (ctype == 2) {
		if ((olddac = (U8 *)talloc(768)) == NULL) return 2;
		readdac(olddac);
		if (new->flags & 2) {
			mem2 = mark();
			if ((dp = newdac = (U8 *)talloc(768)) == NULL) return 2;

			if (transpend) {
				for (i=0; i<256; ++i) {
					*dp++ = (lookup[0][gcmap[0][i]] >> 2);
					*dp++ = (lookup[1][gcmap[1][i]] >> 2);
					*dp++ = (lookup[2][gcmap[2][i]] >> 2);
				}
			} else for (i=0; i<256; ++i) {
				*dp++ = gcmap[0][i] >> 2;
				*dp++ = gcmap[1][i] >> 2;
				*dp++ = gcmap[2][i] >> 2;
			}
			writedac((U8 *)newdac);
			release(mem2);
		} else writedac((U8 *)graymap);
	}

	np = new->planes;
	for (p=0; p<np; ++p) if ((ip[p] = openplane(p, new, READ)) == NULL) {
		r = 3; goto abort;
	}
	while (1) {
		if ((xsize = new->width - xoff) <= 0) { r = 9; goto abort; }
		if ((ysize = new->height - yoff) <= 0) { r = 9; goto abort; }
		if (xsize > xmax) xsize = xmax;
		if (ysize > ymax) ysize = ymax;
		ylimit = yoff + ysize;

		if (new->flags & 1) sline = ymax-1; else sline = 0;
		for (p=0; p<np; ++p) seekline(ip[p], yoff);

		for (lines = yoff; lines < ylimit; ++lines) {
         if (ctype == 1 || ctype == 3) 
            memset(sp, 0, 3 * xmax); 
         else 
            memset(sp, 0, xmax);
			for (p=0; p<np; ++p) if (getline(ip[p]) == 0) { r = 4; goto abort; }
			if (new->flags & 2) {		/* color mapped */
				dp = ip[0]->linebuf + xoff;
				if (ctype == 0) {
					if (transpend) {
						xlat(dp, tp, gcmap[0], xsize);
						xlat(tp, tp, lookup[0], xsize);
						xlat(tp, sp, ry, xsize);
						xlat(dp, tp, gcmap[1], xsize);
						xlat(tp, tp, lookup[1], xsize);
						xlatp(tp, sp, gy, xsize);
						xlat(dp, tp, gcmap[2], xsize);
						xlat(tp, tp, lookup[2], xsize);
						xlatp(tp, sp, by, xsize);
					} else {
						xlat(dp, tp, gcmap[0], xsize);
						xlat(tp, sp, ry, xsize);
						xlat(dp, tp, gcmap[1], xsize);
						xlatp(tp, sp, gy, xsize);
						xlat(dp, tp, gcmap[2], xsize);
						xlatp(tp, sp, by, xsize);
					}
            } else if (ctype == 1 || ctype == 3) {
					if (transpend) {
						xlat(dp, sp, gcmap[0], xsize);
						xlat(sp, sp, lookup[0], xsize);
						xlat(dp, sp+xmax, gcmap[1], xsize);
						xlat(sp+xmax, sp+xmax, lookup[1], xsize);
						xlat(dp, sp+2*xmax, gcmap[2], xsize);
						xlat(sp+2*xmax, sp+2*xmax, lookup[2], xsize);
					} else {
						xlat(dp, sp, gcmap[0], xsize);
						xlat(dp, sp+xmax, gcmap[1], xsize);
						xlat(dp, sp+2*xmax, gcmap[2], xsize);
					}
				} else memcpy(sp, dp, xsize);

			} else if (np == 1) {		/* grayscale	*/
				dp = ip[0]->linebuf + xoff;
				if (transpend) xlat(dp, sp, lookup[0], xsize);
				else memcpy(sp, dp, xsize);

            if (ctype == 1 || ctype == 3) {
					memcpy(sp+xmax, sp, xsize);
					memcpy(sp+2*xmax, sp, xsize);
				}

			} else {					/* true color	*/
				for (i=0; i<3; ++i) cp[i] = ip[i]->linebuf + xoff;
            if (ctype == 1 || ctype == 3) {
					if (transpend) {
						xlat(cp[0], sp, lookup[0], xsize);
						xlat(cp[1], sp+xmax, lookup[1], xsize);
						xlat(cp[2], sp+2*xmax, lookup[2], xsize);
					} else {
						memcpy(sp, cp[0], xsize);
						memcpy(sp+xmax, cp[1], xsize);
						memcpy(sp+2*xmax, cp[2], xsize);
					}
				} else {
					if (transpend) {
						xlat(cp[0], tp, lookup[0], xsize);
						xlat(tp, sp, ry, xsize);
						xlat(cp[1], tp, lookup[1], xsize);
						xlatp(tp, sp, gy, xsize);
						xlat(cp[2], tp, lookup[2], xsize);
						xlatp(tp, sp, by, xsize);
					} else {
						xlat(cp[0], sp, ry, xsize);
						xlatp(cp[1], sp, gy, xsize);
						xlatp(cp[2], sp, by, xsize);
					}
				}
			}


			(*displays[d].linefunc)(sline, sp);
			if (keypressed()) break;
			if (new->flags & 1) --sline; else ++sline;
		}
      if(ctype == 1 || ctype == 3)
         memset(sp, 0, 3*xmax);  /* TW added this to clear bottom of screen */
      else
		memset(sp, 0, xmax);
		for (lines = ylimit; lines < (yoff+ymax); ++lines) {
			(*displays[d].linefunc)(sline, sp);
			if (new->flags & 1) --sline; else ++sline;
		}
		if ((k = getkey()) == -72) {		/* Up */
			yoff -= (ymax >> 2);
			if (yoff < 0) yoff = 0;
		} else if (k == -75) {				/* Left */
			xoff -= (xmax >> 2);
			if (xoff < 0) xoff = 0;
		} else if (k == -77) {				/* Right */
			xoff += (xmax >> 2);
			if (xoff > new->width-1)
			  xoff = new->width-1;
		} else if (k == -80) {				/* Down */
			yoff += (ymax >> 2);
			if (yoff > new->height-1)
			  yoff = new->height-1;
		} else break;
	}
abort:
	for (p=0; p<np; ++p) closeplane(ip[p]);

				if (ctype == 1 || ctype == 3) {
		outpw(0x3C4, 0xF02);
		outpw(0x3CE, 0xFF08);
		outpw(0x3C4, 0x03);
		outpw(0x3C4, 0x01);
	} else if (ctype == 2) {
		writedac(olddac);
	}
abort_nomode:
	release(mem);
   set_mode(mode, 0, 0);
	return r;
}

static U8 masks[] = { 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01 };
static U8 bayer[8][8] = {
	{  2,130, 34,162, 10,138, 42,170},
	{194, 66,226, 98,202, 74,234,106},
	{ 50,178, 18,146, 58,186, 26,154},
	{242,114,210, 82,250,122,218, 90},
	{ 14,142, 46,174,  6,134, 38,166},
	{206, 78,238,110,198, 70,230,102},
	{ 62,190, 30,158, 54,182, 22,150},
	{254,126,222, 94,246,118,214, 86} };


