/* PLMAIN.C : Main module of PICLAB program, in ANSI C.  Details of system
** can be found in PICLAB.DOC.	In this module are a few globally defined
** utility routines and main().  The only command handler is RUN.
*/

#include <stdlib.h>
#include <conio.h>
#include <stdarg.h>
#include <ctype.h>
#include <string.h>
#include <io.h>
#include <math.h>

#define MAIN_MODULE

#include "piclab.h"
#include "yiq"			/* These last four are not needed in this module,	*/
#include "sierra"		/* but are included with MAIN_MODULE defined so 	*/
#include "pjtbls"		/* they will be initialized.						*/
#include "hash"

char *signon[] = {
 	"PICLAB Version " VERSION ", April 12, 1995",
 	"Lee Daniel Crocker and the Stone Soup Group.",
 	"Type HELP for more information.",
  	NULL };

static char *warnings[] = {
	"Command arguments ignored",
	"Open files were closed",
	"Probable information loss" };

#define N_WARNINGS (sizeof(warnings)/sizeof(char *))

static char *errors[] = {
	"Assertion failure; contact author",
	"Insufficient memory",
	"Miscellaneous file I/O",
	"Unexpected end of file",
	"LZW compression/decompression",
	"Unrecognized file format or bad file",
	"Image buffer empty",
	"Point transform pending; issue TRANSFORM command",
	"Illegal parameter values",
	"File not found",
	"Invalid Display Mode"	/* BDT - when we can't get into a display mode */
	 };

#define N_ERRORS (sizeof(errors)/sizeof(char *))

void pl_warn(int msg)
{
	if (msg < 1 || msg > N_WARNINGS) pl_printf("** W %d **\r\n", msg);
	else pl_printf("Warning: %s.\r\n", warnings[msg-1]);
}

void pl_trace(register int line)
{
	if ((line & 7) == 7) pl_printf("\rLine%5d", line+1);
}

extern int chipset, vgamem;
int vgamem = 1024;

#ifdef DEBUG
static char *boards[] = {
	"no graphic", "CGA or 64k EGA", "EGA", "VGA", "SVGA"
};
static char *chips[] = {
 	/* added VESA - BDT */
  	"Cirrus", "Video 7", "Tseng", "Paradise", "C&T", "Trident",
 	"ATI", "Everex", "Ahead A", "Ahead B", "VESA"
};
#endif

void pl_init()
{
    char *cp;
	int i, v;

	initfile();
	v = vtype();

	if (!*tempdir) {
		if ((cp = getenv("TMP")) != NULL) strcpy(tempdir, cp);
	}
		/* added new display options - BDT */
	strupr(tempdir);

	if (!*display) {
		if (v == 3 && vgamem >= 512) strcpy(display, "SVGA2");
		else if (v == 3) strcpy(display, "SVGA1");
		else if (v == 2) strcpy(display, "VGA1");
		else if (v == 1) strcpy(display, "EGA");
		else if (v == 0) strcpy(display, "CGA");
	}

#ifdef DEBUG
  	pl_printf("Detected %s adapter\r\n", boards[v+1]);
  		pl_printf("%s chipset\r\n\r\n", chips[chipset-1]);
#endif

	for (i=0; i<256; ++i) {
		gcmap[0][i] = gcmap[1][i] = gcmap[2][i] =
		lookup[0][i] = lookup[1][i] = lookup[2][i] = (U8)i;
	}
	old = &images[0];	old->bufname = "OLD";	old->filename = "PLTEMP1";
	new = &images[1];	new->bufname = "NEW";	new->filename = "PLTEMP2";
	itmp = &images[2];	itmp->bufname = "TEMP"; itmp->filename = "PLTEMP3";

	old->planes = new->planes = itmp->planes =
	old->flags = new->flags = itmp->flags = 0;
	old->width = new->width = itmp->width =
	old->height = new->height = itmp->height = 0;
}

void pl_cleanup()
{
	static char *exts[] = { "R8", "G8", "B8" };
	char *path, *fname = "PLTEMP1";
	int i, j;

	if (!leavetemps) {
		for (i=0; i<3; ++i) for (j=0; j<3; ++j) {
			fname[6] = (char)(i + '1');
			path = makepath(tempdir, fname, exts[j]);
			remove(path);
		}
	}
}

/* The parse() function will be the main interpreter loop of PICLAB.  It
** will accept input a line at a time, parse it into a sequence of words,
** and call the function named by the first word (in cmdtable[]) with
** the second and subsequent words as arguments.
*/

int pl_match(char *key, char *words[])
{
    int i, l;

    l = strlen(key);
    for (i=0; words[i] != NULL; ++i) {
        if (strncmp(key, words[i], l) == 0) return i+1;
    }
    return 0;
}

int pl_parse(char *inline)
{
	int argc;
	argument argv[10];
    char *cp, *word, expand[256], *ep;
	int i, l, e, a;

    argc = 0;
    cp = strupr(inline);
	ep = expand;

    while (*cp) {
        while (*cp && *cp <= ' ') ++cp;
        word = cp;
        if (!*cp) break;

        while (*cp > ' ') ++cp;
        *cp++ = '\0';

		if (*word == ';') break;		/* Comment */

		if (*word == '%') {
			if (word[1] == '\0') break;
			else if (isdigit(word[1])) {
				a = atoi(word+1);
				if (a >= p_argc) {
					strcpy(word = ep, space);
					if ((ep += 2) > expand+sizeof(expand)) ep = expand;
				} else {
					l = strlen(p_argv[a]) + 1;
					if (ep+l > expand+sizeof(expand)) ep = expand;
					strcpy(word = ep, p_argv[a]);
					ep += l;
				}
			} else {
				if ((cp = getenv(word+1)) == NULL) {
					strcpy(word = ep, space);
					if ((ep += 2) > expand+sizeof(expand)) ep = expand;
				} else {
					l = strlen(cp) + 1;
					if (ep+l > expand+sizeof(expand)) ep = expand;
					strcpy(word = ep, cp);
					ep += l;
				}
			}
		}

        argv[argc].cval = word;
        argv[argc].fval = (float)atof(word);
        ++argc;
    }
	if (argc == 0) return 0;
    word = argv[0].cval;
    l = strlen(word);
    for (i=0; cmdtable[i].command != NULL; ++i) {
        if (strncmp(word, cmdtable[i].command, l) == 0) {
			e = (*cmdtable[i].function)(argc, argv);
			releaseall();
			if (e != 0) {
				if (e < 1 || e > N_ERRORS) pl_printf("** E %d **\r\n", e);
				else pl_printf("Error: %s.\r\n", errors[e-1]);
				if (p_closeall()) pl_warn(2);
			}
			return e;
        }
    }
	pl_printf("Unrecognized command.\r\n");
}

static int dorun(void)
{
	U32 mem, mem2;
	char inline[80], *buf;
	int r, pfile;

	mem = mark();
	if ((buf = talloc(BUFSIZE+80)) == NULL) return 2;
	if ((pfile = p_open(*p_argv, buf, BUFSIZE, 80, READ)) < 0) return 3;

	mem2 = mark();
	do {
		release(mem2);
		if (p_gets(inline, 80, pfile) == NULL) break;
		r = pl_parse(inline);
	} while (r == 0);
	release(mem);
	p_close(pfile);
	return r;
}

int run(int ac, argument *av)
{
	int i, r, intflag;

	intflag = interactive;
	if (ac < 2) return 9;

	p_argc = ac-1;
	for (i = 0; i < ac; ++i) p_argv[i] = av[i+1].cval;

	r = dorun();
	interactive = intflag;
	return r;
}

void main(int argc, char *argv[])
{
	int i, *ip, junk, c, r; 	/* Do not declare register variables here	*/
	char inline[128];			/* because setjmp() is being used.			*/

    pl_init();

    ip = &junk;
    while (--argc) {
        if (**++argv == '-') {
            while (c = *++*argv) {
                if (isdigit(c)) {
                    *ip *= 10;
                    *ip += (c - '0');
                } else switch (toupper(c)) {
                    case 'R':   interactive = 0;    *ip = 0;    break;
					case 'L':	leavetemps = 1; 	*ip = 0;	break;
					case 'S':	silent = 1;			*ip = 0;	break;
                }
            }
        } else {
			p_argv[p_argc++] = *argv;
        }
    }
	if (p_argc) {
		if (dorun() != 0) pl_printf("Program \"%s\" returned error.\r\n", *argv);
		quitflag = 1;
	}

	if (!quitflag) {
		if (!silent) for (i=0; signon[i]; ++i) pl_printf("%s\r\n", signon[i]);

		if (setjmp(interp) != 0) {
			releaseall();
			if (p_closeall()) pl_printf("\r\nTemp files were closed;");
			pl_printf("\r\nError recovery complete.\r\n");
		}
		do {
			if (interactive) pl_printf("\r\nPL>");
			inline[0] = 125;
			cgets(inline);
			pl_printf(crlf);
			inline[inline[1]+2] = '\n';
			inline[inline[1]+3] = '\0';
			r = pl_parse(inline+2);
		} while (!quitflag);
	}
    pl_cleanup();
}
  
