/* PICLAB.H : Constants, types, and globals for PICLAB are defined.  This
** file is included by all modules, so initializers are enclosed in "#ifdef
** MAIN_MODULE" blocks.
*/

#include <limits.h>
#include <setjmp.h>

#ifndef UTYPEDEFS
    #include "typedefs"
#endif

#define VERSION "1.93"

/* #define TEST    1 */

#define UTYPE   0       /* Used in vartable[]       */
#define FTYPE   1
#define STYPE   2
#define BTYPE   3
#define LTYPE   4
#define STRSIZE 32
#define BUFSIZE 8192
#define NFILES  6       /* Max number of open files */
#define NIMAGES 3       /* number of edit buffers   */
#define READ    1
#define WRITE   2

GLOBAL struct _ioblk {                  /* This structure and the following */
    int handle, width, mode;            /* prototypes are used in PLFILES.C */
    U16 bsize, bufp, bfull;
    U8 *iobuf, *linebuf;
    char fname[65];
} ioblocks[NFILES];

GLOBAL struct _imgbuf {
    char *bufname, *filename;
    U8  flags,      /* bit 0 = raster order, bit 1 = mapped */
        planes;
    U16 width, height;
} images[NIMAGES], *old, *new, *itmp;

GLOBAL struct _plane {
    U8 *linebuf;
    int handle;
    U16 width;
    int ioerr;
} planes[NFILES];

GLOBAL int p_argc INIT(0);
GLOBAL char *p_argv[10];

int vtype(void);
char *makepath(char *, char *, char *);
int p_closeall(void);
int p_open(char *, char *, int, int, int);
int p_reopen(int, int);
int p_seek(int, long);
void p_close(int);
int p_getc(int);
char *p_gets(char *, int, int);
int p_getline(int, int);
int p_putline(int, int);
struct _plane *openplane(int, struct _imgbuf *, int);
void closeplane(struct _plane *);
int getline(struct _plane *);
int putline(struct _plane *);
int seekline(struct _plane *, int);
int begintransform(void);

#define linebuf(h) ioblocks[h].linebuf

char *talloc(U16);              /* Memory allocation functions in MEMORY.C  */
U32 mark(void);
void release(U32);
void releaseall(void);
U32 freemem(void);

GLOBAL U8 *rv, *gv, *bv, *table2;   /* Interface to routines in PLDITHER.C  */
GLOBAL int startdither INIT(1);
void ditherline(U16, U8 *[3], U8 *);
void bitmapline(U16, U8 *, U8 *[2]);
void scaleline(U8 *, U8 *, int, int);

typedef struct _arg {           /* Structure passed to command-handlers     */
    char *cval;
    float fval;
} argument;

int addimg(int, argument *);        /* Command-handling routines.  These    */
int average(int, argument *);       /* should all take a count of arguments */
int brightness(int, argument *);    /* and a pointer to an array of them.   */
int clip(int, argument *);          /* To add a command to PICLAB, write a  */
int color(int, argument *);         /* function using these as a guide, put */
int contrast(int, argument *);      /* a prototype here, and add an entry   */
int equalize(int, argument *);      /* to cmdtable[], below.                */
int expand(int, argument *);
int filedir(int, argument *);
int gamma(int, argument *);
int gifdir(int, argument *);
int grayscale(int, argument *);
int graypal(int, argument *);
int help(int, argument *);
int histogram(int, argument *);
int list(int, argument *);
int load(int, argument *);
// int loadbmp(int, argument *);
int loadpal(int, argument *);
int loadgif(int, argument *);
int loadtga(int, argument *);
int loadrix(int, argument *);
int loadraw(int, argument *);
int loadppm(int, argument *);
int loadip(int, argument *);
int makepal(int, argument *);
int egapal(int, argument *);
int map(int, argument *);
int median(int, argument *);
int mirror(int, argument *);
int negate(int, argument *);
int overlay(int, argument *);
int pause(int, argument *);
int printpic(int, argument *);
int quit(int, argument *);
int rescale(int, argument *);
int reverse(int, argument *);
int rotate(int, argument *);
int run(int, argument *);
int save(int, argument *);
// int savebmp(int, argument *);
int savepal(int, argument *);
int savegif(int, argument *);
int savetga(int, argument *);
int saverix(int, argument *);
int saveraw(int, argument *);
int saveppm(int, argument *);
int saveip(int, argument *);
int setvar(int, argument *);
int sharpen(int, argument *);
int shell(int, argument *);
int showpic(int, argument *);
int smooth(int, argument *);
int subimg(int, argument *);
#ifdef TEST
  void testfunc(int, argument *);
#endif
int tgadir(int, argument *);
int transform(int, argument *);
int undo(int, argument *);
int unmap(int, argument *);

void cgaline(int, U8 *);
void egaline(int, U8 *);
void vga1line(int, U8 *);       /* Video adapter- and mode-dependent        */
void vga2line(int, U8 *);       /* routines from PLSHOW.C.                  */
void svgaline(int, U8 *);
void truecolorline(int, U8 *);
//void hc640line(int, U8 *);
//void hc800line(int, U8 *);
U8 _nearest(int *);

void pl_warn(int);                          /* General-purpose routines     */
int pl_printf(char *, ...);                 /* from PLMAIN.C                */
int pl_sprintf(char *, char *, ...);
void pl_init(void);
void pl_trace(register int);
void pl_cleanup(void);
int pl_match(char *, char *[]);
int pl_parse(char *);
int initfile(void);
void main(int argc, char *argv[]);

int pjprint(void);
int ljprint(void);

GLOBAL jmp_buf interp;

GLOBAL struct {                         /* This table is used by parse() to */
    char *command;                      /* dispatch commands to the correct */
    int (*function)(int, argument *);   /* function.  Each is responsible   */
    U16 fileoff;                        /* for interpreting the arguments   */
} cmdtable[]                            /* passed to it; see the individual */
                                        /* source files for more details.   */
#ifdef MAIN_MODULE                      
    = { { "ADD",        addimg,     0 },
        { "AVERAGE",    average,    0 },
        { "BRIGHTEN",   brightness, 0 },
        { "CALL",       shell,      0 },
        { "CANCEL",     undo,       0 },
        { "CLIP",       clip,       0 },
        { "COLOR",      color,      0 },
        { "CONTRAST",   contrast,   0 },
        { "DARKEN",     brightness, 0 },
        { "DIR",        filedir,    0 },
        { "DOS",        shell,      0 },
        { "EGAPAL",     egapal,     0 },
//      { "EQUALIZE",   equalize,   0 },
        { "EXIT",       quit,       0 },
        { "EXPAND",     expand,     0 },
        { "GAMMA",      gamma,      0 },
        { "GDIR",       gifdir,     0 },
        { "GLOAD",      loadgif,    0 },
        { "GRAY",       grayscale,  0 },
        { "GRAYPAL",    graypal,    0 },
        { "GSAVE",      savegif,    0 },
        { "HELP",       help,       0 },
        { "HISTOGRAM",  histogram,  0 },
//      { "JLOAD",      loadjfif,   0 },
//      { "JSAVE",      savejfif,   0 },
        { "LIST",       list,       0 },
        { "LOAD",       load,       0 },
        { "MAKEPAL",    makepal,    0 },
        { "MAP",        map,        0 },
        { "MEDIAN",     median,     0 },
        { "MIRROR",     mirror,     0 },
        { "NEGATE",     negate,     0 },
        { "OVERLAY",    overlay,    0 },
        { "PAUSE",      pause,      0 },
        { "PLOAD",      loadpal,    0 },
        { "PRINT",      printpic,   0 },
        { "PSAVE",      savepal,    0 },
        { "QUIT",       quit,       0 },
        { "RESCALE",    rescale,    0 },
        { "REVERSE",    reverse,    0 },
        { "RLOAD",      loadraw,    0 },
        { "ROTATE",     rotate,     0 },
        { "RSAVE",      saveraw,    0 },
        { "RUN",        run,        0 },
        { "SAVE",       save,       0 },
        { "SET",        setvar,     0 },
        { "SHARPEN",    sharpen,    0 },
        { "SHELL",      shell,      0 },
        { "SHOW",       showpic,    0 },
        { "SMOOTH",     smooth,     0 },
        { "SUBTRACT",   subimg,     0 },
        { "TDIR",       tgadir,     0 },
        { "TLOAD",      loadtga,    0 },
        { "TRANSFORM",  transform,  0 },
        { "TSAVE",      savetga,    0 },
        { "UNDO",       undo,       0 },
        { "UNMAP",      unmap,      0 },
        { NULL,         NULL,       0 } }
#endif
    ;

GLOBAL struct {
    char *name;
    int (*loadf)(int, argument *),
        (*savef)(int, argument *);
    U16 fileoff;
} formats[]

#ifdef MAIN_MODULE
    = { { "TARGA",      loadtga,    savetga,    0 },
        { "PPM",        loadppm,    saveppm,    0 },
//      { "JFIF",       loadjfif,   savejfif,   0 },
//      { "TIFF",       loadtiff,   savetiff,   0 },
//      { "BITMAP",     loadbmp,    savebmp,    0 },
//      { "PICTOR",     loadpic,    savepic,    0 },
//      { "PCX",        loadpcx,    savepcx,    0 },
        { "GIF",        loadgif,    savegif,    0 },
        { "RIX256",     loadrix,    saverix,    0 },
        { "RAW",        loadraw,    saveraw,    0 },
        { "IP",         loadip,     saveip,     0 },
        { NULL,         NULL,       NULL,       0 } }
#endif
    ;

GLOBAL struct {
    char *name;
    U16 width, height;
    U16 pax, pbx;
    void (*linefunc)(int, U8 *);
    U16 fileoff;
    char ctype;
    char *comment;
    char visible;
} displays[]

#ifdef MAIN_MODULE
= { 
{ "CGA",    320, 200, 0x06, 0, cgaline,       0,  0,  "Dithered CGA mono",           1 },
{ "EGA",    640, 350, 0x10, 0, egaline,       0,  1,  "8-color EGA dither",          1 },
{ "VGA1",   320, 200, 0x13, 0, vga1line,      0,  2,  "Standard VGA",                1 },
{ "VGA2",   640, 480, 0,    8, vga2line,      0,  2,  "Simulated on VGA",            1 },
{ "SVGA1",  640, 400, 0,    1, svgaline,      0,  2,  "For 256k SVGAs",              0 },
{ "SVGA2",  640, 480, 0,    2, svgaline,      0,  2,  "For 512k SVGAs",              0 },
{ "SVGA3",  800, 600, 0,    3, svgaline,      0,  2,  "For 512k SVGAs",              0 },
{ "HICLR1", 640, 480, 0,   21, truecolorline, 0,  3,  "For Hicolor-capable SVGAs",   0 },
{ "HICLR2", 800, 600, 0,   22, truecolorline, 0,  3,  "For Hicolor-capable SVGAs",   0 },
/* added the following SuperVGA modes - BDT */
{ "S400",   640, 400, 0,    1, svgaline,      0,  2,  "For 256k SVGAs            (synonym for SVGA1)", 1 },
{ "S640",   640, 480, 0,    2, svgaline,      0,  2,  "For 512k SVGAs            (synonym for SVGA2)", 1 },
{ "S800",   800, 600, 0,    3, svgaline,      0,  2,  "For 512k SVGAs            (synonym for SVGA3)", 1 },
{ "S1024", 1024, 768, 0,    4, svgaline,      0,  2,  "For 1MB  SVGAs",              1 },
{ "S1280", 1280,1024, 0,    5, svgaline,      0,  2,  "For 2MB  SVGAs",              1 },
{ "H640",   640, 480, 0,   21, truecolorline, 0,  3,  "For Hicolor-capable SVGAs (synonym for HICLR1)", 1 },
{ "H800",   800, 600, 0,   22, truecolorline, 0,  3,  "For Hicolor-capable SVGAs (synonym for HICLR2)", 1 },
{ "H1024", 1024, 768, 0,   23, truecolorline, 0,  3,  "For Hicolor-capable SVGAs",   1 },
{ "H1280", 1280,1024, 0,   24, truecolorline, 0,  3,  "For Hicolor-capable SVGAs",   1 },
{ "T640",   640, 480, 0,   31, truecolorline, 0,  3,  "For Truecolor-capable SVGAs", 1 },
{ "T800",   800, 600, 0,   32, truecolorline, 0,  3,  "For Truecolor-capable SVGAs", 1 },
{ "T1024", 1024, 768, 0,   33, truecolorline, 0,  3,  "For Truecolor-capable SVGAs", 1 },
{ "T1280", 1280,1024, 0,   34, truecolorline, 0,  3,  "For Truecolor-capable SVGAs", 1 },
{ NULL,     0,   0,   0,      0,    NULL,       0,  0,  NULL } 
}
#endif
    ;
GLOBAL U8 graymap[256][3]

#ifdef MAIN_MODULE
= { {  0,  0,  0 }, {  5,  3,  5 }, {  6,  5,  7 }, {  6,  7,  8 },
    {  8,  8,  7 }, {  8,  9, 10 }, { 11,  9,  9 }, {  9, 11, 11 },
    { 11, 11, 12 }, { 11, 12, 13 }, { 12, 13, 11 }, { 13, 13, 14 },
    { 15, 13, 13 }, { 13, 15, 13 }, { 16, 14, 15 }, { 16, 15, 15 },
    { 16, 16, 14 }, { 16, 16, 18 }, { 18, 16, 17 }, { 18, 17, 16 },
    { 19, 17, 17 }, { 18, 18, 19 }, { 18, 19, 17 }, { 19, 19, 18 },
    { 18, 20, 19 }, { 21, 19, 20 }, { 20, 20, 21 }, { 20, 21, 19 },
    { 21, 21, 20 }, { 21, 21, 23 }, { 23, 21, 21 }, { 22, 22, 22 },
    { 21, 23, 22 }, { 22, 23, 23 }, { 23, 23, 23 }, { 22, 24, 23 },
    { 23, 24, 24 }, { 24, 24, 24 }, { 23, 25, 24 }, { 26, 24, 24 },
    { 25, 25, 25 }, { 25, 25, 27 }, { 25, 26, 25 }, { 26, 26, 25 },
    { 27, 26, 25 }, { 26, 27, 25 }, { 27, 27, 25 }, { 27, 27, 28 },
    { 28, 27, 27 }, { 29, 27, 27 }, { 28, 28, 27 }, { 27, 29, 27 },
    { 28, 29, 27 }, { 30, 28, 29 }, { 29, 29, 29 }, { 29, 29, 31 },
    { 30, 29, 31 }, { 30, 30, 28 }, { 30, 30, 30 }, { 31, 30, 30 },
    { 31, 30, 32 }, { 30, 31, 32 }, { 31, 31, 32 }, { 32, 31, 31 },
    { 32, 31, 33 }, { 31, 32, 33 }, { 32, 32, 32 }, { 31, 33, 32 },
    { 33, 32, 34 }, { 33, 33, 31 }, { 33, 33, 33 }, { 33, 33, 35 },
    { 33, 34, 32 }, { 33, 34, 34 }, { 34, 34, 33 }, { 33, 35, 33 },
    { 33, 35, 35 }, { 36, 34, 34 }, { 36, 34, 36 }, { 35, 35, 36 },
    { 34, 36, 35 }, { 36, 35, 37 }, { 37, 35, 36 }, { 36, 36, 35 },
    { 35, 37, 35 }, { 35, 37, 37 }, { 36, 37, 36 }, { 37, 37, 35 },
    { 37, 37, 37 }, { 37, 37, 39 }, { 38, 37, 38 }, { 39, 37, 37 },
    { 39, 37, 39 }, { 38, 38, 38 }, { 38, 38, 40 }, { 38, 39, 37 },
    { 40, 38, 38 }, { 40, 38, 40 }, { 39, 39, 39 }, { 39, 39, 41 },
    { 39, 40, 38 }, { 41, 39, 39 }, { 41, 39, 41 }, { 40, 40, 40 },
    { 40, 40, 42 }, { 41, 40, 41 }, { 42, 40, 40 }, { 40, 41, 42 },
    { 41, 41, 41 }, { 42, 41, 40 }, { 40, 42, 42 }, { 41, 42, 41 },
    { 42, 42, 40 }, { 42, 42, 41 }, { 42, 42, 43 }, { 43, 42, 42 },
    { 42, 43, 41 }, { 42, 43, 43 }, { 44, 42, 44 }, { 43, 43, 43 },
    { 43, 43, 45 }, { 42, 44, 44 }, { 43, 44, 43 }, { 44, 44, 42 },
    { 44, 44, 43 }, { 44, 44, 45 }, { 43, 45, 44 }, { 44, 45, 43 },
    { 46, 44, 44 }, { 44, 45, 46 }, { 45, 45, 45 }, { 44, 46, 44 },
    { 46, 45, 45 }, { 45, 46, 44 }, { 45, 46, 46 }, { 47, 45, 47 },
    { 46, 46, 46 }, { 45, 47, 45 }, { 47, 46, 46 }, { 47, 46, 48 },
    { 46, 47, 47 }, { 48, 46, 48 }, { 47, 47, 47 }, { 46, 48, 46 },
    { 48, 47, 47 }, { 48, 47, 49 }, { 47, 48, 48 }, { 49, 47, 49 },
    { 48, 48, 48 }, { 47, 49, 47 }, { 49, 48, 48 }, { 48, 49, 47 },
    { 50, 48, 48 }, { 48, 49, 50 }, { 49, 49, 49 }, { 49, 49, 50 },
    { 48, 50, 49 }, { 50, 49, 50 }, { 49, 50, 49 }, { 51, 49, 50 },
    { 50, 50, 49 }, { 50, 50, 51 }, { 50, 50, 52 }, { 49, 51, 51 },
    { 51, 50, 52 }, { 50, 51, 51 }, { 52, 50, 52 }, { 51, 51, 51 },
    { 51, 51, 52 }, { 50, 52, 51 }, { 52, 51, 52 }, { 51, 52, 51 },
    { 53, 51, 52 }, { 52, 52, 51 }, { 52, 52, 52 }, { 53, 52, 51 },
    { 53, 52, 52 }, { 52, 53, 51 }, { 54, 52, 52 }, { 53, 53, 51 },
    { 53, 53, 52 }, { 53, 53, 54 }, { 53, 53, 55 }, { 52, 54, 54 },
    { 54, 53, 55 }, { 53, 54, 54 }, { 53, 54, 55 }, { 54, 54, 54 },
    { 54, 54, 55 }, { 54, 54, 56 }, { 53, 55, 55 }, { 55, 54, 56 },
    { 54, 55, 55 }, { 54, 55, 56 }, { 55, 55, 55 }, { 55, 55, 56 },
    { 55, 55, 57 }, { 54, 56, 56 }, { 56, 55, 57 }, { 55, 56, 56 },
    { 56, 56, 54 }, { 56, 56, 55 }, { 56, 56, 57 }, { 56, 56, 58 },
    { 57, 56, 56 }, { 56, 57, 55 }, { 58, 56, 56 }, { 57, 57, 55 },
    { 57, 57, 56 }, { 57, 57, 57 }, { 56, 58, 56 }, { 58, 57, 57 },
    { 58, 57, 58 }, { 57, 58, 57 }, { 59, 57, 58 }, { 59, 57, 59 },
    { 58, 58, 58 }, { 58, 58, 59 }, { 58, 58, 60 }, { 57, 59, 59 },
    { 59, 58, 60 }, { 60, 58, 58 }, { 59, 59, 57 }, { 59, 59, 58 },
    { 59, 59, 59 }, { 58, 60, 58 }, { 60, 59, 59 }, { 60, 59, 60 },
    { 59, 60, 59 }, { 59, 60, 60 }, { 61, 59, 61 }, { 60, 60, 60 },
    { 60, 60, 61 }, { 60, 60, 62 }, { 61, 60, 60 }, { 60, 61, 59 },
    { 62, 60, 60 }, { 62, 60, 61 }, { 61, 61, 60 }, { 61, 61, 61 },
    { 61, 61, 62 }, { 61, 61, 63 }, { 60, 62, 62 }, { 61, 62, 60 },
    { 63, 61, 61 }, { 62, 62, 60 }, { 62, 62, 61 }, { 62, 62, 62 },
    { 62, 62, 63 }, { 61, 63, 62 }, { 61, 63, 63 }, { 62, 63, 61 },
    { 62, 63, 62 }, { 63, 63, 61 }, { 63, 63, 62 }, { 63, 63, 63 } }
#endif
    ;

GLOBAL struct {
    char *name;
    int (*printfunc)(void);
    U16 fileoff;
} printers[]

#ifdef MAIN_MODULE
= { { "PAINTJET",   pjprint,    0 },
    { "LASERJET",   ljprint,    0 },
//  { "EPSON",      epsonprint, 0 },
    { NULL,         NULL,       0 } }
#endif
    ;

GLOBAL U8   lookup[3][256], gcmap[3][256]
#ifdef MAIN_MODULE
    = { 0, 0, 0, 0, 0, 255, 0, 255, 0, 0, 255, 255, 255,
        0, 0, 255, 0, 255, 255, 255, 0, 255, 255, 255 }
#endif
;

GLOBAL U32  hist[3][256],
            minalloc            INIT(100000L);
GLOBAL int  leavetemps          INIT(0),
            dither              INIT(1),
            bleed               INIT(70),
            laserdpi            INIT(300),
            histvalid           INIT(0),
            transpend           INIT(0),
            multiimage          INIT(0),
            multimap            INIT(0),
            vesadetect          INIT(1),
            silent              INIT(0),
            debug               INIT(0);
GLOBAL U16  quitflag            INIT(0),
            helploaded          INIT(0),
            printscale          INIT(1),
            interactive         INIT(1),
            xorigin             INIT(0),
            yorigin             INIT(0),
            crez                INIT(8),
            palette             INIT(256),
            mapbits             INIT(18);
GLOBAL char printer[STRSIZE]    INIT("LASERJET"),
            printfile[STRSIZE]  INIT(""),
            mapdir[STRSIZE]     INIT(""),
            picdir[STRSIZE]     INIT(""),
            helpfile[STRSIZE]   INIT("PL.HLP"),
            fileformat[STRSIZE] INIT("TARGA"),
            display[STRSIZE]    INIT(""),
            tempdir[STRSIZE]    INIT(""),
            version[]           INIT(VERSION);

GLOBAL struct _vars {       /* This table is used by the SET command.  See  */
    char *varname;          /* SETVAR.C for more details.                   */
    char *varaddr;
    char vartype;
    char visible;
    U16 fileoff;
} vartable[]

#ifdef MAIN_MODULE
    = { { "XORIGIN",    (char*)&xorigin,    UTYPE,  1,  0 },
        { "YORIGIN",    (char*)&yorigin,    UTYPE,  1,  0 },
        { "PALETTE",    (char*)&palette,    UTYPE,  1,  0 },
        { "DPI",        (char*)&laserdpi,   UTYPE,  1,  0 },
        { "MULTIIMAGE", (char*)&multiimage, BTYPE,  1,  0 },
        { "MULTIMAP",   (char*)&multimap,   BTYPE,  1,  0 },
        { "DITHER",     (char*)&dither,     BTYPE,  1,  0 },
        { "DISPLAY",    display,            STYPE,  1,  0 },
        { "PRINTER",    printer,            STYPE,  1,  0 },
        { "PRINTFILE",  printfile,          STYPE,  1,  0 },
        { "PRINTSCALE", (char*)&printscale, UTYPE,  1,  0 },
        { "TEMPDIR",    tempdir,            STYPE,  1,  0 },
        { "MAPDIR",     mapdir,             STYPE,  1,  0 },
        { "PICDIR",     picdir,             STYPE,  1,  0 },
        { "FILEFORMAT", fileformat,         STYPE,  1,  0 },
        { "MAPBITS",    (char*)&mapbits,    UTYPE,  1,  0 },

        { "DEBUG",      (char*)&debug,      UTYPE,  0,  0 },
        { "SILENT",     (char*)&silent,     BTYPE,  0,  0 },
        { "LEAVETEMPS", (char*)&leavetemps, BTYPE,  0,  0 },
        { "HELPFILE",   helpfile,           STYPE,  0,  0 },
        { "VESADETECT", (char*)&vesadetect, BTYPE,  0,  0 },

        { NULL,         NULL,               0,      0,  0 } }
#endif
    ;

GLOBAL char reading[]   INIT("Reading %s...\r\n"),
            writing[]   INIT("Writing %s...\r\n"),
            working[]   INIT("Working...\r\n"),
            maperr[]    INIT("This process cannot be performed on mapped images.\r\n"
                             "Use the UNMAP or GRAY commands and try again.\r\n"),
            done[]      INIT("\rDone.    \r\n"),
            crlf[]      INIT("\r\n"),
            space[]     INIT(" ");
