LISTING 11 - Implementation for Listing 10
// date4.cpp

#include <stdio.h>
#include "date3.h"

struct DateRep
{
    DateRep(int, int, int);

private:
    friend struct Date;

    int month;
    int day;
    int year;
};

const char * Date::month_text[13] =
    {"Bad month", "January", "February", "March", "April",
     "May", "June", "July", "August", "September",
     "October", "November", "December"};

DateRep::DateRep(int m, int d, int y) : month(m), day(d), year(y)
{}

Date::Date(int m, int d, int y)
{
    drep = new DateRep(m,d,y);
}

Date::~Date()
{
    delete drep;
}

char * Date::format(char *buf) const
{
    sprintf(buf,"%s %d, %d",
            month_text[drep->month],
            drep->day,drep->year);
    return buf;
}

int Date::compare(const Date & dp2) const
{
    int result = drep->year - dp2.drep->year;
    if (result == 0)
        result = drep->month - dp2.drep->month;
    if (result == 0)
        result = drep->day - dp2.drep->day;
    return result;
}
