LISTING 8 - Implementation for the Date class
// date3.cpp

#include <stdio.h>
#include "date3.h"

const char * Date::month_text[13] =
    {"Bad month", "January", "February", "March", "April",
     "May", "June", "July", "August", "September",
     "October", "November", "December"};

Date::Date(int m, int d, int y) : month(m), day(d), year(y)
{}

char * Date::format(char *buf) const
{
    sprintf(buf,"%s %d %d",month_text[month],day,year);
    return buf;
}

int Date::compare(const Date & dp2) const
{
    int result = year - dp2.year;
    if (result == 0)
        result = month - dp2.month;
    if (result == 0)
        result = day - dp2.day;
    return result;
}
