/*
 * Listing 5 - fileio.c (libips.a)
 */

#include <stdio.h>
#include "ips_image.h"

int img_to_ips();
int img_to_ips_fp();
int ips_to_img();
int ips_to_img_fp();


int
img_to_ips(header, image, filename)
ips_header	*header;
ips_image	*image;
char		*filename;
{
	int		retval;
	FILE	*fp;


	if((fp = fopen(filename, "w")) == NULL) {
		perror("img_to_ips");
		return 0;
	}

	retval = img_to_ips_fp(header, image, fp);

	fclose(fp);

	return retval;
}
	

int
img_to_ips_fp(header, image, fp)
ips_header	*header;
ips_image	*image;
FILE		*fp;
{
	fwrite(header, sizeof(ips_header), 1, fp);
	fwrite(image->cmap, 1, sizeof(XColor) * header->cmap_count, fp);
	fwrite(image->data, 1, header->width * header->height, fp);

	return 1;
}


int
ips_to_img(header, image, filename)
ips_header	*header;
ips_image	*image;
char		*filename;
{
	int		retval;
	FILE	*fp;


	if((fp = fopen(filename, "r")) == NULL) {
		perror("ips_to_img");
		return 0;
	}

	retval = ips_to_img_fp(header, image, fp);

	fclose(fp);

	return retval;
}


int
ips_to_img_fp(header, image, fp)
ips_header	*header;
ips_image	*image;
FILE		*fp;
{
	fread(header, sizeof(ips_header), 1, fp);

	if(header->bpp != 8) {
		fprintf(stderr, "ips_to_img_fp: data is not in 8 bit format.\n");
		return 0;
	}

	image->data = (unsigned char *)
 		malloc(header->width * header->height);

	if(image->data == NULL) {
		perror("ips_to_img_fp");
		return 0;
	}

	fread(image->cmap, 1, sizeof(XColor) * header->cmap_count, fp);
	fread(image->data, 1, header->width * header->height, fp);
	
	return 1;
}
