------------- Listing 9: The file tfstream.c ------------------

// test <fstream>
#include <cassert>
#include <cstdio>
#include <cstring>
#include <fstream>
#include <iostream>

int main()
        {       // test basic workings of fstream definitions
        ifstream ifs;
        ofstream ofs;
        const char *tn = tmpnam(NULL);
        assert(tn != NULL);
                // test closed file closing
        assert(!ifs.is_open() && !ifs.fail());
        ifs.close();
        assert(ifs.fail() && ifs.rdbuf()->close() == 0);
        assert(!ofs.is_open() && !ofs.fail());
        ofs.close();
        assert(ofs.fail() && ofs.rdbuf()->close() == 0);
                // test output file operations
        ofs.clear(), ofs.open(tn, ios::out | ios::trunc);
        assert(ofs.is_open() && ofs.rdbuf()->is_open());
        ofs << "this is a test" << endl;
        ofs.close();
        assert(!ofs.is_open() && ofs.good());
        assert(ofs.rdbuf()->open(tn, ios::app | ios::out) != 0);
        ofs << "this is only a test" << endl;
        ofs.close();
        assert(!ofs.is_open() && ofs.good());
                // test input file operations
        char buf[50];
        ifs.clear(), ifs.open(tn, ios::in);
        assert(ifs.is_open() && ifs.rdbuf()->is_open());
        ifs.getline(buf, sizeof (buf));
        assert(strcmp(buf, "this is a test") == 0);
        streampos p1 = ifs.rdbuf()->pubseekoff(0, ios::cur);
        ifs.getline(buf, sizeof (buf));
        assert(strcmp(buf, "this is only a test") == 0);
        assert(ifs.rdbuf()->pubseekpos(p1) == p1);
        ifs.getline(buf, sizeof (buf));
        assert(strcmp(buf, "this is only a test") == 0);
        ifs.rdbuf()->pubseekoff(0, ios::beg);
        ifs.getline(buf, sizeof (buf));
        assert(strcmp(buf, "this is a test") == 0);
        ifs.close();
        assert(!ifs.is_open() && ifs.good());
                // test combined file operations
        ifstream nifs(tn, ios::in | ios::out);
        ostream nofs(nifs.rdbuf());
        assert(nifs.is_open() && nifs.good() && nofs.good());
        nifs.rdbuf()->pubseekoff(0, ios::end);
        nofs << "this is still just a test" << endl;
        nifs.rdbuf()->pubseekoff(0, ios::beg);
        nifs.getline(buf, sizeof (buf));
        assert(strcmp(buf, "this is a test") == 0);
        nifs.getline(buf, sizeof (buf));
        assert(strcmp(buf, "this is only a test") == 0);
        nifs.getline(buf, sizeof (buf));
        assert(strcmp(buf, "this is still just a test") == 0);
        nifs.close();
        ofstream nnofs(tn,
                ios::in | ios::out | ios::ate);
        assert(nnofs.is_open());
        nnofs << "one last test" << endl;
        nnofs.close();
                // test stdiobuf operations
        FILE *fi = fopen(tn, "r+");
         {      // bound lifetime of istd and ostd
        istdiostream istd(fi);
        ostdiostream ostd(fi);
        assert(fi != 0);
        assert(istd.buffered() == 0
                && istd.rdbuf()->buffered() == 0);
        istd.rdbuf()->buffered(0), istd.buffered(1);
        assert(istd.buffered() != 0
                && istd.rdbuf()->buffered() != 0);
        assert(ostd.buffered() == 0
                && ostd.rdbuf()->buffered() == 0);
        ostd.rdbuf()->buffered(0), ostd.buffered(1);
        assert(ostd.buffered() != 0
                && ostd.rdbuf()->buffered() != 0);
        istd.getline(buf, sizeof (buf));
        assert(strcmp(buf, "this is a test") == 0);
        p1 = istd.rdbuf()->pubseekoff(0, ios::end);
        ostd << "still one more last test" << endl;
        assert(ostd.rdbuf()->pubseekpos(p1) == p1);
        istd.getline(buf, sizeof (buf));
        assert(strcmp(buf, "still one more last test") == 0);
         }
        assert(fclose(fi) == 0 && remove(tn) == 0);
        cout << "SUCCESS testing <fstream>" << endl;
        return (0);
        }
