/* complain.hpp / declaration for complaint printer */

#ifndef COMPLAIN_HPP                    /* in case of double inclusion */
#define COMPLAIN_HPP

/* this utility allows error messages to be stored in a file. when a keyed */
/* error message is to be printed, the file is re-opened and the text read. */
/* this then becomes the format string for a printf()-type call. note that */
/* the order of the format specifiers (%s, %d, etc.) inside cannot change! */
/* this does restrict rewording or translation into other languages... */

/* blank lines are ignored; lines beginning with '#' are comments. */
/* otherwise the line must be of the form <identifier> ':' <text>. */
/* the newline at the end of the line is included in the message; if */
/* there is a '\\' immediately in front of the newline, the newline */
/* is quoted and the next line is added to the message. in this way */
/* messages can have embedded newlines. */

/* there can be more than one error dictionary - each application can have */
/* its own. complaint_text() returns non-zero on error, should the file */
/* disappear during program execution or if the keyed message isn't found. */

/* key_defined() and complaint_text() return 1 on success and 0 otherwise. */

/* complaint dictionaries can't be copied (there's no reason to). */

class complain_ptr;                     /* internal key definition */

class complaint_dict {
    public:
        complaint_dict(const char *filename);  /* setup */
        ~complaint_dict(void);
        int key_defined(const char *name) const;
        int complaint_text(const char *name,
                           char *line,int linelen) const;
        const char *filename(void) const { return _filename; }
    private:
        char *_filename;
        complain_ptr *complain_table;
        complaint_dict(const complaint_dict &other);  /* unimplemented */
        complaint_dict &operator =(const complaint_dict &other);
};  /* end of class complaint_dict */

#endif  /* COMPLAIN_HPP */

