%{

#if 0
clexer.l - flex scanner for error message handler

A quick-and-dirty scanner based on one from Tony Sanders
(cs.utexas.edu!ibmaus!auschs!sanders.austin.ibm.com!sanders)

note that I took out keyword support; they are returned as
identifiers. this reduces the number of constants I have to
define!

#endif  /* 0 */

#include <stdio.h>
#include "clexer.h"
#define STRDUP(X) ((char *)strcpy(malloc(strlen(X)+1),X))
int yychar;
#define count(x) counter(x)
#ifndef YYDEBUG
int     yydebug = 0;
#else
int     yydebug = 1;
#endif

int column;
int linenum;
char lexstringtok[MAXSTRINGLEN];        /* for string, character constants */
int  lexstringtoklen;
#ifdef __STDC__
void quotechar(char c);
void addtostring(const char *txt,int txtlen);  /* adds to lexstringtok */
#else
void quotechar();
void addtostring();
#endif  /* __STDC__ */
%}

alpha   [a-zA-Z]
digit   [0-9]
special [\_]
ident   (({alpha}|{special})({alpha}|{digit}|{special})*)
int     ({digit}+)
exp     ([Ee][-+]?{digit}+)
float   ([-+]?{digit}+\.?{digit}*)|([-+]?{digit}*\.{digit}+)
%p 3000

/* start states: used for character and string constants */

%x charconst quotecharconst stringtok quotestringtok

%%
\#.*            { count(0); /* skip cpp lines */ }
[\ \n\t\v\f]+   { count(0); /* skip white space */ }
"/*"            { count(1); skipcomments(); }
\/\/.*          { count(1); /* skip C++ style comments */ }
"..."           { count(1); return DOTDOTDOT; }
">="            { count(1); return GE; }
"<="            { count(1); return LE; }
"!="            { count(1); return NOTEQU; }
"=="            { count(1); return EQU; }

"*="            { count(1); return MULTEQU; }
"/="            { count(1); return DIVEQU; }
"%="            { count(1); return MODEQU; }
"+="            { count(1); return INCEQU; }
"-="            { count(1); return DECEQU; }
"<<="           { count(1); return SHIFTLEFTEQU; }
">>="           { count(1); return SHIFTRIGHTEQU; }
"&="            { count(1); return ANDEQU; }
"|="            { count(1); return OREQU; }
"^="            { count(1); return XOREQU; }

"<<"            { count(1); return SHIFTLEFT; }
">>"            { count(1); return SHIFTRIGHT; }
"++"            { count(1); return INC; }
"--"            { count(1); return DEC; }
"->"            { count(1); return POINTS; }
"&&"            { count(1); return LOGICALAND; }
"||"            { count(1); return LOGICALOR; }

"("             { count(1); return '('; }
","             { count(1); return ','; }
")"             { count(1); return ')'; }
";"             { count(1); return ';'; }
"{"             { count(1); return '{'; }
"}"             { count(1); return '}'; }
"["             { count(1); return '['; }
"]"             { count(1); return ']'; }
"*"             { count(1); return '*'; }
"/"             { count(1); return '/'; }
"+"             { count(1); return '+'; }
"-"             { count(1); return '-'; }
"%"             { count(1); return '%'; }
"^"             { count(1); return '^'; }
"&"             { count(1); return '&'; }
"?"             { count(1); return '?'; }
":"             { count(1); return ':'; }
"!"             { count(1); return '!'; }
"."             { count(1); return '.'; }
"~"             { count(1); return '~'; }
"<"             { count(1); return '<'; }
">"             { count(1); return '>'; }
"."             { count(1); return '.'; }
"="             { count(1); return '='; }

' {
        BEGIN(charconst);
        addtostring("",0);
}
<charconst>' {
        BEGIN(INITIAL);
        count(1);
        return CHAR_CONST;
}
<charconst>\\ {
        BEGIN(quotecharconst);          /* backslash quotes next char */
}
<charconst>[^'\\\n] {

        /* we can't use ".*" in this rule because it would eat the closing */
        /* quote. */

        addtostring(yytext,yyleng);
}
<quotecharconst>. {
        quotechar(yytext[0]);           /* quoted character */
        BEGIN(charconst);
}
<charconst,quotecharconst>\n {
        BEGIN(INITIAL);
        fprintf(stderr,"newline in character constant.\n");
        yyterminate();                  /* on to next file */
}

{int} {
        count(1);
        return INTEGER_CONST;
}
{int}[lL] {
        count(1);
        return LONG_INTEGER_CONST;
}
{float}|{float}{exp} {
        count(1);
        return FLOAT_CONST;
}
{float}[lL]|{float}{exp}[lL] {
        count(1);
        return DOUBLE_CONST;
}

\" {
        BEGIN(stringtok);
        addtostring("",0);
}
<stringtok>\" {
        BEGIN(INITIAL);
        count(1);
        /* return STRING without quotes */
        return STRING;
}
<stringtok>\\ {
        BEGIN(quotestringtok);          /* backslash quotes next char */
}
<stringtok>[^"\\\n]* {

        /* we can't use ".*" in this rule because it would eat the closing */
        /* quote. */

        addtostring(yytext,yyleng);
}
<stringtok>\n {
        fprintf(stderr,"newline in string token.\n");
        yyterminate();
}
<quotestringtok>.|\n {
        quotechar(yytext[0]);           /* quoted character */
        BEGIN(stringtok);
}

{ident} {                               /* identifier - includes keywords */
        count(1);
        return IDENTIFIER;
}
.                       { count(1); return ERROR; }
%%

#undef yywrap

int yywrap() { return 1;}

/* Skip over comments. */
skipcomments()
{
    char c;

    while (1) {
        while ((c = input()) != '*')
            if (c == '\n') {
                column = 0;
                linenum++;
            }
            else if (c == '\t')
                column += 8 - (column % 8);
            else
                column++;
        if ((c = input()) == '/') {
            column++;
#ifdef LEXDEBUG
    printf ("symbol found: %s\n", "*/");
#endif
            return;
        }
        unput(c);
    }
}

/*ARGSUSED*/
counter(notwhite)
int notwhite;
{
    register char *s;

#ifdef LEXDEBUG
    if (notwhite)
        printf ("symbol found: %s\n", yytext);
#endif
    for (s = yytext; *s; s++)
        if (*s == '\n') {
            column = 0;
            linenum++;
        }
        else if (*s == '\t')
            column += 8 - (column % 8);
        else
            column++;
}

yyerror(s)
char   *s;
{
    fprintf (stderr, "YYERROR: %s: line %d col %d\n", s, linenum, column);
    fprintf (stderr, "YYERROR: yytext=`%s' symbol was (%d)\n", yytext, yychar);
}

#ifdef __STDC__
void quotechar(char c)
#else
void quotechar(c)
char c;
#endif  __STDC__
{
    /* add the quoted character (previous was a '\\') to the global flex */
    /* string token buffer. */

    char s[4];

    if (c == '\n')                      /* newline - put in directly */
        addtostring("\n",1);
    else {
        sprintf(s,"\\%c",c);            /* others - restore '\\' */
        addtostring(s,2);
    }

}  /* end of quotechar() */

#ifdef __STDC__
void addtostring(const char *txt,int txtlen)
#else
void addtostring(txt,txtlen)
char *txt;
int txtlen;
#endif  /* __STDC__ */
{
    /* add the string fragment to the global flex string token buffer. */
    /* clear the buffer if the text length is 0. */

    if (txtlen == 0) {                  /* reset string buffer */
        lexstringtoklen = 0;
    }
    else if (txtlen + lexstringtoklen >= MAXSTRINGLEN) {
        fprintf(stderr,
                "Maximum string token length exceeded - string discarded.\n");
        lexstringtoklen = 0;
    }
    else {                              /* remember the text */
        strncpy(lexstringtok + lexstringtoklen,txt,txtlen);
        lexstringtoklen += txtlen;
    }
    lexstringtok[lexstringtoklen] = '\0';  /* legal C string */

}  /* end of addtostring() */
