/***********************************************************************

                                       CSA Library, Version 1.6.b 
                                         Released: March 2nd 1995 

       Template functions, for use with the FIELD/PANEL
       classes.

                                           Copyright(c) 1994,1995 
                                                           Combis 
                                                  The Netherlands 
***********************************************************************/

#ifndef _CSTEMPL_H
#define _CSTEMPL_H

#include "cstypes.h"

  /*
     Symbols:

	n	0123456789-+   Blank allowed.
	N	0123456789-+   Blank NOT allowed.
	o	0123456789     Blank allowed.
	O	0123456789     Blank NOT allowed.
	p	 123456789-+   Blank allowed.
	P	 123456789-+   Blank NOT allowed.
	q	 123456789     Blank allowed.
	Q	 123456789     Blank NOT allowed.
	s	 -+	       Blank allowed.
	S	 -+	       Blank NOT allowed.
	A	 The characters from the alfabet. Blanks NOT allowed.
	a	 The characters from the alfabet including ,.;: .
	C	 A or 9
	c	 a or n



   128+ below:
       1	123456789
       2	0
       4	BLANK
       8	-+
      16	~`!@#$%^&*()_=|\}{[]":;'?><,./
      32	abcdefghijklmnopqrstuvwxyz
      64	CAPITALS




Use of the "OR":

   syntax:   [templ1|templ2|templ3]


 Special symbol: @






  */


////////////////////////////// 'Private' functions ////////////////////////
int   allow_or(int &RC,uchar c,uchar * &s,int delta);
int   in_templ(uchar c,int pos,uchar *tpt);
int   is_templ2(uchar c,uchar symbol);
void  tmpt_join_ors(uchar *templ,uchar *tmplt);
uchar tmpt_symbol(uchar * & poi);
int   tmplt_or(uchar *& s,uchar * &tpt);
int   tmpt_in_bit(uchar c);
int   temp_or(uchar *d,uchar * &s,int delta);


////////////////////////////// 'PUBLIC' functions /////////////////////////

void tmplt_c1(uchar *in,uchar *out);
int  tmplt(uchar *s,uchar *tpt);
int  tmplt_length(uchar *s);
int  allowed(uchar c,int pos,uchar *templ);



#endif
