/***********************************************************************

                                       CSA Library, Version 1.6.b 
                                         Released: March 2nd 1995 

       Definition of the MENU class.

                                           Copyright(c) 1994,1995 
                                                           Combis 
                                                  The Netherlands 
***********************************************************************/

#ifndef __CSMENU
#define __CSMENU


#define MENU_HOLD     1
#define MENU_RELEASE  2

#define MENU_HOR      1
#define MENU_VER      2
#define MENU_HOVER    3

#define TO_SCREEN   FALSE
#define TO_CURSOR   TRUE

#define MAX_OPTIONS 20

#include "string.h"
#include "cswindow.h"


////////////////////////// OPTON class /////////////////////////////////////////


class OPTION
{
 public:

  CSCHAR *opt;			       /* option string */
  void *poi;			       /* pointer to submenu  */
  int	rc;			       /* Return code */
  int enable;

public:

  OPTION(void)			       { enable=TRUE; }
  void init(CSCHAR *o,int r)	       { opt=o; rc=r; }
  void connect(void *p) 	       { poi=p; }

};


////////////////////////// MENU class /////////////////////////////////////////


class MENU:public WINDOW
{

  private:
    int status;

    int typ;		   //hori or verti
    int hold_var;
    int high_hor;
    int high_ver;
    int oc,kc;		  // Option Color, Key Color

    int num_option;
    int path;
    int auto_return;
    int opt_act;
    int dwars_allow;
    int menu_row;
    int menu_col;
    int abs_rel;	   // Absolute or relative position


    OPTION *option[MAX_OPTIONS];

protected:
    int add_first_opt_len(int k);
    void print_option(int k,int opt_col,int til_col);
    MENU *sub_menu(int k);
    OPTION *point_2_opt(int k);
    void make_window(void);
    int opt_len(int k);
    int add_opt_len(void);
    int is_dwars(int cursor);
    int tilde_pos(CSCHAR *s);
    int tilde_char(CSCHAR *s, CSCHAR &ch);
    int choose2(int &);
    void tilde_remove(CSCHAR *s);
    void entry(void);
    void yrtne(void);


////////////////////////////////////////////////////////////////////////
////////////////////// PUBLIC FUNCTIONS ////////////////////////////////
////////////////////////////////////////////////////////////////////////


  public:


////////////////////////////Defining options ///////////////////////////
    int add_option(CSCHAR *s,int key);
    void enable_option(int num,int tf) { point_2_opt(num)->enable=tf; }
    void enable_option(int tf)	       { enable_option(num_option,tf); }


////////////////////////////Defining menus /////////////////////////////
    int  type(int hor_or_ver) { typ=hor_or_ver; return TRUE;}
    int  type(void) {return typ; }
    void auto_ret(int yn)	       { auto_return=yn; }
    void hold(int tf)		       { hold_var=tf; }
    void dwars(int tf)		       { dwars_allow=tf; }

////////////////////////////Connecting menus ///////////////////////////
    int connect(int option, MENU &m2);


/////////////////////////////Colors ////////////////////////////////////
    void option_color(int color)       { oc=color; }
    void key_color(int color)	       { kc=color; }
    void color(int cb,int cs,int co,int ck)
				       { border_color(cb);
					 screen_color(cs);
					 option_color(co);
					 key_color(ck); }

/////////////////////////////Displaying ////////////////////////////////
    int show_this(void);
    int show_standby(void);
    int show(void);
    int show_nr(void);		 // Doesn't return to the original WINDOW.
    int show2(void);
    int show(int opt);
    int show_nr(int opt);	 // Doesn't return to the original WINDOW.

    void standby2(void);
    void standby(void);

/////////////////////////////Picking an option //////////////////////////
    int choose(int &keus);	  // Returns ENTER ,ESC etc.
    int choose_hold(int &keus);   // Returns ENTER ,ESC etc.




/////////////////////////////Postions and dimenstions //////////////////
    void top(int w)		       { menu_row=w; }
    void left(int w)		       { menu_col=w; }
    void coord(int row,int col)        { top(row); left(col); }
    void set_dim(int row,int col,int h,int w)
				       { coord(row,col); height(h); width(w); }
    void relative_pos(int tf)	       { abs_rel=!tf; }


////////////////////////// Miscellaneous ///////////////////////////////////////
    int  find_path(int key);

////////////////////////// Removing the menu from the screen ///////////////////
    void remove(void);

/////////////////////////////Con&Des-structors /////////////////////////
    MENU(void);
    ~MENU(void);


};


#endif
