/*
** $PROJECT: c.datatype
**
** $VER: classbase.c 39.1 (06.03.95)
**
** by
**
** Stefan Ruppert , Windthorststrae 5 , 65439 Flrsheim , GERMANY
**
** (C) Copyright 1995
** All Rights Reserved !
**
** $HISTORY:
**
** 06.03.95 : 039.001 : initial
*/

#include "classbase.h"

LibCall Class *ENGINE (REGA6 struct ClassBase *cb)
{
   return(cb->cb_Class);
}

LibCall struct Library *LibInit (REGD0 struct ClassBase *cb, REGA0 BPTR seglist, REGA6 struct Library * sysbase)
{
   cb->cb_SegList = seglist;
   cb->cb_SysBase = sysbase;
   InitSemaphore (&cb->cb_Lock);

   DB(("c.datatype init !\n"));

   if(cb->cb_SysBase->lib_Version >= 39)
   {
      cb->cb_IntuitionBase = OpenLibrary ("intuition.library",39);
      cb->cb_GfxBase       = OpenLibrary ("graphics.library", 39);
      cb->cb_DOSBase       = OpenLibrary ("dos.library",      39);
      cb->cb_UtilityBase   = OpenLibrary ("utility.library",  39);
   } else
      cb = NULL;

  return((struct Library *) cb);
}

LibCall LONG LibOpen (REGA6 struct ClassBase *cb)
{
   LONG retval = (LONG) cb;

   ObtainSemaphore (&cb->cb_Lock);

   /* Use an internal use counter */
   cb->cb_Lib.lib_OpenCnt++;
   cb->cb_Lib.lib_Flags &= ~LIBF_DELEXP;

   if(cb->cb_Lib.lib_OpenCnt == 1 && cb->cb_Class == NULL)
   {
      retval = (LONG) NULL;

      if((cb->cb_IFFParseBase = OpenLibrary ("iffparse.library", 39)))
         if((cb->cb_DataTypesBase = OpenLibrary ("datatypes.library", 39)))
            if((cb->cb_SuperClassBase = OpenLibrary(SUPERCLASSDATATYPE,39)))
               if((cb->cb_Class = initClass(cb)))
                  retval = (LONG) cb;

      if(!retval)
      {
         if(cb->cb_IFFParseBase)
         {
            CloseLibrary(cb->cb_IFFParseBase);
            cb->cb_IFFParseBase = NULL;
         }

         if(cb->cb_DataTypesBase)
         {
            CloseLibrary(cb->cb_DataTypesBase);
            cb->cb_DataTypesBase = NULL;
         }

         if(cb->cb_SuperClassBase)
         {
            CloseLibrary(cb->cb_SuperClassBase);
            cb->cb_SuperClassBase = NULL;
         }

         cb->cb_Lib.lib_OpenCnt--;
      }
   }

   ReleaseSemaphore (&cb->cb_Lock);

   return (retval);
}

LibCall LONG LibClose (REGA6 struct ClassBase *cb)
{
   LONG retval = NULL;

   ObtainSemaphore (&cb->cb_Lock);

   if (cb->cb_Lib.lib_OpenCnt)
      cb->cb_Lib.lib_OpenCnt--;

   if((cb->cb_Lib.lib_OpenCnt == 0) && cb->cb_Class)
   {
      if(FreeClass (cb->cb_Class))
      {
         cb->cb_Class = NULL;
         CloseLibrary(cb->cb_SuperClassBase);
         CloseLibrary(cb->cb_DataTypesBase);
         CloseLibrary(cb->cb_IFFParseBase);
      } else
         cb->cb_Lib.lib_Flags |= LIBF_DELEXP;
   }

   if(cb->cb_Lib.lib_Flags & LIBF_DELEXP)
       retval = LibExpunge (cb);

   ReleaseSemaphore (&cb->cb_Lock);

   return (retval);
}

LibCall LONG LibExpunge(REGA6 struct ClassBase *cb)
{
   BPTR seg = cb->cb_SegList;

   Remove((struct Node *) cb);

   CloseLibrary(cb->cb_UtilityBase);
   CloseLibrary(cb->cb_DOSBase);
   CloseLibrary(cb->cb_GfxBase);
   CloseLibrary(cb->cb_IntuitionBase);

   FreeMem((APTR)((ULONG)(cb) - (ULONG)(cb->cb_Lib.lib_NegSize)), cb->cb_Lib.lib_NegSize + cb->cb_Lib.lib_PosSize);

   return((LONG) seg);
}

