;**************************** TIMER.ASM *********************************
PAGE  70,132
comment 
                             TIMER
                             -----

     Purpose:
     --------

     TIMER is a sample program to show how the timer funcitons can
     be used.  The unmodified program will time the execution of
     programs, but it can be modified to time code segments.

     Using TIMER
     ----------

     To time a program, type "TIMER <program name>"<Enter>
     TIMER will execute the program and display the elapsed
     time when the program exits.

     Compiling
     ---------

     The commands needed to build TIMER.EXE using MASM are:
		masm TIMER;
		link TIMER,TIMER,,alib.lib;


;----------------------------------------------------------------------------
.xlist
	include  mac.inc
	include  common.inc
	extrn	library_setup:far
	extrn	library_terminate:far	
	extrn	spawn_dos:far	
	extrn	calibrate_timer:far
	extrn	start_timer:far
	extrn	read_timer:far
	extrn	convert_timer:far
	extrn	display_timer:far
.list
	
;------------------------------------------------------------------------------
code		segment para public 'CODE'
		assume	cs:code, ds:code
;-----------------------------------------------------------------------------
; 

stacksize	equ	1024
	db	stacksize dup (0)
stack_	label	word
;
pspseg		dw	0		;program segment prefix
;-----------------------------------------------------------------------------
start:	cli
	mov	cs:pspseg,es	;save PSP segment
	mov	ax,cs		;get CODE segment
	mov	ss,ax
	mov	ds,ax
	mov	es,ax
	mov	sp,offset stack_
	sti
	
; next, release memory beyond the end of the program
; The  definition for ZSEG marks the
; end of the program's code, data and stack area.
; When linking be sure ZSEG is at the end of the program.

	mov	ax,zseg

	mov	bx,cs:pspseg		;
	mov	es,bx
	sub	bx,ax
	neg	bx			; size of program in paragraphs
	mov	ah,4Ah			; resize memory block
	int	21h

	mov	ax,cs
	mov	es,ax
;
; check if enough memory free to run program
;
	mov	ax,pspseg		;pass psp segment to setup
	mov	bx,0			;number of floating point variables
	call	library_setup
;
; We want to call SPAWN_DOS which is not compatable with the memory
; manager, so we will remove it from memory.  We needed to call
; library setup origionally, to setup the library data area.
;
	mov	ax,1
	call	library_terminate

	call	calibrate_timer
	call	start_timer
;
; note: for code timing it will be necessary to comment out the "jcxz"
;       instruction above, then place code below.
;
; **** place code to be timed here ****	

	mov	ax,cs:pspseg
	mov	ds,ax
	mov	es,ax
	mov	si,81h
	call	spawn_dos		;execute program to be timed

; **** end of code to be timed ****

	call	read_timer
	call	convert_timer
	call	display_timer		

exit2:	mov	ax,4C00h
	int	21h
;---------------------------
			
code		ends
	
;-------------------------------------------------------------------------
;
; This segment definition is needed so linker will put the LIBSEG here
; before the ZSEG.  We want ZSEG to be last so memory allocation will
; work correctly.
;
LIBSEG           segment byte public 'LIB'
LIBSEG	ENDS
;-------------------------------------------------------------------------
; zseg must be at the end of the program for memory allocation from
; DOS.
;
zseg	segment	para public 'ZZ'
zseg	ends
		end	start
