______________________________________________________________________________

HEX16IN

  Function: This routine accepts a hexadecimal number from the standard input
    device and converts it to internal 16-bit binary form.

  Input: The individual digits of the hexadecimal number are received in ASCII
    through a call to a standard I/O routine. The valid digits are 0 through 9
    and A through F. An ASCII code other than for a valid digit will terminate
    the routine.

  Output: A 16-bit binary number is returned in the DX register.

  Registers usnd: Only DX is modified. It returns the result.

  Routines called: STDIN
;-----------------------------------------------------------------------------
;Routine to convert from ASCII hexadecimal to internal 16-bit binary
;
HEX16IN   PROC	 FAR
	  PUSH	 CX		       ;Save registers
	  PUSH	 AX
	  MOV	 DX,0		       ;Initialize DX as 0
HEX16IN1:
	  CALL	 STDIN		       ;A digit comes in AL
	  SUB	 AL,30H 	       ;Subtract 30H
	  JL	 HEX16IN3	       ;Check if too low
	  CMP	 AL,9
	  JLE	 HEX16IN2	       ;Go if OK
	  AND	 AL,5Fh 	       ;For lower case too
	  SUB	 AL,7		       ;Adjust for A-F
	  JL	 HEX16IN3	       ;Too low for A-F
	  CMP	 AL,15		       ;Check if too high
	  JG	 HEX16IN3
HEX16IN2:
	  CBW
	  MOV	 CL,4		       ;For count of 4
	  SAL	 DX,CL		       ;Shift DX left
	  ADD	 DX,AX		       ;Add in digit
	  JMP	 HEX16IN1
HEX16IN3:
	  POP	 AX		       ;Restore registers
	  POP	 CX
	  RET			       ;Return
HEX16IN   ENDP
;************************  HEX2BIN  ****************************
;-----------------------------------------------------------------------;
; INPUT  : SI points to parameter start; CX = parameter length; BX = 0. ;
; OUTPUT : BX = number; CY = 0 if valid entry; CY = 1 if invalid entry. ;
;-----------------------------------------------------------------------;
HEX_INPUT      PROC    NEAR
NEXT_HEX:      LODSB                           ;Get a byte.
               SUB     AL,"0"                  ;ASCII to binary.
               JC      LOOP_HEX                ;If not 0 to 9, skip.
               CMP     AL,9                    ;Is it A - F ?
               JLE     NOT_ALPHA               ;If no, OK.
               SUB     AL,7                    ;Else, adjust for alpha.
               CMP     AL,10                   ;Is it punctuation?
               JB      LOOP_HEX                ;If yes, skip.
               CMP     AL,15                   ;Is it valid?
               JA      LOOP_HEX                ;If no, skip.
NOT_ALPHA:     TEST    BX,1111b SHL 12         ;Is the number going to overflow?
               STC                             ;Assume yes.
               JNZ     END_HEX                 ;If yes, too big.
               PUSH    CX                      ;Else, preserve counter.
               MOV     CL,4                    ;Shift old number four bits left.
               SHL     BX,CL
               POP     CX                      ;Retrieve counter.
               OR      BL,AL                   ;Add to number.
LOOP_HEX:      LOOP    NEXT_HEX
               CLC
END_HEX:       RET
HEX_INPUT      ENDP

comment 
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -( CONVERT )
;DEC_STR1_TO_WORD -  convert unsigned ascii string to binary word
;
; inputs  ds:si points	at string ending with zero
; 
; output  bx = binary value
;	   si = updated to point at end of value
;	   al = 0 if success
;* * * * * * * * * * * * * *

	public	DEC_STR1_TO_WORD
DEC_STR1_TO_WORD	proc	far
	push	dx
	cld
	mov	bx,0       		;set running sum = 0
;
; remove blanks in front of number
;
ab1:	lodsb
	cmp	al,' '
	je	ab1			;remove leading spaces

ab2:	or	al,al
	jz	ab_done			;jmp if done, end of string
	sub	al,'0'
	js	ab_done			;jmp if error, not number
	cmp	al,9
	ja	ab_done			;jmp if error, not number

	sub	ah,ah
	push	ax			;save current char

	mov	ax,bx			;get running sum
	mul	cs:ten
	pop	dx			;get current char
	add	ax,dx
	mov	bx,ax			;save running sum
	lodsb
	jmp	ab2			;loop till done
	
ab_done:
	pop	dx
	RETF
DEC_STR1_TO_WORD ENDP

comment 
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -( CONVERT )
;DEC_STR2_TO_WORD -  convert unsigned ascii string to binary word
;
; inputs  ds:si = string ptr
;            cx = string length
; 
; output  bx = binary value
;	   si = updated to point at end of value
;	   al = zero if success
;* * * * * * * * * * * * * *

	public	DEC_STR2_TO_WORD
DEC_STR2_TO_WORD	proc	far
	push	dx
	cld
	mov	bx,0       		;set running sum = 0
;
; remove blanks in front of number
;
ab3:	lodsb
	jcxz	ab2_done
	dec	cx
	cmp	al,' '
	je	ab3			;remove leading spaces

ab4:	sub	al,'0'
	js	ab2_err			;jmp if error, not number
	cmp	al,9
	ja	ab2_err 		;jmp if error, not number

	sub	ah,ah
	push	ax			;save current char

	mov	ax,bx			;get running sum
	mul	cs:ten
	pop	dx			;get current char
	add	ax,dx
	mov	bx,ax			;save running sum
	jcxz	ab2_done
	lodsb
	dec	cx
	jmp	ab4			;loop till done
	
ab2_done:
	xor	al,al
ab2_err:	
	pop	dx
	RETF
DEC_STR2_TO_WORD	endp
	

comment 
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -( CONVERT )
;DEC_STR3_TO_WORD -  convert signed asciiz string to binary word
;
; inputs  ds:si points	at string ending with zero
; 
; output  bx = binary value
;	   si = updated to point at end of value
;	   al = zero if success
;* * * * * * * * * * * * * *



	public	DEC_STR3_TO_WORD
DEC_STR3_TO_WORD	proc	far
	push	dx
	cld
	mov	bx,0
	mov	cs:str_sign,0
ab5:	lodsb
	cmp	al,' '
	je	ab5			;remove leading spaces
	cmp	al,'+'
	je	ab6			;jmp if sign found
	cmp	al,'-'
	jne	ab7
	mov	cs:str_sign,1		;set sign negative
ab6:	lodsb				;get next char

ab7:	or	al,al
	jz	ab3_done
	sub	al,'0'
	js	ab3_done		;jmp if error, not number
	cmp	al,9
	ja	ab3_done		;jmp if error, not number

	sub	ah,ah
	push	ax			;save current char

	mov	ax,bx			;get running sum
	mul	cs:ten
	pop	dx			;get current char
	add	ax,dx
	mov	bx,ax			;save running sum
	lodsb
	jmp	ab7			;loop till done

ab3_done:
	cmp	str_sign,0		;is result +
	je	ab3_done2		;jmp if + number
	neg	bx
ab3_done2:	
	pop	dx
	retf		
		
DEC_STR3_TO_WORD	endp
	

comment 
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -( CONVERT )
;DEC_STR4_TO_WORD -  convert signed ascii string to binary word
;
; inputs  ds:si = string pointer
;            cx = length of string
; 
; output  bx = binary value
;	   si = updated to point at end of value
;	   al = zero if success
;* * * * * * * * * * * * * *

	public	DEC_STR4_TO_WORD
DEC_STR4_TO_WORD	proc	far
	push	dx
	cld
	mov	bx,0
	mov	cs:str_sign,0
ab8:	jcxz	ab4_done
	lodsb
	dec	cx
	cmp	al,' '
	je	ab8			;remove leading spaces
	cmp	al,'+'
	je	ab9			;jmp if sign found
	cmp	al,'-'
	jne	ab10
	mov	cs:str_sign,1		;set sign negative
ab9:	jcxz	ab4_done
	lodsb				;get next char
	dec	cx

ab10:	sub	al,'0'
	js	ab4_err 		;jmp if error, not number
	cmp	al,9
	ja	ab4_err 		;jmp if error, not number

	sub	ah,ah
	push	ax			;save current char

	mov	ax,bx			;get running sum
	mul	cs:ten
	pop	dx			;get current char
	add	ax,dx
	mov	bx,ax			;save running sum
	jcxz	ab4_done
	lodsb
	dec	cx
	jmp	ab10			;loop till done

ab4_done:
	cmp	str_sign,0		;is result +
	je	ab4_done2		;jmp if + number
	neg	bx
ab4_done2:	
	sub	al,al
ab4_err:	
	pop	dx
	retf		
DEC_STR4_TO_WORD	endp



